/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.ServiceRegistry;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.query.QueryTreeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTreeBuilderRegistry {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryTreeBuilderRegistry.class);
    private static final List BUILDERS = new ArrayList();

    public static QueryTreeBuilder getQueryTreeBuilder(String language) throws InvalidQueryException {
        for (int i = 0; i < BUILDERS.size(); ++i) {
            QueryTreeBuilder builder = (QueryTreeBuilder)BUILDERS.get(i);
            if (!builder.canHandle(language)) continue;
            return builder;
        }
        throw new InvalidQueryException("Unsupported language: " + language);
    }

    static {
        try {
            Iterator it = ServiceRegistry.lookupProviders(QueryTreeBuilder.class, QueryTreeBuilderRegistry.class.getClassLoader());
            while (it.hasNext()) {
                BUILDERS.add(it.next());
            }
        }
        catch (Error e) {
            log.warn("Unable to load providers for QueryTreeBuilder: " + e);
        }
    }
}

