/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import javax.jcr.RepositoryException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.observation.EventConsumer;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.EventListenerIteratorImpl;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.observation.ObservationManagerFactory;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationManagerImpl
implements ObservationManager,
EventStateCollectionFactory {
    private static final Logger log = LoggerFactory.getLogger((Class)ObservationManagerImpl.class);
    private final SessionImpl session;
    private final ItemManager itemMgr;
    private final ObservationManagerFactory obsMgrFactory;

    ObservationManagerImpl(ObservationManagerFactory obsMgrFactory, SessionImpl session, ItemManager itemMgr) throws NullPointerException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (itemMgr == null) {
            throw new NullPointerException("itemMgr");
        }
        this.obsMgrFactory = obsMgrFactory;
        this.session = session;
        this.itemMgr = itemMgr;
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        Path path;
        NodeTypeImpl[] nodeTypes;
        if (nodeTypeName == null) {
            nodeTypes = null;
        } else {
            NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
            nodeTypes = new NodeTypeImpl[nodeTypeName.length];
            for (int i = 0; i < nodeTypes.length; ++i) {
                nodeTypes[i] = (NodeTypeImpl)ntMgr.getNodeType(nodeTypeName[i]);
            }
        }
        try {
            path = Path.create(absPath, this.session.getNamespaceResolver(), true);
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path syntax: " + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        NodeId[] ids = null;
        if (uuid != null) {
            ids = new NodeId[uuid.length];
            for (int i = 0; i < uuid.length; ++i) {
                ids[i] = NodeId.valueOf(uuid[i]);
            }
        }
        EventFilter filter = new EventFilter(this.itemMgr, this.session, eventTypes, path, isDeep, ids, nodeTypes, noLocal);
        EventConsumer consumer = new EventConsumer(this.session, listener, filter);
        this.obsMgrFactory.addConsumer(consumer);
    }

    public void removeEventListener(EventListener listener) throws RepositoryException {
        EventConsumer consumer = new EventConsumer(this.session, listener, EventFilter.BLOCK_ALL);
        this.obsMgrFactory.removeConsumer(consumer);
    }

    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        return new EventListenerIteratorImpl(this.session, this.obsMgrFactory.getSynchronousConsumers(), this.obsMgrFactory.getAsynchronousConsumers());
    }

    public void dispose() {
        try {
            EventListenerIterator it = this.getRegisteredEventListeners();
            while (it.hasNext()) {
                EventListener l = it.nextEventListener();
                log.debug("removing EventListener: " + l);
                this.removeEventListener(l);
            }
        }
        catch (RepositoryException e) {
            log.error("Internal error: Unable to dispose ObservationManager.", (Throwable)e);
        }
    }

    public EventStateCollection createEventStateCollection() {
        return new EventStateCollection(this.obsMgrFactory, this.session, null);
    }

    static {
        EventListenerIteratorImpl.class.hashCode();
    }
}

