/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.EventDispatcher;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.ObservationManagerFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.name.Path;

public class DelegatingObservationDispatcher
extends EventDispatcher {
    private final HashSet dispatchers = new HashSet();

    public void addDispatcher(ObservationManagerFactory disp) {
        this.dispatchers.add(disp);
    }

    public void removeDispatcher(ObservationManagerFactory disp) {
        this.dispatchers.remove(disp);
    }

    public EventStateCollection createEventStateCollection(SessionImpl session, Path pathPrefix) {
        return new EventStateCollection(this, session, pathPrefix);
    }

    void prepareEvents(EventStateCollection events) {
    }

    void prepareDeleted(EventStateCollection events, ChangeLog changes) {
    }

    void dispatchEvents(EventStateCollection events) {
        this.dispatch(events.getEvents(), events.getSession(), events.getPathPrefix());
    }

    public void dispatch(List eventList, SessionImpl session, Path pathPrefix) {
        Iterator iter = this.dispatchers.iterator();
        while (iter.hasNext()) {
            ObservationManagerFactory fac = (ObservationManagerFactory)iter.next();
            EventStateCollection events = new EventStateCollection(fac, session, pathPrefix);
            events.addAll(eventList);
            events.prepare();
            events.dispatch();
        }
    }
}

