/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.nodetype.converter.SchemaConversionException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.QName;
import org.apache.xerces.dom3.bootstrap.DOMImplementationRegistry;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

public class SchemaConverter {
    private static final QName XML_TEXT_NODETYPE_NAME = new QName("http://www.jcp.org/jcr/1.0", "Xmltext");
    private static final QName XML_CONTENT_PROPERTY_NAME = new QName("http://www.jcp.org/jcr/1.0", "xmlContent");
    private final HashMap nodeTypeDefs = new HashMap();
    private final HashMap nodeTypeBaseNames = new HashMap();

    public SchemaConverter(String fileName) throws SchemaConversionException {
        File file = new File(fileName);
        this.convertSchema(file);
    }

    public SchemaConverter(File file) throws SchemaConversionException {
        this.convertSchema(file);
    }

    public List getNodeTypeDefs() {
        return new ArrayList(this.nodeTypeDefs.values());
    }

    private void convertSchema(File file) throws SchemaConversionException {
        try {
            int i;
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            XSImplementation implementation = (XSImplementation)registry.getDOMImplementation("XS-Loader");
            XSLoader loader = implementation.createXSLoader(null);
            String uri = file.toURI().toString();
            XSModel xsModel = loader.loadURI(uri);
            XSNamedMap map = xsModel.getComponents((short)3);
            for (i = 0; i < map.getLength(); ++i) {
                XSTypeDefinition tDef = (XSTypeDefinition)map.item(i);
                this.checkAndConvert(tDef, null, null);
            }
            map = xsModel.getComponents((short)2);
            for (i = 0; i < map.getLength(); ++i) {
                XSElementDeclaration eDec = (XSElementDeclaration)map.item(i);
                XSTypeDefinition tDef = eDec.getTypeDefinition();
                this.checkAndConvert(tDef, eDec.getNamespace(), eDec.getName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new SchemaConversionException("XSLoader not found", e);
        }
        catch (InstantiationException e) {
            throw new SchemaConversionException("XSLoader instantiation error", e);
        }
        catch (IllegalAccessException e) {
            throw new SchemaConversionException("XSLoader access error", e);
        }
    }

    private void checkAndConvert(XSTypeDefinition tDef, String namespace, String nameHint) throws SchemaConversionException {
        XSComplexTypeDefinition ctDef;
        if (tDef.getTypeCategory() == 15 && ((ctDef = (XSComplexTypeDefinition)tDef).getContentType() != 1 || ctDef.getAttributeUses().getLength() > 0 || ctDef.getAttributeWildcard() != null)) {
            this.convertComplexTypeDef(ctDef, namespace, nameHint);
        }
    }

    private QName convertComplexTypeDef(XSComplexTypeDefinition ctDef, String namespace, String nameHint) throws SchemaConversionException {
        QName ntName;
        if (this.nodeTypeDefs.containsKey(ctDef)) {
            NodeTypeDef ntd = (NodeTypeDef)this.nodeTypeDefs.get(ctDef);
            return ntd.getName();
        }
        NodeTypeDef ntDef = new NodeTypeDef();
        this.nodeTypeDefs.put(ctDef, ntDef);
        if (ctDef.getAnonymous()) {
            if (nameHint == null) {
                throw new SchemaConversionException("Anonymous complex type definition encountered without name hint");
            }
            QName baseName = new QName(namespace = this.noNull(namespace), nameHint + "Type");
            Integer count = (Integer)this.nodeTypeBaseNames.get(baseName);
            if (count == null) {
                this.nodeTypeBaseNames.put(baseName, new Integer(0));
                ntName = baseName;
            } else {
                int newCount = count + 1;
                ntName = new QName(namespace, nameHint + "Type_" + Integer.toString(newCount));
                this.nodeTypeBaseNames.put(baseName, new Integer(newCount));
            }
        } else {
            ntName = new QName(this.noNull(ctDef.getNamespace()), ctDef.getName());
        }
        ntDef.setName(ntName);
        this.buildNodeTypeDef(ntDef, ctDef);
        return ntName;
    }

    private void buildNodeTypeDef(NodeTypeDef nodeTypeDef, XSComplexTypeDefinition ctdef) throws SchemaConversionException {
        PropDef propDef;
        ArrayList<PropDef> propDefList = new ArrayList<PropDef>();
        ArrayList<NodeDef> nodeDefList = new ArrayList<NodeDef>();
        nodeTypeDef.setSupertypes(new QName[]{QName.NT_BASE});
        nodeTypeDef.setMixin(false);
        boolean orderable = false;
        nodeTypeDef.setPrimaryItemName(null);
        XSObjectList list = ctdef.getAttributeUses();
        for (int i = 0; i < list.getLength(); ++i) {
            XSAttributeUse attribUse = (XSAttributeUse)list.item(i);
            propDef = this.attributeUseToPropDef(attribUse);
            propDefList.add(propDef);
        }
        XSWildcard wildcard = ctdef.getAttributeWildcard();
        if (wildcard != null) {
            PropDef propDef2 = this.wildcardPropDef();
            propDefList.add(propDef2);
        }
        if (ctdef.getContentType() == 1) {
            XSSimpleTypeDefinition stdef = ctdef.getSimpleType();
            propDef = this.simpleTypeToPropDef(stdef, XML_CONTENT_PROPERTY_NAME, false, false);
            propDefList.add(propDef);
        } else if (ctdef.getContentType() == 2 || ctdef.getContentType() == 3) {
            XSParticle p = ctdef.getParticle();
            orderable = this.particleToDefs(p, propDefList, nodeDefList);
        } else if (ctdef.getContentType() != 0) {
            throw new SchemaConversionException("Unrecognized content type");
        }
        if (ctdef.getContentType() == 3) {
            orderable = true;
            nodeDefList.add(this.createXMLTextNodeDef());
            this.addXMLTextNodeType();
        }
        nodeTypeDef.setOrderableChildNodes(orderable);
        QName nodeTypeName = nodeTypeDef.getName();
        ListIterator i = propDefList.listIterator();
        while (i.hasNext()) {
            PropDefImpl propDef3 = (PropDefImpl)i.next();
            propDef3.setDeclaringNodeType(nodeTypeName);
        }
        i = nodeDefList.listIterator();
        while (i.hasNext()) {
            NodeDefImpl nodeDef = (NodeDefImpl)i.next();
            nodeDef.setDeclaringNodeType(nodeTypeName);
        }
        nodeTypeDef.setPropertyDefs(propDefList.toArray(new PropDef[propDefList.size()]));
        nodeTypeDef.setChildNodeDefs(nodeDefList.toArray(new NodeDef[nodeDefList.size()]));
    }

    private boolean particleToDefs(XSParticle particle, List propDefList, List nodeDefList) throws SchemaConversionException {
        boolean orderable;
        block12: {
            XSTerm term;
            block10: {
                XSTypeDefinition tDef;
                QName name;
                boolean multiple;
                boolean mandatory;
                block11: {
                    orderable = false;
                    term = particle.getTerm();
                    if (particle.getMaxOccurs() == 0) {
                        return orderable;
                    }
                    mandatory = false;
                    if (particle.getMinOccurs() > 0) {
                        mandatory = true;
                    }
                    multiple = false;
                    if (particle.getMaxOccurs() > 1 || particle.getMaxOccursUnbounded()) {
                        multiple = true;
                    }
                    if (term.getType() != 2) break block10;
                    XSElementDeclaration eDec = (XSElementDeclaration)term;
                    name = new QName(this.noNull(eDec.getNamespace()), eDec.getName());
                    tDef = eDec.getTypeDefinition();
                    if (tDef.getTypeCategory() != 16) break block11;
                    XSSimpleTypeDefinition stDef = (XSSimpleTypeDefinition)tDef;
                    PropDef propDef = this.simpleTypeToPropDef(stDef, name, mandatory, multiple);
                    propDefList.add(propDef);
                    break block12;
                }
                if (tDef.getTypeCategory() != 15) break block12;
                XSComplexTypeDefinition ctDef = (XSComplexTypeDefinition)tDef;
                if (ctDef.getContentType() == 1 && ctDef.getAttributeUses().getLength() == 0 && ctDef.getAttributeWildcard() == null) {
                    XSSimpleTypeDefinition std = ctDef.getSimpleType();
                    PropDef pd = this.simpleTypeToPropDef(std, name, mandatory, multiple);
                    propDefList.add(pd);
                } else {
                    NodeDef nd = this.complexTypeToNodeDef(ctDef, name, mandatory, multiple);
                    nodeDefList.add(nd);
                }
                break block12;
            }
            if (term.getType() == 9) {
                nodeDefList.add(this.wildcardNodeDef());
            } else if (term.getType() == 7) {
                XSModelGroup mg = (XSModelGroup)term;
                if (mg.getCompositor() == 1) {
                    orderable = true;
                }
                XSObjectList list = mg.getParticles();
                for (int i = 0; i < list.getLength(); ++i) {
                    XSParticle pp = (XSParticle)list.item(i);
                    this.particleToDefs(pp, propDefList, nodeDefList);
                }
            }
        }
        return orderable;
    }

    private PropDef attributeUseToPropDef(XSAttributeUse au) {
        boolean mandatory = au.getRequired();
        XSAttributeDeclaration ad = au.getAttrDeclaration();
        QName name = new QName(this.noNull(ad.getNamespace()), ad.getName());
        boolean multiple = false;
        XSSimpleTypeDefinition std = ad.getTypeDefinition();
        return this.simpleTypeToPropDef(std, name, mandatory, multiple);
    }

    private PropDef simpleTypeToPropDef(XSSimpleTypeDefinition std, QName propertyName, boolean mandatory, boolean multiple) {
        PropDefImpl propDef = new PropDefImpl();
        propDef.setName(propertyName);
        propDef.setMandatory(mandatory);
        propDef.setMultiple(multiple);
        short kind = std.getBuiltInKind();
        int propertyType = this.convertBuiltInKindToPropertyType(kind);
        propDef.setRequiredType(propertyType);
        propDef.setValueConstraints(new ValueConstraint[0]);
        propDef.setDefaultValues(new InternalValue[0]);
        propDef.setAutoCreated(false);
        propDef.setOnParentVersion(1);
        propDef.setProtected(false);
        return propDef;
    }

    private NodeDef complexTypeToNodeDef(XSComplexTypeDefinition ctDef, QName nodeName, boolean mandatory, boolean multiple) throws SchemaConversionException {
        NodeDefImpl nodeDef = new NodeDefImpl();
        nodeDef.setName(nodeName);
        nodeDef.setMandatory(mandatory);
        nodeDef.setAllowsSameNameSiblings(multiple);
        QName nodeTypeName = this.convertComplexTypeDef(ctDef, nodeName.getNamespaceURI(), nodeName.getLocalName());
        nodeDef.setDefaultPrimaryType(nodeTypeName);
        nodeDef.setRequiredPrimaryTypes(new QName[]{nodeTypeName});
        nodeDef.setAutoCreated(false);
        nodeDef.setOnParentVersion(1);
        nodeDef.setProtected(false);
        return nodeDef;
    }

    private PropDef wildcardPropDef() {
        PropDefImpl propDef = new PropDefImpl();
        propDef.setName(PropDef.ANY_NAME);
        propDef.setMandatory(false);
        propDef.setMultiple(false);
        propDef.setRequiredType(0);
        propDef.setValueConstraints(new ValueConstraint[0]);
        propDef.setDefaultValues(new InternalValue[0]);
        propDef.setAutoCreated(false);
        propDef.setOnParentVersion(1);
        propDef.setProtected(false);
        return propDef;
    }

    private NodeDef wildcardNodeDef() {
        NodeDefImpl nodeDef = new NodeDefImpl();
        nodeDef.setName(NodeDef.ANY_NAME);
        nodeDef.setMandatory(false);
        nodeDef.setAllowsSameNameSiblings(false);
        nodeDef.setDefaultPrimaryType(NodeDef.ANY_NAME);
        nodeDef.setRequiredPrimaryTypes(new QName[0]);
        nodeDef.setAutoCreated(false);
        nodeDef.setOnParentVersion(1);
        nodeDef.setProtected(false);
        return nodeDef;
    }

    private NodeDef createXMLTextNodeDef() {
        NodeDefImpl nodeDef = new NodeDefImpl();
        nodeDef.setName(QName.JCR_XMLTEXT);
        nodeDef.setMandatory(false);
        nodeDef.setAllowsSameNameSiblings(true);
        nodeDef.setDefaultPrimaryType(XML_TEXT_NODETYPE_NAME);
        nodeDef.setRequiredPrimaryTypes(new QName[]{XML_TEXT_NODETYPE_NAME});
        nodeDef.setAutoCreated(false);
        nodeDef.setOnParentVersion(1);
        nodeDef.setProtected(false);
        return nodeDef;
    }

    private void addXMLTextNodeType() {
        if (this.nodeTypeDefs.containsKey(XML_TEXT_NODETYPE_NAME)) {
            return;
        }
        NodeTypeDef ntd = new NodeTypeDef();
        ntd.setName(XML_TEXT_NODETYPE_NAME);
        ntd.setSupertypes(new QName[]{QName.NT_BASE});
        ntd.setPrimaryItemName(null);
        ntd.setMixin(false);
        ntd.setOrderableChildNodes(false);
        ntd.setChildNodeDefs(new NodeDef[0]);
        PropDefImpl pd = new PropDefImpl();
        pd.setName(QName.JCR_XMLCHARACTERS);
        pd.setDeclaringNodeType(XML_TEXT_NODETYPE_NAME);
        pd.setAutoCreated(false);
        pd.setDefaultValues(new InternalValue[0]);
        pd.setMandatory(false);
        pd.setMultiple(false);
        pd.setOnParentVersion(1);
        pd.setProtected(false);
        pd.setRequiredType(1);
        pd.setValueConstraints(new ValueConstraint[0]);
        ntd.setPropertyDefs(new PropDef[]{pd});
        this.nodeTypeDefs.put(ntd.getName(), ntd);
    }

    private int convertBuiltInKindToPropertyType(short kind) {
        int propertyType;
        switch (kind) {
            case 1: 
            case 2: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                propertyType = 1;
                break;
            }
            case 3: {
                propertyType = 6;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                propertyType = 4;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                propertyType = 5;
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                propertyType = 2;
                break;
            }
            case 19: 
            case 25: 
            case 26: {
                propertyType = 7;
                break;
            }
            case 28: {
                propertyType = 9;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                propertyType = 3;
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                propertyType = 1;
                break;
            }
            default: {
                propertyType = 1;
            }
        }
        return propertyType;
    }

    private String noNull(String s) {
        return s != null ? s : "";
    }
}

