/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.compact;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;

public class CompactNodeTypeDefWriter {
    private static final String INDENT = "  ";
    private final List nodeTypeDefList;
    private final NamespaceResolver resolver;
    private final Writer out;
    private final Map namespaceMap = new HashMap();

    public CompactNodeTypeDefWriter(List l, NamespaceResolver r, Writer w) throws NamespaceException {
        this.nodeTypeDefList = l;
        this.out = w;
        this.resolver = r;
        this.buildNamespaceMap();
    }

    public void write() throws IOException, NamespaceException {
        Iterator i = this.namespaceMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String prefix = (String)e.getKey();
            String uri = (String)e.getValue();
            this.out.write("<");
            this.out.write(prefix);
            this.out.write(" = \"");
            this.out.write(uri);
            this.out.write("\">\n");
        }
        i = this.nodeTypeDefList.iterator();
        while (i.hasNext()) {
            NodeTypeDef ntd = (NodeTypeDef)((Object)i.next());
            this.writeName(ntd);
            this.writeSupertypes(ntd);
            this.writeOptions(ntd);
            this.writePropDefs(ntd);
            this.writeChildNodeDefs(ntd);
        }
    }

    public void close() throws IOException {
        this.out.flush();
    }

    private void buildNamespaceMap() throws NamespaceException {
        Iterator i = this.nodeTypeDefList.iterator();
        while (i.hasNext()) {
            NodeTypeDef ntd = (NodeTypeDef)i.next();
            this.addNamespace(ntd.getName());
            this.addNamespace(ntd.getSupertypes());
            PropDef[] pda = ntd.getPropertyDefs();
            for (int j = 0; j < pda.length; ++j) {
                PropDef pd = pda[j];
                this.addNamespace(pd.getName());
            }
            NodeDef[] nda = ntd.getChildNodeDefs();
            for (int j = 0; j < nda.length; ++j) {
                NodeDef nd = nda[j];
                this.addNamespace(nd.getName());
                this.addNamespace(nd.getRequiredPrimaryTypes());
                this.addNamespace(nd.getDefaultPrimaryType());
            }
        }
    }

    private void addNamespace(QName qn) throws NamespaceException {
        String uri = qn.getNamespaceURI();
        String prefix = this.resolver.getPrefix(uri);
        this.namespaceMap.put(prefix, uri);
    }

    private void addNamespace(QName[] qna) throws NamespaceException {
        for (int i = 0; i < qna.length; ++i) {
            QName qn = qna[i];
            this.addNamespace(qn);
        }
    }

    private void writeName(NodeTypeDef ntd) throws IOException, NamespaceException {
        this.out.write("[");
        this.out.write(this.resolve(ntd.getName()));
        this.out.write("]");
    }

    private void writeSupertypes(NodeTypeDef ntd) throws IOException, NamespaceException {
        QName[] sta = ntd.getSupertypes();
        if (sta == null) {
            return;
        }
        String delim = " > ";
        for (int i = 0; i < sta.length; ++i) {
            if (sta[i].equals(QName.NT_BASE)) continue;
            this.out.write(delim);
            this.out.write(this.resolve(sta[i]));
            delim = ", ";
        }
    }

    private void writeOptions(NodeTypeDef ntd) throws IOException {
        if (ntd.hasOrderableChildNodes()) {
            this.out.write("\n  ");
            this.out.write("orderable");
            if (ntd.isMixin()) {
                this.out.write(" mixin");
            }
        } else if (ntd.isMixin()) {
            this.out.write("\n  ");
            this.out.write("mixin");
        }
    }

    private void writePropDefs(NodeTypeDef ntd) throws IOException, NamespaceException {
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            PropDef pd = pda[i];
            this.writePropDef(ntd, pd);
        }
    }

    private void writeChildNodeDefs(NodeTypeDef ntd) throws IOException, NamespaceException {
        NodeDef[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            NodeDef nd = nda[i];
            this.writeNodeDef(ntd, nd);
        }
    }

    private void writePropDef(NodeTypeDef ntd, PropDef pd) throws IOException, NamespaceException {
        this.out.write("\n  - ");
        this.writeItemDefName(pd.getName());
        this.out.write(" (");
        this.out.write(PropertyType.nameFromValue((int)pd.getRequiredType()).toLowerCase());
        this.out.write(")");
        this.writeDefaultValues(pd.getDefaultValues());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(pd.getName()) ? " primary" : "");
        if (pd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (pd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (pd.isProtected()) {
            this.out.write(" protected");
        }
        if (pd.isMultiple()) {
            this.out.write(" multiple");
        }
        if (pd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)pd.getOnParentVersion()).toLowerCase());
        }
        this.writeValueConstraints(pd.getValueConstraints());
    }

    private void writeDefaultValues(InternalValue[] dva) throws IOException {
        if (dva == null || dva.length == 0) {
            return;
        }
        String delim = " = '";
        for (int i = 0; i < dva.length; ++i) {
            this.out.write(delim);
            try {
                this.out.write(this.escape(dva[i].toJCRValue(this.resolver).getString()));
            }
            catch (RepositoryException e) {
                this.out.write(this.escape(dva[i].toString()));
            }
            this.out.write("'");
            delim = ", '";
        }
    }

    private void writeValueConstraints(ValueConstraint[] vca) throws IOException {
        if (vca == null || vca.length == 0) {
            return;
        }
        String vc = vca[0].getDefinition(this.resolver);
        this.out.write(" < '");
        this.out.write(this.escape(vc));
        this.out.write("'");
        for (int i = 1; i < vca.length; ++i) {
            vc = vca[i].getDefinition(this.resolver);
            this.out.write(", '");
            this.out.write(this.escape(vc));
            this.out.write("'");
        }
    }

    private void writeNodeDef(NodeTypeDef ntd, NodeDef nd) throws IOException, NamespaceException {
        this.out.write("\n  + ");
        this.writeItemDefName(nd.getName());
        this.writeRequiredTypes(nd.getRequiredPrimaryTypes());
        this.writeDefaultType(nd.getDefaultPrimaryType());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(nd.getName()) ? " primary" : "");
        if (nd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (nd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (nd.isProtected()) {
            this.out.write(" protected");
        }
        if (nd.allowsSameNameSiblings()) {
            this.out.write(" multiple");
        }
        if (nd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)nd.getOnParentVersion()).toLowerCase());
        }
    }

    private void writeItemDefName(QName name) throws IOException, NamespaceException {
        String s = this.resolve(name);
        if (s.indexOf(45) >= 0 || s.indexOf(43) >= 0) {
            this.out.write(39);
            this.out.write(s);
            this.out.write(39);
        } else {
            this.out.write(s);
        }
    }

    private void writeRequiredTypes(QName[] reqTypes) throws IOException, NamespaceException {
        if (reqTypes != null && reqTypes.length > 0) {
            String delim = " (";
            for (int i = 0; i < reqTypes.length; ++i) {
                this.out.write(delim);
                this.out.write(this.resolve(reqTypes[i]));
                delim = ", ";
            }
            this.out.write(")");
        }
    }

    private void writeDefaultType(QName defType) throws IOException, NamespaceException {
        if (defType != null && !defType.getLocalName().equals("*")) {
            this.out.write(" = ");
            this.out.write(this.resolve(defType));
        }
    }

    private String resolve(QName qname) throws NamespaceException {
        if (qname == null) {
            return "";
        }
        String prefix = this.resolver.getPrefix(qname.getNamespaceURI());
        if (prefix != null && !prefix.equals("")) {
            prefix = prefix + ":";
        }
        return prefix + qname.getLocalName();
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
                continue;
            }
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++i;
        }
        return sb.toString();
    }
}

