/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefDiff;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefStore;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.nodetype.ReferenceConstraint;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeRegistry
implements Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)NodeTypeRegistry.class);
    private static final String BUILTIN_NODETYPES_RESOURCE_PATH = "org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
    private static final String CUSTOM_NODETYPES_RESOURCE_NAME = "custom_nodetypes.xml";
    private final FileSystem ntStore;
    private final FileSystemResource customNodeTypesResource;
    private final NodeTypeDefStore builtInNTDefs;
    private final NodeTypeDefStore customNTDefs;
    private final EffectiveNodeTypeCache entCache;
    private final HashMap registeredNTDefs;
    private final NodeDef rootNodeDef;
    private final HashMap propDefs;
    private final HashMap nodeDefs;
    private final NamespaceRegistry nsReg;
    private boolean checkAutoCreatePropHasDefault = true;
    private final Map listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));

    public static NodeTypeRegistry create(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        NodeTypeRegistry ntMgr = new NodeTypeRegistry(nsReg, ntStore);
        return ntMgr;
    }

    protected NodeTypeRegistry(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        this.nsReg = nsReg;
        this.ntStore = ntStore;
        this.customNodeTypesResource = new FileSystemResource(this.ntStore, CUSTOM_NODETYPES_RESOURCE_NAME);
        try {
            if (!this.customNodeTypesResource.exists()) {
                this.customNodeTypesResource.makeParentDirs();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: invalid resource: " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
        this.entCache = new EffectiveNodeTypeCache();
        this.registeredNTDefs = new HashMap();
        this.propDefs = new HashMap();
        this.nodeDefs = new HashMap();
        this.rootNodeDef = NodeTypeRegistry.createRootNodeDef();
        this.nodeDefs.put(this.rootNodeDef.getId(), this.rootNodeDef);
        this.checkAutoCreatePropHasDefault = false;
        this.builtInNTDefs = new NodeTypeDefStore();
        try {
            this.loadBuiltInNodeTypeDefs(this.builtInNTDefs);
            this.internalRegister(this.builtInNTDefs.all());
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
            log.debug(error);
            throw new RepositoryException(error, (Throwable)intde);
        }
        finally {
            this.checkAutoCreatePropHasDefault = true;
        }
        this.customNTDefs = new NodeTypeDefStore();
        this.loadCustomNodeTypeDefs(this.customNTDefs);
        try {
            this.internalRegister(this.customNTDefs.all());
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)intde);
        }
    }

    private static NodeDef createRootNodeDef() {
        NodeDefImpl def = new NodeDefImpl();
        def.setDeclaringNodeType(QName.REP_ROOT);
        def.setRequiredPrimaryTypes(new QName[]{QName.REP_ROOT});
        def.setDefaultPrimaryType(QName.REP_ROOT);
        def.setMandatory(true);
        def.setProtected(false);
        def.setOnParentVersion(2);
        def.setAllowsSameNameSiblings(false);
        def.setAutoCreated(true);
        return def;
    }

    private EffectiveNodeType internalRegister(NodeTypeDef ntd) throws InvalidNodeTypeDefException, RepositoryException {
        QName name = ntd.getName();
        if (name != null && this.registeredNTDefs.containsKey(name)) {
            String msg = name + " already exists";
            log.debug(msg);
            throw new InvalidNodeTypeDefException(msg);
        }
        EffectiveNodeType ent = this.validateNodeTypeDef(ntd, this.entCache, this.registeredNTDefs);
        this.entCache.put(ent);
        ntd = (NodeTypeDef)ntd.clone();
        this.registeredNTDefs.put(name, ntd);
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            this.propDefs.put(pda[i].getId(), pda[i]);
        }
        NodeDef[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            this.nodeDefs.put(nda[i].getId(), nda[i]);
        }
        return ent;
    }

    private synchronized void internalRegister(Collection ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        NodeTypeDef ntd;
        EffectiveNodeTypeCache anEntCache = (EffectiveNodeTypeCache)this.entCache.clone();
        HashMap<QName, NodeTypeDef> aRegisteredNTDefCache = new HashMap<QName, NodeTypeDef>(this.registeredNTDefs);
        Iterator iter = ntDefs.iterator();
        while (iter.hasNext()) {
            ntd = (NodeTypeDef)iter.next();
            QName name = ntd.getName();
            if (name != null && this.registeredNTDefs.containsKey(name)) {
                String msg = name + " already exists";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            aRegisteredNTDefCache.put(ntd.getName(), ntd);
        }
        iter = ntDefs.iterator();
        while (iter.hasNext()) {
            ntd = (NodeTypeDef)iter.next();
            EffectiveNodeType ent = this.validateNodeTypeDef(ntd, anEntCache, aRegisteredNTDefCache);
            anEntCache.put(ent);
        }
        iter = ntDefs.iterator();
        while (iter.hasNext()) {
            ntd = (NodeTypeDef)iter.next();
            ntd = (NodeTypeDef)ntd.clone();
            this.registeredNTDefs.put(ntd.getName(), ntd);
            PropDef[] pda = ntd.getPropertyDefs();
            for (int i = 0; i < pda.length; ++i) {
                this.propDefs.put(pda[i].getId(), pda[i]);
            }
            NodeDef[] nda = ntd.getChildNodeDefs();
            for (int i = 0; i < nda.length; ++i) {
                this.nodeDefs.put(nda[i].getId(), nda[i]);
            }
        }
    }

    private void internalUnregister(QName name) throws NoSuchNodeTypeException {
        NodeTypeDef ntd = (NodeTypeDef)this.registeredNTDefs.get(name);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        this.registeredNTDefs.remove(name);
        ArrayList keys = new ArrayList(this.entCache.keySet());
        Iterator keysIter = keys.iterator();
        while (keysIter.hasNext()) {
            EffectiveNodeTypeCache.WeightedKey k = (EffectiveNodeTypeCache.WeightedKey)keysIter.next();
            EffectiveNodeType ent = this.entCache.get(k);
            if (!ent.includesNodeType(name)) continue;
            this.entCache.remove(k);
        }
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            this.propDefs.remove(pda[i].getId());
        }
        NodeDef[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            this.nodeDefs.remove(nda[i].getId());
        }
    }

    private void internalUnregister(Collection ntNames) throws NoSuchNodeTypeException {
        Iterator iter = ntNames.iterator();
        while (iter.hasNext()) {
            QName name = (QName)iter.next();
            this.internalUnregister(name);
        }
    }

    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyRegistered(QName ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(QName ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(QName ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeUnregistered(ntName);
        }
    }

    private void checkNamespace(QName name) throws RepositoryException {
        if (name != null) {
            this.nsReg.getPrefix(name.getNamespaceURI());
        }
    }

    private EffectiveNodeType validateNodeTypeDef(NodeTypeDef ntd, EffectiveNodeTypeCache anEntCache, Map aRegisteredNTDefCache) throws InvalidNodeTypeDefException, RepositoryException {
        String msg;
        String msg2;
        QName name;
        EffectiveNodeType ent;
        block48: {
            ent = null;
            name = ntd.getName();
            if (name == null) {
                String msg3 = "no name specified";
                log.debug(msg3);
                throw new InvalidNodeTypeDefException(msg3);
            }
            this.checkNamespace(name);
            QName[] supertypes = ntd.getSupertypes();
            if (supertypes != null && supertypes.length > 0) {
                for (int i = 0; i < supertypes.length; ++i) {
                    this.checkNamespace(supertypes[i]);
                    if (name.equals(supertypes[i])) {
                        String msg4 = "[" + name + "] invalid supertype: " + supertypes[i] + " (infinite recursion))";
                        log.debug(msg4);
                        throw new InvalidNodeTypeDefException(msg4);
                    }
                    if (aRegisteredNTDefCache.containsKey(supertypes[i])) continue;
                    String msg5 = "[" + name + "] invalid supertype: " + supertypes[i];
                    log.debug(msg5);
                    throw new InvalidNodeTypeDefException(msg5);
                }
                Stack<QName> inheritanceChain = new Stack<QName>();
                inheritanceChain.push(name);
                this.checkForCircularInheritance(supertypes, inheritanceChain, aRegisteredNTDefCache);
            }
            if (supertypes != null && supertypes.length > 0) {
                try {
                    EffectiveNodeType est = this.getEffectiveNodeType(supertypes, anEntCache, aRegisteredNTDefCache);
                    if (!(ntd.isMixin() || QName.NT_BASE.equals(ntd.getName()) || est.includesNodeType(QName.NT_BASE))) {
                        String msg6 = "[" + name + "] all primary node types except" + " nt:base itself must be (directly or indirectly) derived from nt:base";
                        log.debug(msg6);
                        throw new InvalidNodeTypeDefException(msg6);
                    }
                    break block48;
                }
                catch (NodeTypeConflictException ntce) {
                    String msg7 = "[" + name + "] failed to validate supertypes";
                    log.debug(msg7);
                    throw new InvalidNodeTypeDefException(msg7, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String msg8 = "[" + name + "] failed to validate supertypes";
                    log.debug(msg8);
                    throw new InvalidNodeTypeDefException(msg8, nsnte);
                }
            }
            if (!ntd.isMixin() && !QName.NT_BASE.equals(ntd.getName())) {
                String msg9 = "[" + name + "] all primary node types except nt:base itself must be (directly or indirectly) derived from nt:base";
                log.debug(msg9);
                throw new InvalidNodeTypeDefException(msg9);
            }
        }
        this.checkNamespace(ntd.getPrimaryItemName());
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            ValueConstraint[] constraints;
            int j;
            PropDef pd = pda[i];
            if (!name.equals(pd.getDeclaringNodeType())) {
                msg2 = "[" + name + "#" + pd.getName() + "] invalid declaring node type specified";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            this.checkNamespace(pd.getName());
            if (pd.definesResidual() && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a name";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            if (pd.getRequiredType() == 0 && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a type";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            InternalValue[] defVals = pd.getDefaultValues();
            if (defVals != null && defVals.length != 0) {
                int reqType = pd.getRequiredType();
                for (j = 0; j < defVals.length; ++j) {
                    if (reqType == 0) {
                        reqType = defVals[j].getType();
                        continue;
                    }
                    if (defVals[j].getType() == reqType) continue;
                    String msg10 = "[" + name + "#" + pd.getName() + "] type of default value(s) is not consistent with required property type";
                    log.debug(msg10);
                    throw new InvalidNodeTypeDefException(msg10);
                }
            } else if (this.checkAutoCreatePropHasDefault && pd.isAutoCreated()) {
                msg = "[" + name + "#" + pd.getName() + "] auto-created property must have a default value";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if ((constraints = pd.getValueConstraints()) == null || constraints.length <= 0) continue;
            if (defVals != null && defVals.length > 0) {
                for (j = 0; j < defVals.length; ++j) {
                    boolean satisfied = false;
                    ConstraintViolationException cve = null;
                    for (int k = 0; k < constraints.length; ++k) {
                        try {
                            constraints[k].check(defVals[j]);
                            satisfied = true;
                            break;
                        }
                        catch (ConstraintViolationException e) {
                            cve = e;
                            continue;
                        }
                    }
                    if (satisfied) continue;
                    String msg11 = "[" + name + "#" + pd.getName() + "] default value does not satisfy value constraint";
                    log.debug(msg11);
                    throw new InvalidNodeTypeDefException(msg11, cve);
                }
            }
            if (pd.getRequiredType() != 9) continue;
            for (j = 0; j < constraints.length; ++j) {
                ReferenceConstraint rc = (ReferenceConstraint)constraints[j];
                QName ntName = rc.getNodeTypeName();
                if (name.equals(ntName) || aRegisteredNTDefCache.containsKey(ntName)) continue;
                String msg12 = "[" + name + "#" + pd.getName() + "] invalid REFERENCE value constraint '" + ntName + "' (unknown node type)";
                log.debug(msg12);
                throw new InvalidNodeTypeDefException(msg12);
            }
        }
        NodeDef[] cnda = ntd.getChildNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            QName[] reqTypes;
            NodeDef cnd = cnda[i];
            if (!name.equals(cnd.getDeclaringNodeType())) {
                msg = "[" + name + "#" + cnd.getName() + "] invalid declaring node type specified";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            this.checkNamespace(cnd.getName());
            if (cnd.definesResidual() && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a name";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if (cnd.getDefaultPrimaryType() == null && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a default primary type";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            QName dpt = cnd.getDefaultPrimaryType();
            this.checkNamespace(dpt);
            boolean referenceToSelf = false;
            EffectiveNodeType defaultENT = null;
            if (dpt != null) {
                if (name.equals(dpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(dpt) && !aRegisteredNTDefCache.containsKey(dpt)) {
                    String msg13 = "[" + name + "#" + cnd.getName() + "] invalid default primary type '" + dpt + "'";
                    log.debug(msg13);
                    throw new InvalidNodeTypeDefException(msg13);
                }
                try {
                    defaultENT = !referenceToSelf ? this.getEffectiveNodeType(dpt, anEntCache, aRegisteredNTDefCache) : (ent = EffectiveNodeType.create(this, ntd, anEntCache, aRegisteredNTDefCache));
                    if (cnd.isAutoCreated()) {
                        Stack<QName> definingNTs = new Stack<QName>();
                        definingNTs.push(name);
                        this.checkForCircularNodeAutoCreation(defaultENT, definingNTs, anEntCache, aRegisteredNTDefCache);
                    }
                }
                catch (NodeTypeConflictException ntce) {
                    String msg14 = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(msg14);
                    throw new InvalidNodeTypeDefException(msg14, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String msg15 = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(msg15);
                    throw new InvalidNodeTypeDefException(msg15, nsnte);
                }
            }
            if ((reqTypes = cnd.getRequiredPrimaryTypes()) == null || reqTypes.length <= 0) continue;
            for (int n = 0; n < reqTypes.length; ++n) {
                QName rpt = reqTypes[n];
                this.checkNamespace(rpt);
                referenceToSelf = false;
                if (name.equals(rpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(rpt) && !aRegisteredNTDefCache.containsKey(rpt)) {
                    String msg16 = "[" + name + "#" + cnd.getName() + "] invalid required primary type: " + rpt;
                    log.debug(msg16);
                    throw new InvalidNodeTypeDefException(msg16);
                }
                if (defaultENT != null && !defaultENT.includesNodeType(rpt)) {
                    String msg17 = "[" + name + "#" + cnd.getName() + "] default primary type does not satisfy required primary type constraint " + rpt;
                    log.debug(msg17);
                    throw new InvalidNodeTypeDefException(msg17);
                }
                try {
                    if (!referenceToSelf) {
                        this.getEffectiveNodeType(rpt, anEntCache, aRegisteredNTDefCache);
                        continue;
                    }
                    if (ent != null) continue;
                    ent = EffectiveNodeType.create(this, ntd, anEntCache, aRegisteredNTDefCache);
                    continue;
                }
                catch (NodeTypeConflictException ntce) {
                    String msg18 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg18);
                    throw new InvalidNodeTypeDefException(msg18, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String msg19 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg19);
                    throw new InvalidNodeTypeDefException(msg19, nsnte);
                }
            }
        }
        if (ent == null) {
            try {
                ent = EffectiveNodeType.create(this, ntd, anEntCache, aRegisteredNTDefCache);
            }
            catch (NodeTypeConflictException ntce) {
                msg2 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                msg2 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2, nsnte);
            }
        }
        return ent;
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(QName ntName, EffectiveNodeTypeCache anEntCache, Map aRegisteredNTDefCache) throws NoSuchNodeTypeException {
        EffectiveNodeType ent = anEntCache.get(new QName[]{ntName});
        if (ent != null) {
            return ent;
        }
        if (!aRegisteredNTDefCache.containsKey(ntName)) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        try {
            NodeTypeDef ntd = (NodeTypeDef)aRegisteredNTDefCache.get(ntName);
            ent = EffectiveNodeType.create(this, ntd, anEntCache, aRegisteredNTDefCache);
            anEntCache.put(ent);
            return ent;
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: encountered invalid registered node type " + ntName;
            log.debug(msg);
            throw new NoSuchNodeTypeException(msg, (Throwable)ntce);
        }
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(QName[] ntNames, EffectiveNodeTypeCache anEntCache, Map aRegisteredNTDefCache) throws NodeTypeConflictException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.WeightedKey key = new EffectiveNodeTypeCache.WeightedKey(ntNames);
        if (anEntCache.contains(key)) {
            return anEntCache.get(key);
        }
        for (int i = 0; i < ntNames.length; ++i) {
            if (aRegisteredNTDefCache.containsKey(ntNames[i])) continue;
            throw new NoSuchNodeTypeException(ntNames[i].toString());
        }
        EffectiveNodeType result = null;
        ArrayList<EffectiveNodeType> tmpResults = new ArrayList<EffectiveNodeType>();
        while (key.getNames().length > 0) {
            if (anEntCache.contains(key)) {
                tmpResults.add(anEntCache.get(key));
                key = key.subtract(key);
                break;
            }
            boolean foundSubResult = false;
            Iterator iter = anEntCache.keyIterator();
            while (iter.hasNext()) {
                EffectiveNodeTypeCache.WeightedKey k = (EffectiveNodeTypeCache.WeightedKey)iter.next();
                if (!key.contains(k)) continue;
                tmpResults.add(anEntCache.get(k));
                key = key.subtract(k);
                foundSubResult = true;
                break;
            }
            if (foundSubResult) continue;
            QName[] remainder = key.getNames();
            for (int i = 0; i < remainder.length; ++i) {
                NodeTypeDef ntd = (NodeTypeDef)aRegisteredNTDefCache.get(remainder[i]);
                EffectiveNodeType ent = EffectiveNodeType.create(this, ntd, anEntCache, aRegisteredNTDefCache);
                anEntCache.put(ent);
                if (result == null) {
                    result = ent;
                    continue;
                }
                result = result.merge(ent);
                anEntCache.put(result);
            }
            tmpResults.add(result);
            break;
        }
        for (int i = 0; i < tmpResults.size(); ++i) {
            if (result == null) {
                result = (EffectiveNodeType)tmpResults.get(i);
                continue;
            }
            result = result.merge((EffectiveNodeType)tmpResults.get(i));
            anEntCache.put(result);
        }
        return result;
    }

    public synchronized QName[] getRegisteredNodeTypes() {
        return this.registeredNTDefs.keySet().toArray(new QName[this.registeredNTDefs.size()]);
    }

    public NodeDef getRootNodeDef() {
        return this.rootNodeDef;
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(QName ntName) throws NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntName, this.entCache, (Map)this.registeredNTDefs);
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(QName[] ntNames) throws NodeTypeConflictException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, (Map)this.registeredNTDefs);
    }

    void checkForCircularInheritance(QName[] supertypes, Stack inheritanceChain, Map aRegisteredNTDefCache) throws InvalidNodeTypeDefException, RepositoryException {
        for (int i = 0; i < supertypes.length; ++i) {
            QName nt = supertypes[i];
            int pos = inheritanceChain.lastIndexOf(nt);
            if (pos >= 0) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < inheritanceChain.size(); ++j) {
                    if (j == pos) {
                        buf.append("--> ");
                    }
                    buf.append(inheritanceChain.get(j));
                    buf.append(" extends ");
                }
                buf.append("--> ");
                buf.append(nt);
                throw new InvalidNodeTypeDefException("circular inheritance detected: " + buf.toString());
            }
            try {
                NodeTypeDef ntd = (NodeTypeDef)aRegisteredNTDefCache.get(nt);
                QName[] sta = ntd.getSupertypes();
                if (sta == null || sta.length <= 0) continue;
                inheritanceChain.push(nt);
                this.checkForCircularInheritance(sta, inheritanceChain, aRegisteredNTDefCache);
                inheritanceChain.pop();
                continue;
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = "unknown supertype: " + nt;
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    void checkForCircularNodeAutoCreation(EffectiveNodeType childNodeENT, Stack definingParentNTs, EffectiveNodeTypeCache anEntCache, Map aRegisteredNTDefCache) throws InvalidNodeTypeDefException {
        QName[] childNodeNTs = childNodeENT.getAllNodeTypes();
        for (int i = 0; i < childNodeNTs.length; ++i) {
            QName nt = childNodeNTs[i];
            int pos = definingParentNTs.lastIndexOf(nt);
            if (pos < 0) continue;
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < definingParentNTs.size(); ++j) {
                if (j == pos) {
                    buf.append("--> ");
                }
                buf.append("node type ");
                buf.append(definingParentNTs.get(j));
                buf.append(" defines auto-created child node with default ");
            }
            buf.append("--> ");
            buf.append("node type ");
            buf.append(nt);
            throw new InvalidNodeTypeDefException("circular node auto-creation detected: " + buf.toString());
        }
        NodeDef[] nodeDefs = childNodeENT.getAutoCreateNodeDefs();
        for (int i = 0; i < nodeDefs.length; ++i) {
            QName dnt = nodeDefs[i].getDefaultPrimaryType();
            QName definingNT = nodeDefs[i].getDeclaringNodeType();
            try {
                if (dnt == null) continue;
                definingParentNTs.push(definingNT);
                this.checkForCircularNodeAutoCreation(this.getEffectiveNodeType(dnt, anEntCache, aRegisteredNTDefCache), definingParentNTs, anEntCache, aRegisteredNTDefCache);
                definingParentNTs.pop();
                continue;
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = definingNT + " defines invalid default node type for child node " + nodeDefs[i].getName();
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    public synchronized EffectiveNodeType registerNodeType(NodeTypeDef ntd) throws InvalidNodeTypeDefException, RepositoryException {
        EffectiveNodeType ent = this.internalRegister(ntd);
        this.customNTDefs.add(ntd);
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        this.notifyRegistered(ntd.getName());
        return ent;
    }

    public synchronized void registerNodeTypes(Collection ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        NodeTypeDef ntDef;
        this.internalRegister(ntDefs);
        Iterator iter = ntDefs.iterator();
        while (iter.hasNext()) {
            ntDef = (NodeTypeDef)iter.next();
            this.customNTDefs.add(ntDef);
        }
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        iter = ntDefs.iterator();
        while (iter.hasNext()) {
            ntDef = (NodeTypeDef)iter.next();
            this.notifyRegistered(ntDef.getName());
        }
    }

    public synchronized void unregisterNodeTypes(Collection ntNames) throws NoSuchNodeTypeException, RepositoryException {
        QName ntName;
        Iterator iter = ntNames.iterator();
        while (iter.hasNext()) {
            ntName = (QName)iter.next();
            if (!this.registeredNTDefs.containsKey(ntName)) {
                throw new NoSuchNodeTypeException(ntName.toString());
            }
            if (this.builtInNTDefs.contains(ntName)) {
                throw new RepositoryException(ntName.toString() + ": can't unregister built-in node type.");
            }
            Set dependents = this.getDependentNodeTypes(ntName);
            dependents.removeAll(ntNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName + " can not be removed because the following node types depend on it: ");
            Iterator depIter = dependents.iterator();
            while (depIter.hasNext()) {
                msg.append(depIter.next());
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        iter = ntNames.iterator();
        while (iter.hasNext()) {
            ntName = (QName)iter.next();
            this.checkForReferencesInContent(ntName);
        }
        this.internalUnregister(ntNames);
        iter = ntNames.iterator();
        while (iter.hasNext()) {
            ntName = (QName)iter.next();
            this.customNTDefs.remove(ntName);
            this.notifyUnregistered(ntName);
        }
        this.persistCustomNodeTypeDefs(this.customNTDefs);
    }

    public synchronized void unregisterNodeType(QName ntName) throws NoSuchNodeTypeException, RepositoryException {
        HashSet<QName> ntNames = new HashSet<QName>();
        ntNames.add(ntName);
        this.unregisterNodeTypes(ntNames);
    }

    public synchronized EffectiveNodeType reregisterNodeType(NodeTypeDef ntd) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        QName name = ntd.getName();
        if (!this.registeredNTDefs.containsKey(name)) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        if (this.builtInNTDefs.contains(name)) {
            throw new RepositoryException(name.toString() + ": can't reregister built-in node type.");
        }
        this.validateNodeTypeDef(ntd, this.entCache, this.registeredNTDefs);
        NodeTypeDef ntdOld = (NodeTypeDef)this.registeredNTDefs.get(name);
        NodeTypeDefDiff diff = NodeTypeDefDiff.create(ntdOld, ntd);
        if (!diff.isModified()) {
            return this.getEffectiveNodeType(name);
        }
        if (diff.isTrivial()) {
            this.internalUnregister(name);
            this.customNTDefs.remove(name);
            EffectiveNodeType entNew = this.internalRegister(ntd);
            this.customNTDefs.add(ntd);
            this.persistCustomNodeTypeDefs(this.customNTDefs);
            this.notifyReRegistered(name);
            return entNew;
        }
        this.checkForConflictingContent(ntd);
        this.internalUnregister(name);
        EffectiveNodeType entNew = this.internalRegister(ntd);
        this.customNTDefs.remove(name);
        this.customNTDefs.add(ntd);
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        this.notifyReRegistered(name);
        return entNew;
    }

    public synchronized Set getDependentNodeTypes(QName nodeTypeName) throws NoSuchNodeTypeException {
        if (!this.registeredNTDefs.containsKey(nodeTypeName)) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        HashSet<QName> names = new HashSet<QName>();
        Iterator iter = this.registeredNTDefs.values().iterator();
        while (iter.hasNext()) {
            NodeTypeDef ntd = (NodeTypeDef)iter.next();
            if (!ntd.getDependencies().contains(nodeTypeName)) continue;
            names.add(ntd.getName());
        }
        return names;
    }

    public synchronized NodeTypeDef getNodeTypeDef(QName nodeTypeName) throws NoSuchNodeTypeException {
        if (!this.registeredNTDefs.containsKey(nodeTypeName)) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        NodeTypeDef def = (NodeTypeDef)this.registeredNTDefs.get(nodeTypeName);
        return (NodeTypeDef)def.clone();
    }

    public synchronized boolean isRegistered(QName nodeTypeName) {
        return this.registeredNTDefs.containsKey(nodeTypeName);
    }

    public synchronized boolean isBuiltIn(QName nodeTypeName) {
        return this.builtInNTDefs.contains(nodeTypeName);
    }

    public NodeDef getNodeDef(NodeDefId id) {
        return (NodeDef)this.nodeDefs.get(id);
    }

    public PropDef getPropDef(PropDefId id) {
        return (PropDef)this.propDefs.get(id);
    }

    public void dump(PrintStream ps) {
        ps.println("NodeTypeRegistry (" + this + ")");
        ps.println();
        ps.println("Registered NodeTypes:");
        ps.println();
        Iterator iter = this.registeredNTDefs.values().iterator();
        while (iter.hasNext()) {
            NodeTypeDef ntd = (NodeTypeDef)iter.next();
            ps.println(ntd.getName());
            QName[] supertypes = ntd.getSupertypes();
            ps.println("\tSupertypes");
            for (int i = 0; i < supertypes.length; ++i) {
                ps.println("\t\t" + supertypes[i]);
            }
            ps.println("\tMixin\t" + ntd.isMixin());
            ps.println("\tOrderableChildNodes\t" + ntd.hasOrderableChildNodes());
            ps.println("\tPrimaryItemName\t" + (ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString()));
            PropDef[] pd = ntd.getPropertyDefs();
            for (int i = 0; i < pd.length; ++i) {
                ps.print("\tPropertyDefinition");
                ps.println(" (declared in " + pd[i].getDeclaringNodeType() + ") id=" + pd[i].getId());
                ps.println("\t\tName\t\t" + (pd[i].definesResidual() ? "*" : pd[i].getName().toString()));
                String type = pd[i].getRequiredType() == 0 ? "null" : PropertyType.nameFromValue((int)pd[i].getRequiredType());
                ps.println("\t\tRequiredType\t" + type);
                ValueConstraint[] vca = pd[i].getValueConstraints();
                StringBuffer constraints = new StringBuffer();
                if (vca == null) {
                    constraints.append("<null>");
                } else {
                    for (int n = 0; n < vca.length; ++n) {
                        if (constraints.length() > 0) {
                            constraints.append(", ");
                        }
                        constraints.append(vca[n].getDefinition());
                    }
                }
                ps.println("\t\tValueConstraints\t" + constraints.toString());
                InternalValue[] defVals = pd[i].getDefaultValues();
                StringBuffer defaultValues = new StringBuffer();
                if (defVals == null) {
                    defaultValues.append("<null>");
                } else {
                    for (int n = 0; n < defVals.length; ++n) {
                        if (defaultValues.length() > 0) {
                            defaultValues.append(", ");
                        }
                        defaultValues.append(defVals[n].toString());
                    }
                }
                ps.println("\t\tDefaultValue\t" + defaultValues.toString());
                ps.println("\t\tAutoCreated\t" + pd[i].isAutoCreated());
                ps.println("\t\tMandatory\t" + pd[i].isMandatory());
                ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)pd[i].getOnParentVersion()));
                ps.println("\t\tProtected\t" + pd[i].isProtected());
                ps.println("\t\tMultiple\t" + pd[i].isMultiple());
            }
            NodeDef[] nd = ntd.getChildNodeDefs();
            for (int i = 0; i < nd.length; ++i) {
                QName defPrimaryType;
                ps.print("\tNodeDefinition");
                ps.println(" (declared in " + nd[i].getDeclaringNodeType() + ") id=" + nd[i].getId());
                ps.println("\t\tName\t\t" + (nd[i].definesResidual() ? "*" : nd[i].getName().toString()));
                QName[] reqPrimaryTypes = nd[i].getRequiredPrimaryTypes();
                if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                    for (int n = 0; n < reqPrimaryTypes.length; ++n) {
                        ps.print("\t\tRequiredPrimaryType\t" + reqPrimaryTypes[n]);
                    }
                }
                if ((defPrimaryType = nd[i].getDefaultPrimaryType()) != null) {
                    ps.print("\n\t\tDefaultPrimaryType\t" + defPrimaryType);
                }
                ps.println("\n\t\tAutoCreated\t" + nd[i].isAutoCreated());
                ps.println("\t\tMandatory\t" + nd[i].isMandatory());
                ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)nd[i].getOnParentVersion()));
                ps.println("\t\tProtected\t" + nd[i].isProtected());
                ps.println("\t\tAllowsSameNameSiblings\t" + nd[i].allowsSameNameSiblings());
            }
        }
        ps.println();
        this.entCache.dump(ps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadBuiltInNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(BUILTIN_NODETYPES_RESOURCE_PATH);
                store.load(in);
            }
            catch (IOException ioe) {
                String error = "internal error: failed to read built-in node type definitions stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
                log.debug(error);
                throw new RepositoryException(error, (Throwable)ioe);
            }
            catch (InvalidNodeTypeDefException intde) {
                String error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
                log.debug(error);
                throw new RepositoryException(error, (Throwable)intde);
            }
            Object var6_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        in.close();
        return;
    }

    protected void loadCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            if (this.customNodeTypesResource.exists()) {
                in = this.customNodeTypesResource.getInputStream();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: failed to access custom node type definitions stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
        if (in == null) {
            log.info("no custom node type definitions found");
        } else {
            try {
                store.load(in);
            }
            catch (IOException ioe) {
                String error = "internal error: failed to read custom node type definitions stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)ioe);
            }
            catch (InvalidNodeTypeDefException intde) {
                String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)intde);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void persistCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        OutputStream out = null;
        try {
            try {
                out = this.customNodeTypesResource.getOutputStream();
                store.store(out, this.nsReg);
            }
            catch (IOException ioe) {
                String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)ioe);
            }
            catch (FileSystemException fse) {
                String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)fse);
            }
            Object var6_3 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        out.close();
        return;
    }

    protected void checkForConflictingContent(NodeTypeDef ntd) throws RepositoryException {
        throw new RepositoryException("not yet implemented");
    }

    protected void checkForReferencesInContent(QName nodeTypeName) throws RepositoryException {
        throw new RepositoryException("not yet implemented");
    }
}

