/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyImpl
extends ItemImpl
implements Property {
    private static Logger log = LoggerFactory.getLogger((Class)PropertyImpl.class);
    private PropertyDefinition definition;

    PropertyImpl(ItemManager itemMgr, SessionImpl session, PropertyId id, PropertyState state, PropertyDefinition definition, ItemLifeCycleListener[] listeners) {
        super(itemMgr, session, id, state, listeners);
        this.definition = definition;
    }

    protected synchronized ItemState getOrCreateTransientItemState() throws RepositoryException {
        if (!this.isTransient()) {
            try {
                PropertyState transientState = this.stateMgr.createTransientPropertyState((PropertyState)this.state, 2);
                this.state.removeListener(this);
                transientState.addListener(this);
                this.state = transientState;
            }
            catch (ItemStateException ise) {
                String msg = "failed to create transient state";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makePersistent() throws InvalidItemStateException {
        if (!this.isTransient()) {
            log.debug(this.safeGetJCRPath() + " (" + this.id + "): there's no transient state to persist");
            return;
        }
        PropertyState transientState = (PropertyState)this.state;
        PropertyState persistentState = (PropertyState)transientState.getOverlayedState();
        if (persistentState == null) {
            persistentState = this.stateMgr.createNew(transientState);
        }
        PropertyState propertyState = persistentState;
        synchronized (propertyState) {
            if (transientState.isStale()) {
                String msg = this.safeGetJCRPath() + ": the property cannot be saved because it has been modified externally.";
                log.debug(msg);
                throw new InvalidItemStateException(msg);
            }
            persistentState.setDefinitionId(transientState.getDefinitionId());
            persistentState.setType(transientState.getType());
            persistentState.setMultiValued(transientState.isMultiValued());
            persistentState.setValues(transientState.getValues());
            this.stateMgr.store(persistentState);
        }
        transientState.removeListener(this);
        persistentState.addListener(this);
        this.stateMgr.disconnectTransientItemState(transientState);
        this.state = persistentState;
        this.status = 0;
    }

    protected void restoreTransient(PropertyState transientState) throws RepositoryException {
        PropertyState thisState = (PropertyState)this.getOrCreateTransientItemState();
        if (transientState.getStatus() == 4 && thisState.getStatus() != 4) {
            thisState.setStatus(4);
            this.stateMgr.disconnectTransientItemState(thisState);
        }
        thisState.setDefinitionId(transientState.getDefinitionId());
        thisState.setType(transientState.getType());
        thisState.setMultiValued(transientState.isMultiValued());
        thisState.setValues(transientState.getValues());
    }

    protected long getLength(InternalValue value) throws RepositoryException {
        switch (value.getType()) {
            case 1: 
            case 3: 
            case 4: {
                return value.toString().length();
            }
            case 7: {
                QName name = (QName)value.internalValue();
                try {
                    return this.session.getNamespaceResolver().getJCRName(name).length();
                }
                catch (NoPrefixDeclaredException npde) {
                    String msg = this.safeGetJCRPath() + ": the value represents an invalid name";
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)npde);
                }
            }
            case 8: {
                Path path = (Path)value.internalValue();
                try {
                    return path.toJCRPath(this.session.getNamespaceResolver()).length();
                }
                catch (NoPrefixDeclaredException npde) {
                    String msg = this.safeGetJCRPath() + ": the value represents an invalid path";
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)npde);
                }
            }
            case 2: {
                BLOBFileValue blob = (BLOBFileValue)value.internalValue();
                return blob.getLength();
            }
        }
        return -1L;
    }

    protected void checkSetValue(boolean multipleValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        NodeImpl parent = (NodeImpl)this.getParent();
        if (!parent.internalIsCheckedOut()) {
            throw new VersionException("cannot set the value of a property of a checked-in node " + this.safeGetJCRPath());
        }
        if (this.definition.isProtected()) {
            throw new ConstraintViolationException("cannot set the value of a protected property " + this.safeGetJCRPath());
        }
        if (multipleValues) {
            if (!this.definition.isMultiple()) {
                throw new ValueFormatException(this.safeGetJCRPath() + " is not multi-valued");
            }
        } else if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be set to an array of values");
        }
        parent.checkLock();
    }

    protected void internalSetValue(InternalValue[] values, int type) throws ConstraintViolationException, RepositoryException {
        if (values == null) {
            ((NodeImpl)this.getParent()).removeChildProperty(((PropertyId)this.id).getName());
            return;
        }
        ArrayList<InternalValue> list = new ArrayList<InternalValue>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            list.add(values[i]);
        }
        values = list.toArray(new InternalValue[list.size()]);
        PropertyState thisState = (PropertyState)this.getOrCreateTransientItemState();
        InternalValue[] oldValues = thisState.getValues();
        if (oldValues != null) {
            for (int i = 0; i < oldValues.length; ++i) {
                InternalValue old = oldValues[i];
                if (old == null || old.getType() != 2) continue;
                ((BLOBFileValue)old.internalValue()).discard();
            }
        }
        thisState.setValues(values);
        if (type == 0) {
            type = 1;
        }
        thisState.setType(type);
    }

    public void setValue(QName name) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 7;
        }
        if (name == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        InternalValue internalValue = reqType != 7 ? InternalValue.create(InternalValue.create(name).toJCRValue(this.session.getNamespaceResolver()), reqType, this.session.getNamespaceResolver()) : InternalValue.create(name);
        this.internalSetValue(new InternalValue[]{internalValue}, reqType);
    }

    public void setValue(QName[] names) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(true);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 7;
        }
        InternalValue[] internalValues = null;
        if (names != null) {
            internalValues = new InternalValue[names.length];
            for (int i = 0; i < names.length; ++i) {
                QName name = names[i];
                InternalValue internalValue = null;
                if (name != null) {
                    internalValue = reqType != 7 ? InternalValue.create(InternalValue.create(name).toJCRValue(this.session.getNamespaceResolver()), reqType, this.session.getNamespaceResolver()) : InternalValue.create(name);
                }
                internalValues[i] = internalValue;
            }
        }
        this.internalSetValue(internalValues, reqType);
    }

    public QName getQName() {
        return ((PropertyId)this.id).getName();
    }

    public InternalValue[] internalGetValues() throws RepositoryException {
        this.sanityCheck();
        if (!this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is not multi-valued");
        }
        PropertyState state = (PropertyState)this.getItemState();
        return state.getValues();
    }

    public InternalValue internalGetValue() throws RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        PropertyState state = (PropertyState)this.getItemState();
        return state.getValues()[0];
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (!this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is not multi-valued");
        }
        PropertyState state = (PropertyState)this.getItemState();
        InternalValue[] internalValues = state.getValues();
        Value[] values = new Value[internalValues.length];
        for (int i = 0; i < internalValues.length; ++i) {
            values[i] = internalValues[i].toJCRValue(this.session.getNamespaceResolver());
        }
        return values;
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        PropertyState state = (PropertyState)this.getItemState();
        try {
            InternalValue val = state.getValues()[0];
            return val.toJCRValue(this.session.getNamespaceResolver());
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Internal error while retrieving value of " + this.safeGetJCRPath();
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public String getString() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        return this.getValue().getString();
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        return this.getValue().getStream();
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        PropertyState state = (PropertyState)this.getItemState();
        InternalValue val = state.getValues()[0];
        int type = val.getType();
        if (type == 3) {
            return (Long)val.internalValue();
        }
        return val.toJCRValue(this.session.getNamespaceResolver()).getLong();
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        PropertyState state = (PropertyState)this.getItemState();
        InternalValue val = state.getValues()[0];
        int type = val.getType();
        if (type == 4) {
            return (Double)val.internalValue();
        }
        return val.toJCRValue(this.session.getNamespaceResolver()).getDouble();
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        PropertyState state = (PropertyState)this.getItemState();
        InternalValue val = state.getValues()[0];
        int type = val.getType();
        if (type == 5) {
            return (Calendar)val.internalValue();
        }
        return val.toJCRValue(this.session.getNamespaceResolver()).getDate();
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        PropertyState state = (PropertyState)this.getItemState();
        InternalValue val = state.getValues()[0];
        int type = val.getType();
        if (type == 6) {
            return (Boolean)val.internalValue();
        }
        return val.toJCRValue(this.session.getNamespaceResolver()).getBoolean();
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        PropertyState state = (PropertyState)this.getItemState();
        InternalValue val = state.getValues()[0];
        if (val.getType() == 9) {
            UUID targetUUID = (UUID)val.internalValue();
            return (Node)this.itemMgr.getItem(new NodeId(targetUUID));
        }
        throw new ValueFormatException("property must be of type REFERENCE");
    }

    public void setValue(Calendar date) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 5;
        }
        if (date == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        InternalValue value = reqType != 5 ? InternalValue.create(new DateValue(date), reqType, this.session.getNamespaceResolver()) : InternalValue.create(date);
        this.internalSetValue(new InternalValue[]{value}, reqType);
    }

    public void setValue(double number) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 4;
        }
        InternalValue value = reqType != 4 ? InternalValue.create(new DoubleValue(number), reqType, this.session.getNamespaceResolver()) : InternalValue.create(number);
        this.internalSetValue(new InternalValue[]{value}, reqType);
    }

    public void setValue(InputStream stream) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        InternalValue value;
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 2;
        }
        if (stream == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        try {
            value = reqType != 2 ? InternalValue.create(new BLOBFileValue(stream), reqType, this.session.getNamespaceResolver()) : InternalValue.create(stream);
        }
        catch (IOException ioe) {
            String msg = "failed to spool stream to internal storage";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ioe);
        }
        this.internalSetValue(new InternalValue[]{value}, reqType);
    }

    public void setValue(String string) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 1;
        }
        if (string == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        InternalValue internalValue = reqType != 1 ? InternalValue.create(string, reqType, this.session.getNamespaceResolver()) : InternalValue.create(string);
        this.internalSetValue(new InternalValue[]{internalValue}, reqType);
    }

    public void setValue(String[] strings) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(true);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 1;
        }
        InternalValue[] internalValues = null;
        if (strings != null) {
            internalValues = new InternalValue[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                InternalValue internalValue = null;
                if (string != null) {
                    internalValue = reqType != 1 ? InternalValue.create(string, reqType, this.session.getNamespaceResolver()) : InternalValue.create(string);
                }
                internalValues[i] = internalValue;
            }
        }
        this.internalSetValue(internalValues, reqType);
    }

    public void setValue(boolean b) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 6;
        }
        InternalValue value = reqType != 6 ? InternalValue.create(new BooleanValue(b), reqType, this.session.getNamespaceResolver()) : InternalValue.create(b);
        this.internalSetValue(new InternalValue[]{value}, reqType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Node target) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        NodeImpl targetNode;
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 9;
        }
        if (target == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        if (reqType != 9) throw new ValueFormatException("property must be of type REFERENCE");
        if (target instanceof NodeImpl) {
            targetNode = (NodeImpl)target;
            if (!targetNode.isNodeType(QName.MIX_REFERENCEABLE)) {
                throw new ValueFormatException("target node must be of node type mix:referenceable");
            }
        } else {
            String msg = "incompatible Node object: " + target;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        InternalValue value = InternalValue.create(new UUID(targetNode.getUUID()));
        this.internalSetValue(new InternalValue[]{value}, reqType);
    }

    public void setValue(long number) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = 3;
        }
        InternalValue value = reqType != 3 ? InternalValue.create(new LongValue(number), reqType, this.session.getNamespaceResolver()) : InternalValue.create(number);
        this.internalSetValue(new InternalValue[]{value}, reqType);
    }

    public synchronized void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(false);
        int reqType = this.definition.getRequiredType();
        if (reqType == 0) {
            reqType = value != null ? value.getType() : 1;
        }
        if (value == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        InternalValue internalValue = reqType != value.getType() ? InternalValue.create(value, reqType, this.session.getNamespaceResolver()) : InternalValue.create(value, this.session.getNamespaceResolver());
        this.internalSetValue(new InternalValue[]{internalValue}, reqType);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(true);
        if (values != null) {
            int valueType = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (valueType == 0) {
                    valueType = values[i].getType();
                    continue;
                }
                if (valueType == values[i].getType()) continue;
                String msg = "inhomogeneous type of values";
                log.debug(msg);
                throw new ValueFormatException(msg);
            }
        }
        int reqType = this.definition.getRequiredType();
        InternalValue[] internalValues = null;
        if (values != null) {
            internalValues = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                InternalValue internalValue = null;
                if (value != null) {
                    if (reqType == 0) {
                        reqType = value.getType();
                    }
                    internalValue = reqType != 0 && reqType != value.getType() ? InternalValue.create(value, reqType, this.session.getNamespaceResolver()) : InternalValue.create(value, this.session.getNamespaceResolver());
                }
                internalValues[i] = internalValue;
            }
        }
        this.internalSetValue(internalValues, reqType);
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued");
        }
        InternalValue[] values = ((PropertyState)this.state).getValues();
        if (values.length == 0) {
            log.warn(this.safeGetJCRPath() + ": single-valued property with no value");
            return -1L;
        }
        return this.getLength(values[0]);
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        this.sanityCheck();
        if (!this.definition.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is not multi-valued");
        }
        InternalValue[] values = ((PropertyState)this.state).getValues();
        long[] lengths = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            lengths[i] = this.getLength(values[i]);
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        this.sanityCheck();
        return this.definition;
    }

    public int getType() throws RepositoryException {
        this.sanityCheck();
        return ((PropertyState)this.state).getType();
    }

    public boolean isNode() {
        return false;
    }

    public String getName() throws RepositoryException {
        this.sanityCheck();
        QName name = ((PropertyId)this.id).getName();
        try {
            return this.session.getNamespaceResolver().getJCRName(name);
        }
        catch (NoPrefixDeclaredException npde) {
            String msg = "internal error: encountered unregistered namespace " + name.getNamespaceURI();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)npde);
        }
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.sanityCheck();
        visitor.visit((Property)this);
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        return (Node)this.itemMgr.getItem(this.state.getParentId());
    }
}

