/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.name.AbstractNamespaceResolver;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NamespaceListener;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;

class CachingNamespaceResolver
implements NamespaceResolver,
NamespaceListener {
    private final AbstractNamespaceResolver base;
    private final Map qnameToJCRName;
    private final Map jcrNameToQName;

    public CachingNamespaceResolver(AbstractNamespaceResolver base, int cacheSize) {
        this.base = base;
        this.qnameToJCRName = new LRUMap(cacheSize);
        this.jcrNameToQName = new LRUMap(cacheSize);
        this.base.addListener(this);
    }

    public String getURI(String prefix) throws NamespaceException {
        return this.base.getURI(prefix);
    }

    public String getPrefix(String uri) throws NamespaceException {
        return this.base.getPrefix(uri);
    }

    public synchronized QName getQName(String name) throws IllegalNameException, UnknownPrefixException {
        QName qName = (QName)this.jcrNameToQName.get(name);
        if (qName == null) {
            qName = QName.fromJCRName(name, this);
            this.jcrNameToQName.put(name, qName);
        }
        return qName;
    }

    public synchronized String getJCRName(QName name) throws NoPrefixDeclaredException {
        String jcrName = (String)this.qnameToJCRName.get(name);
        if (jcrName == null) {
            jcrName = name.toJCRName(this);
            this.qnameToJCRName.put(name, jcrName);
        }
        return jcrName;
    }

    public void dispose() {
        this.base.removeListener(this);
    }

    public void namespaceAdded(String prefix, String uri) {
    }

    public void namespaceRemapped(String oldPrefix, String newPrefix, String uri) {
        this.qnameToJCRName.clear();
        this.jcrNameToQName.clear();
    }
}

