/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedItemOperations
extends ItemValidator {
    private static Logger log = LoggerFactory.getLogger((Class)BatchedItemOperations.class);
    protected static final int COPY = 0;
    protected static final int CLONE = 1;
    protected static final int CLONE_REMOVE_EXISTING = 2;
    public static final int CHECK_ACCESS = 1;
    public static final int CHECK_LOCK = 2;
    public static final int CHECK_VERSIONING = 4;
    public static final int CHECK_CONSTRAINTS = 16;
    public static final int CHECK_REFERENCES = 8;
    protected final UpdatableItemStateManager stateMgr;
    protected final LockManager lockMgr;
    protected final SessionImpl session;

    public BatchedItemOperations(UpdatableItemStateManager stateMgr, NodeTypeRegistry ntReg, LockManager lockMgr, SessionImpl session, HierarchyManager hierMgr, NamespaceResolver nsResolver) {
        super(ntReg, hierMgr, nsResolver);
        this.stateMgr = stateMgr;
        this.lockMgr = lockMgr;
        this.session = session;
    }

    public void edit() throws IllegalStateException {
        this.stateMgr.edit();
    }

    public void store(ItemState state) throws IllegalStateException {
        this.stateMgr.store(state);
    }

    public void destroy(ItemState state) throws IllegalStateException {
        this.stateMgr.destroy(state);
    }

    public void update() throws RepositoryException, IllegalStateException {
        try {
            this.stateMgr.update();
        }
        catch (ItemStateException ise) {
            String msg = "update operation failed";
            log.debug(msg, (Throwable)ise);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    public void cancel() throws IllegalStateException {
        this.stateMgr.cancel();
    }

    public void copy(Path srcPath, Path destPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.copy(srcPath, this.stateMgr, this.hierMgr, this.session.getAccessManager(), destPath, flag);
    }

    public void copy(Path srcPath, ItemStateManager srcStateMgr, HierarchyManager srcHierMgr, AccessManager srcAccessMgr, Path destPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("not in edit mode");
        }
        NodeState srcState = this.getNodeState(srcStateMgr, srcHierMgr, srcPath);
        Path.PathElement destName = destPath.getNameElement();
        Path destParentPath = destPath.getAncestor(1);
        NodeState destParentState = this.getNodeState(destParentPath);
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = "invalid destination path (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.checkAddNode(destParentState, destName.getName(), srcState.getNodeTypeName(), 23);
        try {
            if (!srcAccessMgr.isGranted(srcState.getNodeId(), 1)) {
                throw new PathNotFoundException(this.safeGetJCRPath(srcPath));
            }
        }
        catch (ItemNotFoundException infe) {
            String msg = "internal error: failed to check access rights for " + this.safeGetJCRPath(srcPath);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        ReferenceChangeTracker refTracker = new ReferenceChangeTracker();
        NodeState newState = this.copyNodeState(srcState, srcStateMgr, srcAccessMgr, destParentState.getNodeId(), flag, refTracker);
        destParentState.addChildNodeEntry(destName.getName(), newState.getNodeId());
        NodeDef newNodeDef = this.findApplicableNodeDefinition(destName.getName(), srcState.getNodeTypeName(), destParentState);
        newState.setDefinitionId(newNodeDef.getId());
        Iterator iter = refTracker.getProcessedReferences();
        while (iter.hasNext()) {
            PropertyState prop = (PropertyState)iter.next();
            if (prop.getType() != 9) continue;
            boolean modified = false;
            InternalValue[] values = prop.getValues();
            InternalValue[] newVals = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                UUID original = (UUID)val.internalValue();
                UUID adjusted = refTracker.getMappedUUID(original);
                if (adjusted != null) {
                    newVals[i] = InternalValue.create(adjusted);
                    modified = true;
                    continue;
                }
                newVals[i] = val;
            }
            if (!modified) continue;
            prop.setValues(newVals);
            this.stateMgr.store(prop);
        }
        refTracker.clear();
        this.stateMgr.store(newState);
        this.stateMgr.store(destParentState);
    }

    public void move(Path srcPath, Path destPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("not in edit mode");
        }
        try {
            if (srcPath.isAncestorOf(destPath)) {
                String msg = this.safeGetJCRPath(destPath) + ": invalid destination path (cannot be descendant of source path)";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path: " + this.safeGetJCRPath(destPath);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        Path.PathElement srcName = srcPath.getNameElement();
        Path srcParentPath = srcPath.getAncestor(1);
        NodeState target = this.getNodeState(srcPath);
        NodeState srcParent = this.getNodeState(srcParentPath);
        Path.PathElement destName = destPath.getNameElement();
        Path destParentPath = destPath.getAncestor(1);
        NodeState destParent = this.getNodeState(destParentPath);
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = this.safeGetJCRPath(destPath) + ": invalid destination path (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.checkRemoveNode(target, srcParent.getNodeId(), 23);
        this.checkAddNode(destParent, destName.getName(), target.getNodeTypeName(), 23);
        boolean renameOnly = srcParent.getNodeId().equals(destParent.getNodeId());
        int srcNameIndex = srcName.getIndex();
        if (srcNameIndex == 0) {
            srcNameIndex = 1;
        }
        if (renameOnly) {
            destParent.renameChildNodeEntry(srcName.getName(), srcNameIndex, destName.getName());
        } else {
            srcParent.removeChildNodeEntry(srcName.getName(), srcNameIndex);
            target.setParentId(destParent.getNodeId());
            destParent.addChildNodeEntry(destName.getName(), target.getNodeId());
        }
        NodeDef newTargetDef = this.findApplicableNodeDefinition(destName.getName(), target.getNodeTypeName(), destParent);
        target.setDefinitionId(newTargetDef.getId());
        this.stateMgr.store(target);
        if (renameOnly) {
            this.stateMgr.store(srcParent);
        } else {
            this.stateMgr.store(destParent);
            this.stateMgr.store(srcParent);
        }
    }

    public void removeNode(Path nodePath) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ReferentialIntegrityException, RepositoryException, IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("not in edit mode");
        }
        NodeState target = this.getNodeState(nodePath);
        NodeId parentId = target.getParentId();
        this.checkRemoveNode(target, parentId, 31);
        this.removeNodeState(target);
    }

    public void checkAddNode(NodeState parentState, QName nodeName, QName nodeTypeName, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ItemExistsException, RepositoryException {
        Path parentPath = this.hierMgr.getPath(parentState.getNodeId());
        if ((options & 2) == 2) {
            this.verifyUnlocked(parentPath);
        }
        if ((options & 4) == 4) {
            this.verifyCheckedOut(parentPath);
        }
        if ((options & 1) == 1) {
            AccessManager accessMgr = this.session.getAccessManager();
            if (!accessMgr.isGranted(parentState.getNodeId(), 1)) {
                throw new ItemNotFoundException(this.safeGetJCRPath(parentState.getNodeId()));
            }
            if (!accessMgr.isGranted(parentState.getNodeId(), 2)) {
                throw new AccessDeniedException(this.safeGetJCRPath(parentState.getNodeId()) + ": not allowed to add child node");
            }
        }
        if ((options & 0x10) == 16) {
            NodeDef parentDef = this.ntReg.getNodeDef(parentState.getDefinitionId());
            if (parentDef.isProtected()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(parentState.getNodeId()) + ": cannot add child node to protected parent node");
            }
            EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
            entParent.checkAddNodeConstraints(nodeName, nodeTypeName);
            NodeDef newNodeDef = this.findApplicableNodeDefinition(nodeName, nodeTypeName, parentState);
            if (parentState.hasPropertyName(nodeName)) {
                throw new ItemExistsException("cannot add child node '" + nodeName.getLocalName() + "' to " + this.safeGetJCRPath(parentState.getNodeId()) + ": colliding with same-named existing property");
            }
            if (parentState.hasChildNodeEntry(nodeName)) {
                NodeState conflictingState;
                NodeState.ChildNodeEntry entry = parentState.getChildNodeEntry(nodeName, 1);
                NodeId conflictingId = entry.getId();
                try {
                    conflictingState = (NodeState)this.stateMgr.getItemState(conflictingId);
                }
                catch (ItemStateException ise) {
                    String msg = "internal error: failed to retrieve state of " + this.safeGetJCRPath(conflictingId);
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)ise);
                }
                NodeDef conflictingTargetDef = this.ntReg.getNodeDef(conflictingState.getDefinitionId());
                if (!conflictingTargetDef.allowsSameNameSiblings() || !newNodeDef.allowsSameNameSiblings()) {
                    throw new ItemExistsException("cannot add child node '" + nodeName.getLocalName() + "' to " + this.safeGetJCRPath(parentState.getNodeId()) + ": colliding with same-named existing node");
                }
            }
        }
    }

    public void checkRemoveNode(NodeState targetState, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ReferentialIntegrityException, RepositoryException {
        this.checkRemoveNode(targetState, targetState.getParentId(), options);
    }

    public void checkRemoveNode(NodeState targetState, NodeId parentId, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ReferentialIntegrityException, RepositoryException {
        NodeReferencesId refsId;
        EffectiveNodeType ent;
        if (targetState.getParentId() == null) {
            throw new ConstraintViolationException("cannot remove root node");
        }
        NodeId targetId = targetState.getNodeId();
        NodeState parentState = this.getNodeState(parentId);
        Path parentPath = this.hierMgr.getPath(parentId);
        if ((options & 2) == 2) {
            this.verifyUnlocked(parentPath);
        }
        if ((options & 4) == 4) {
            this.verifyCheckedOut(parentPath);
        }
        if ((options & 1) == 1) {
            AccessManager accessMgr = this.session.getAccessManager();
            try {
                if (!accessMgr.isGranted(targetId, 1)) {
                    throw new PathNotFoundException(this.safeGetJCRPath(targetId));
                }
                if (!accessMgr.isGranted(targetId, 4)) {
                    throw new AccessDeniedException(this.safeGetJCRPath(targetId) + ": not allowed to remove node");
                }
            }
            catch (ItemNotFoundException infe) {
                String msg = "internal error: failed to check access rights for " + this.safeGetJCRPath(targetId);
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)infe);
            }
        }
        if ((options & 0x10) == 16) {
            NodeDef parentDef = this.ntReg.getNodeDef(parentState.getDefinitionId());
            if (parentDef.isProtected()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(parentId) + ": cannot remove child node of protected parent node");
            }
            NodeDef targetDef = this.ntReg.getNodeDef(targetState.getDefinitionId());
            if (targetDef.isMandatory()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(targetId) + ": cannot remove mandatory node");
            }
            if (targetDef.isProtected()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(targetId) + ": cannot remove protected node");
            }
        }
        if ((options & 8) == 8 && (ent = this.getEffectiveNodeType(targetState)).includesNodeType(QName.MIX_REFERENCEABLE) && this.stateMgr.hasNodeReferences(refsId = new NodeReferencesId(targetState.getNodeId()))) {
            try {
                NodeReferences refs = this.stateMgr.getNodeReferences(refsId);
                if (refs.hasReferences()) {
                    throw new ReferentialIntegrityException(this.safeGetJCRPath(targetId) + ": cannot remove node with references");
                }
            }
            catch (ItemStateException ise) {
                String msg = "internal error: failed to check references on " + this.safeGetJCRPath(targetId);
                log.error(msg, (Throwable)ise);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
    }

    public void verifyCanWrite(Path nodePath) throws PathNotFoundException, AccessDeniedException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        NodeState node = this.getNodeState(nodePath);
        AccessManager accessMgr = this.session.getAccessManager();
        if (!accessMgr.isGranted(node.getNodeId(), 1)) {
            throw new PathNotFoundException(this.safeGetJCRPath(node.getNodeId()));
        }
        if (!accessMgr.isGranted(node.getNodeId(), 2)) {
            throw new AccessDeniedException(this.safeGetJCRPath(node.getNodeId()) + ": not allowed to modify node");
        }
        this.verifyUnlocked(nodePath);
        this.verifyNotProtected(nodePath);
        this.verifyCheckedOut(nodePath);
    }

    public void verifyCanRead(Path nodePath) throws PathNotFoundException, RepositoryException {
        NodeState node = this.getNodeState(nodePath);
        AccessManager accessMgr = this.session.getAccessManager();
        if (!accessMgr.isGranted(node.getNodeId(), 1)) {
            throw new PathNotFoundException(this.safeGetJCRPath(node.getNodeId()));
        }
    }

    public NodeDef findApplicableNodeDefinition(QName name, QName nodeTypeName, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicableChildNodeDef(name, nodeTypeName);
    }

    public PropDef findApplicablePropertyDefinition(QName name, int type, boolean multiValued, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type, multiValued);
    }

    public PropDef findApplicablePropertyDefinition(QName name, int type, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type);
    }

    public NodeState createNodeState(NodeState parent, QName nodeName, QName nodeTypeName, QName[] mixinNames, NodeId id) throws ItemExistsException, ConstraintViolationException, RepositoryException, IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("not in edit mode");
        }
        NodeDef def = this.findApplicableNodeDefinition(nodeName, nodeTypeName, parent);
        return this.createNodeState(parent, nodeName, nodeTypeName, mixinNames, id, def);
    }

    public NodeState createNodeState(NodeState parent, QName nodeName, QName nodeTypeName, QName[] mixinNames, NodeId id, NodeDef def) throws ItemExistsException, ConstraintViolationException, RepositoryException, IllegalStateException {
        if (parent.hasPropertyName(nodeName)) {
            String msg = "there's already a property with name " + nodeName;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!def.allowsSameNameSiblings() && parent.hasChildNodeEntry(nodeName)) {
            NodeId errorId = parent.getChildNodeEntry(nodeName, 1).getId();
            throw new ItemExistsException(this.safeGetJCRPath(errorId));
        }
        if (id == null) {
            id = new NodeId(UUID.randomUUID());
        }
        if (nodeTypeName == null && (nodeTypeName = def.getDefaultPrimaryType()) == null) {
            String msg = "an applicable node type could not be determined for " + nodeName;
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        NodeState node = this.stateMgr.createNew(id, nodeTypeName, parent.getNodeId());
        if (mixinNames != null && mixinNames.length > 0) {
            node.setMixinTypeNames(new HashSet<QName>(Arrays.asList(mixinNames)));
        }
        node.setDefinitionId(def.getId());
        parent.addChildNodeEntry(nodeName, id);
        EffectiveNodeType ent = this.getEffectiveNodeType(node);
        if (!node.getMixinTypeNames().isEmpty()) {
            PropDef pd = ent.getApplicablePropertyDef(QName.JCR_MIXINTYPES, 7, true);
            this.createPropertyState(node, pd.getName(), pd.getRequiredType(), pd);
        }
        PropDef[] pda = ent.getAutoCreatePropDefs();
        for (int i = 0; i < pda.length; ++i) {
            PropDef pd = pda[i];
            this.createPropertyState(node, pd.getName(), pd.getRequiredType(), pd);
        }
        NodeDef[] nda = ent.getAutoCreateNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            NodeDef nd = nda[i];
            this.createNodeState(node, nd.getName(), nd.getDefaultPrimaryType(), null, null, nd);
        }
        this.stateMgr.store(node);
        this.stateMgr.store(parent);
        return node;
    }

    public PropertyState createPropertyState(NodeState parent, QName propName, int type, int numValues) throws ItemExistsException, ConstraintViolationException, RepositoryException, IllegalStateException {
        PropDef def;
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("not in edit mode");
        }
        if (numValues == 1) {
            try {
                def = this.findApplicablePropertyDefinition(propName, type, false, parent);
            }
            catch (ConstraintViolationException cve) {
                def = this.findApplicablePropertyDefinition(propName, type, true, parent);
            }
        } else {
            def = this.findApplicablePropertyDefinition(propName, type, true, parent);
        }
        return this.createPropertyState(parent, propName, type, def);
    }

    public PropertyState createPropertyState(NodeState parent, QName propName, int type, PropDef def) throws ItemExistsException, RepositoryException {
        if (parent.hasChildNodeEntry(propName)) {
            String msg = "there's already a child node with name " + propName;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (parent.hasPropertyName(propName)) {
            PropertyId errorId = new PropertyId(parent.getNodeId(), propName);
            throw new ItemExistsException(this.safeGetJCRPath(errorId));
        }
        PropertyState prop = this.stateMgr.createNew(propName, parent.getNodeId());
        prop.setDefinitionId(def.getId());
        if (def.getRequiredType() != 0) {
            prop.setType(def.getRequiredType());
        } else if (type != 0) {
            prop.setType(type);
        } else {
            prop.setType(1);
        }
        prop.setMultiValued(def.isMultiple());
        InternalValue[] genValues = this.computeSystemGeneratedPropertyValues(parent, def);
        if (genValues != null) {
            prop.setValues(genValues);
        } else if (def.getDefaultValues() != null) {
            prop.setValues(def.getDefaultValues());
        }
        parent.addPropertyName(propName);
        this.stateMgr.store(parent);
        return prop;
    }

    public void removeNodeState(NodeState target) throws RepositoryException {
        NodeId parentId = target.getParentId();
        if (parentId == null) {
            String msg = "root node cannot be removed";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState parent = this.getNodeState(parentId);
        parent.removeChildNodeEntry(target.getNodeId());
        this.stateMgr.store(parent);
        this.recursiveRemoveNodeState(target);
    }

    public NodeState getNodeState(Path nodePath) throws PathNotFoundException, RepositoryException {
        return this.getNodeState(this.stateMgr, this.hierMgr, nodePath);
    }

    public NodeState getNodeState(NodeId id) throws ItemNotFoundException, RepositoryException {
        return (NodeState)this.getItemState(this.stateMgr, id);
    }

    public PropertyState getPropertyState(PropertyId id) throws ItemNotFoundException, RepositoryException {
        return (PropertyState)this.getItemState(this.stateMgr, id);
    }

    public ItemState getItemState(ItemId id) throws ItemNotFoundException, RepositoryException {
        return this.getItemState(this.stateMgr, id);
    }

    protected void verifyCheckedOut(Path nodePath) throws PathNotFoundException, VersionException, RepositoryException {
        PropertyState propState;
        NodeState nodeState = this.getNodeState(nodePath);
        while (!nodeState.hasPropertyName(QName.JCR_ISCHECKEDOUT)) {
            if (nodePath.denotesRoot()) {
                return;
            }
            nodePath = nodePath.getAncestor(1);
            nodeState = this.getNodeState(nodePath);
        }
        PropertyId propId = new PropertyId(nodeState.getNodeId(), QName.JCR_ISCHECKEDOUT);
        try {
            propState = (PropertyState)this.stateMgr.getItemState(propId);
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to retrieve state of " + this.safeGetJCRPath(propId);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        boolean checkedOut = (Boolean)propState.getValues()[0].internalValue();
        if (!checkedOut) {
            throw new VersionException(this.safeGetJCRPath(nodePath) + " is checked-in");
        }
    }

    protected void verifyUnlocked(Path nodePath) throws LockException, RepositoryException {
        this.lockMgr.checkLock(nodePath, this.session);
    }

    protected void verifyNotProtected(Path nodePath) throws PathNotFoundException, ConstraintViolationException, RepositoryException {
        NodeState node = this.getNodeState(nodePath);
        NodeDef parentDef = this.ntReg.getNodeDef(node.getDefinitionId());
        if (parentDef.isProtected()) {
            throw new ConstraintViolationException(this.safeGetJCRPath(nodePath) + ": node is protected");
        }
    }

    protected NodeState getNodeState(ItemStateManager srcStateMgr, HierarchyManager srcHierMgr, Path nodePath) throws PathNotFoundException, RepositoryException {
        try {
            ItemId id = srcHierMgr.resolvePath(nodePath);
            if (!id.denotesNode()) {
                throw new PathNotFoundException(this.safeGetJCRPath(nodePath));
            }
            return (NodeState)this.getItemState(srcStateMgr, id);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(nodePath));
        }
    }

    protected ItemState getItemState(ItemStateManager srcStateMgr, ItemId id) throws ItemNotFoundException, RepositoryException {
        try {
            return srcStateMgr.getItemState(id);
        }
        catch (NoSuchItemStateException nsise) {
            throw new ItemNotFoundException(this.safeGetJCRPath(id));
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to retrieve state of " + this.safeGetJCRPath(id);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    private InternalValue[] computeSystemGeneratedPropertyValues(NodeState parent, PropDef def) {
        InternalValue[] genValues = null;
        QName declaringNT = def.getDeclaringNodeType();
        QName name = def.getName();
        if (QName.MIX_REFERENCEABLE.equals(declaringNT)) {
            if (QName.JCR_UUID.equals(name)) {
                genValues = new InternalValue[]{InternalValue.create(parent.getNodeId().getUUID().toString())};
            }
        } else if (QName.NT_BASE.equals(declaringNT)) {
            if (QName.JCR_PRIMARYTYPE.equals(name)) {
                genValues = new InternalValue[]{InternalValue.create(parent.getNodeTypeName())};
            } else if (QName.JCR_MIXINTYPES.equals(name)) {
                Set mixins = parent.getMixinTypeNames();
                ArrayList<InternalValue> values = new ArrayList<InternalValue>(mixins.size());
                Iterator iter = mixins.iterator();
                while (iter.hasNext()) {
                    values.add(InternalValue.create((QName)iter.next()));
                }
                genValues = values.toArray(new InternalValue[values.size()]);
            }
        } else if (QName.NT_HIERARCHYNODE.equals(declaringNT)) {
            if (QName.JCR_CREATED.equals(name)) {
                genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
            }
        } else if (QName.NT_RESOURCE.equals(declaringNT)) {
            if (QName.JCR_LASTMODIFIED.equals(name)) {
                genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
            }
        } else if (QName.NT_VERSION.equals(declaringNT) && QName.JCR_CREATED.equals(name)) {
            genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
        }
        return genValues;
    }

    private void recursiveRemoveNodeState(NodeState targetState) throws RepositoryException {
        AbstractCollection tmp;
        if (targetState.hasChildNodeEntries()) {
            tmp = new ArrayList(targetState.getChildNodeEntries());
            for (int i = ((ArrayList)tmp).size() - 1; i >= 0; --i) {
                NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)((ArrayList)tmp).get(i);
                NodeId nodeId = entry.getId();
                try {
                    NodeState nodeState = (NodeState)this.stateMgr.getItemState(nodeId);
                    this.checkRemoveNode(nodeState, targetState.getNodeId(), 7);
                    this.recursiveRemoveNodeState(nodeState);
                }
                catch (ItemStateException ise) {
                    String msg = "internal error: failed to retrieve state of " + nodeId;
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)ise);
                }
                targetState.removeChildNodeEntry(entry.getName(), entry.getIndex());
            }
        }
        tmp = new HashSet(targetState.getPropertyNames());
        Iterator iter = ((HashSet)tmp).iterator();
        while (iter.hasNext()) {
            QName propName = (QName)iter.next();
            PropertyId propId = new PropertyId(targetState.getNodeId(), propName);
            try {
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(propId);
                targetState.removePropertyName(propId.getName());
                this.stateMgr.destroy(propState);
            }
            catch (ItemStateException ise) {
                String msg = "internal error: failed to retrieve state of " + propId;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        targetState.setParentId(null);
        this.stateMgr.destroy(targetState.getOverlayedState());
    }

    private NodeState copyNodeState(NodeState srcState, ItemStateManager srcStateMgr, AccessManager srcAccessMgr, NodeId destParentId, int flag, ReferenceChangeTracker refTracker) throws RepositoryException {
        try {
            ItemState srcChildState;
            NodeId id;
            EffectiveNodeType ent = this.getEffectiveNodeType(srcState);
            boolean referenceable = ent.includesNodeType(QName.MIX_REFERENCEABLE);
            boolean versionable = ent.includesNodeType(QName.MIX_VERSIONABLE);
            switch (flag) {
                case 0: {
                    id = new NodeId(UUID.randomUUID());
                    if (!referenceable) break;
                    refTracker.mappedUUID(srcState.getNodeId().getUUID(), id.getUUID());
                    break;
                }
                case 1: {
                    if (!referenceable) {
                        id = new NodeId(UUID.randomUUID());
                        break;
                    }
                    id = srcState.getNodeId();
                    if (!this.stateMgr.hasItemState(id)) break;
                    throw new ItemExistsException(this.safeGetJCRPath(id));
                }
                case 2: {
                    if (!referenceable) {
                        id = new NodeId(UUID.randomUUID());
                        break;
                    }
                    id = srcState.getNodeId();
                    if (!this.stateMgr.hasItemState(id)) break;
                    NodeState existingState = (NodeState)this.stateMgr.getItemState(id);
                    Path p0 = this.hierMgr.getPath(destParentId);
                    Path p1 = this.hierMgr.getPath(id);
                    try {
                        if (p1.equals(p0) || p1.isAncestorOf(p0)) {
                            String msg = "cannot remove ancestor node";
                            log.debug(msg);
                            throw new RepositoryException(msg);
                        }
                    }
                    catch (MalformedPathException mpe) {
                        String msg = "internal error: failed to determine degree of relationship";
                        log.error(msg, (Throwable)mpe);
                        throw new RepositoryException(msg, (Throwable)mpe);
                    }
                    this.checkRemoveNode(existingState, 23);
                    this.removeNodeState(existingState);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown flag");
                }
            }
            NodeState newState = this.stateMgr.createNew(id, srcState.getNodeTypeName(), destParentId);
            newState.setMixinTypeNames(srcState.getMixinTypeNames());
            newState.setDefinitionId(srcState.getDefinitionId());
            Iterator iter = srcState.getChildNodeEntries().iterator();
            while (iter.hasNext()) {
                NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)iter.next();
                NodeId nodeId = entry.getId();
                if (!srcAccessMgr.isGranted(nodeId, 1)) continue;
                srcChildState = (NodeState)srcStateMgr.getItemState(nodeId);
                NodeState newChildState = this.copyNodeState((NodeState)srcChildState, srcStateMgr, srcAccessMgr, id, flag, refTracker);
                this.stateMgr.store(newChildState);
                newState.addChildNodeEntry(entry.getName(), newChildState.getNodeId());
            }
            iter = srcState.getPropertyNames().iterator();
            while (iter.hasNext()) {
                PropDefId defId;
                PropDef def;
                QName propName = (QName)iter.next();
                PropertyId propId = new PropertyId(srcState.getNodeId(), propName);
                if (!srcAccessMgr.isGranted(propId, 1) || (def = this.ntReg.getPropDef(defId = ((PropertyState)(srcChildState = (PropertyState)srcStateMgr.getItemState(propId))).getDefinitionId())).getDeclaringNodeType().equals(QName.MIX_LOCKABLE)) continue;
                PropertyState newChildState = this.copyPropertyState((PropertyState)srcChildState, id, propName);
                if (versionable && flag == 0) {
                    VersionHistory vh;
                    if (propName.equals(QName.JCR_VERSIONHISTORY)) {
                        vh = this.getOrCreateVersionHistory(newState);
                        newChildState.setValues(new InternalValue[]{InternalValue.create(new UUID(vh.getUUID()))});
                    }
                    if (propName.equals(QName.JCR_BASEVERSION)) {
                        vh = this.getOrCreateVersionHistory(newState);
                        newChildState.setValues(new InternalValue[]{InternalValue.create(new UUID(vh.getRootVersion().getUUID()))});
                    }
                    if (propName.equals(QName.JCR_PREDECESSORS)) {
                        vh = this.getOrCreateVersionHistory(newState);
                        newChildState.setValues(new InternalValue[]{InternalValue.create(new UUID(vh.getRootVersion().getUUID()))});
                    }
                    if (propName.equals(QName.JCR_ISCHECKEDOUT)) {
                        newChildState.setValues(new InternalValue[]{InternalValue.create(true)});
                    }
                }
                if (newChildState.getType() == 9) {
                    refTracker.processedReference(newChildState);
                }
                this.stateMgr.store(newChildState);
                newState.addPropertyName(propName);
            }
            return newState;
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to copy state of " + srcState.getNodeId();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    private PropertyState copyPropertyState(PropertyState srcState, NodeId parentId, QName propName) throws RepositoryException {
        PropDefId defId = srcState.getDefinitionId();
        PropDef def = this.ntReg.getPropDef(defId);
        PropertyState newState = this.stateMgr.createNew(propName, parentId);
        newState.setDefinitionId(defId);
        newState.setType(srcState.getType());
        newState.setMultiValued(srcState.isMultiValued());
        InternalValue[] values = srcState.getValues();
        if (values != null) {
            if (def.getDeclaringNodeType().equals(QName.MIX_REFERENCEABLE) && propName.equals(QName.JCR_UUID)) {
                newState.setValues(new InternalValue[]{InternalValue.create(parentId.getUUID().toString())});
            } else {
                InternalValue[] newValues = new InternalValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    newValues[i] = values[i].createCopy();
                }
                newState.setValues(newValues);
            }
        }
        return newState;
    }

    private VersionHistory getOrCreateVersionHistory(NodeState node) throws RepositoryException {
        VersionManager vMgr = this.session.getVersionManager();
        VersionHistory vh = vMgr.getVersionHistory(this.session, node);
        if (vh == null) {
            vh = vMgr.createVersionHistory(this.session, node);
        }
        return vh;
    }
}

