/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheManager;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCache
extends TestCase {
    public TestCache(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("Cache");
        testSuite.addTest((Test)new CacheTestCase("RAND"));
        return testSuite;
    }

    static class CacheTestCase
    extends TestCase {
        String cacheType;

        CacheTestCase(String string) {
            super(string);
            this.cacheType = string;
        }

        protected void runTest() {
            this.testCache();
        }

        public void testCache() {
            this.testCacheCreation(this.cacheType);
            this.testCacheSimpleReturn(this.cacheType);
            this.testFillTheCache(this.cacheType);
        }

        public void testCacheCreation(String string) {
            Cache cache = CacheManager.createCache(string, "c1", 100);
            try {
                Cache cache2 = CacheManager.createCache(string, "c2", 1);
                CacheTestCase.assertTrue((String)("Missing error on bad cache size: " + string), (boolean)false);
            }
            catch (Error error) {
                // empty catch block
            }
        }

        public void testCacheSimpleReturn(String string) {
            Integer n;
            Integer n2;
            String string2;
            String string3;
            int n4 = 100;
            Cache cache = CacheManager.createCache(string, "c1", n4);
            String string4 = string3 = (string2 = "one");
            Integer n5 = n2 = (n = new Integer(-1));
            cache.put(string2, n);
            for (int i = 0; i < n4; ++i) {
                string2 = string3;
                n = n2;
                Object object = cache.get(string2);
                CacheTestCase.assertTrue((String)"expected a hit", (object != null ? (byte)1 : 0) != 0);
                CacheTestCase.assertEquals((String)"should be the expected object", (Object)object, (Object)n);
                string3 = string4;
                n2 = n5;
                object = cache.get(string3);
                CacheTestCase.assertTrue((String)"expected a hit", (object != null ? (byte)1 : 0) != 0);
                CacheTestCase.assertEquals((String)"should be the expected object", (Object)object, (Object)n2);
                string4 = "T" + i;
                n5 = new Integer(i);
                cache.put(string4, n5);
            }
        }

        public void testFillTheCache(String string) {
            int n;
            Cache cache = CacheManager.createCache(string, "c1", 100);
            String[] stringArray = new String[100];
            String[] stringArray2 = new String[100];
            for (n = 0; n < 100; ++n) {
                stringArray[n] = "K" + n;
                stringArray2[n] = "V" + n;
                cache.put(stringArray[n], stringArray2[n]);
            }
            n = 0;
            for (int i = 0; i < 100; ++i) {
                if (cache.get(stringArray[i]) == null) continue;
                ++n;
            }
            CacheTestCase.assertTrue((String)("too low a hit rate: " + string + " = " + n), (n > 50 ? (byte)1 : 0) != 0);
            CacheTestCase.assertEquals((String)"count puts", (long)100L, (long)cache.getPuts());
            CacheTestCase.assertEquals((String)"count gets", (long)100L, (long)cache.getGets());
            CacheTestCase.assertEquals((String)"count hits", (long)n, (long)cache.getHits());
        }
    }
}

