/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PrintUtil {
    protected static Map prefixToNS = new HashMap();
    protected static Map nsToPrefix = new HashMap();
    public static final String egNS = "urn:x-hp:eg/";

    public static void init() {
        PrintUtil.registerPrefix("rdf", RDF.getURI());
        PrintUtil.registerPrefix("rdfs", RDFS.getURI());
        PrintUtil.registerPrefix("drdfs", "urn:x-hp-direct-predicate:http_//www.w3.org/2000/01/rdf-schema#");
        PrintUtil.registerPrefix("owl", OWL.getURI());
        PrintUtil.registerPrefix("daml", DAML_OIL.NAMESPACE_DAML.getURI());
        PrintUtil.registerPrefix("jr", ReasonerVocabulary.getJenaReasonerNS());
        PrintUtil.registerPrefix("rb", ReasonerVocabulary.getRBNamespace());
        PrintUtil.registerPrefix("eg", egNS);
        PrintUtil.registerPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    }

    public static void registerPrefix(String string, String string2) {
        prefixToNS.put(string, string2);
        nsToPrefix.put(string2, string);
    }

    public static String print(Node node) {
        if (node instanceof Node_URI) {
            String string;
            String string2;
            String string3 = node.getURI();
            int n = string3.lastIndexOf(35);
            if (n == -1 && (n = string3.lastIndexOf(47)) == -1) {
                n = -1;
            }
            if ((string2 = (String)nsToPrefix.get(string = string3.substring(0, n + 1))) == null) {
                return node.toString();
            }
            return string2 + ":" + string3.substring(n + 1);
        }
        if (node instanceof Node_Literal) {
            LiteralLabel literalLabel = node.getLiteral();
            String string = literalLabel.getLexicalForm();
            return literalLabel.getDatatype() == null ? "'" + string + "'" : string + "^^" + literalLabel.getDatatypeURI();
        }
        if (node instanceof Node_ANY) {
            return "*";
        }
        if (node == null) {
            return "null";
        }
        return node.toString();
    }

    public static String print(RDFNode rDFNode) {
        if (rDFNode == null) {
            return "null";
        }
        return PrintUtil.print(rDFNode.asNode());
    }

    public static String print(Triple triple) {
        if (triple == null) {
            return "(null)";
        }
        return "(" + PrintUtil.print(triple.getSubject()) + " " + PrintUtil.print(triple.getPredicate()) + " " + PrintUtil.print(triple.getObject()) + ")";
    }

    public static String print(TriplePattern triplePattern) {
        if (triplePattern == null) {
            return "(null)";
        }
        return "(" + PrintUtil.print(triplePattern.getSubject()) + " " + PrintUtil.print(triplePattern.getPredicate()) + " " + PrintUtil.print(triplePattern.getObject()) + ")";
    }

    public static String print(Statement statement) {
        if (statement == null) {
            return "(null)";
        }
        return PrintUtil.print(statement.asTriple());
    }

    public static String print(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Triple) {
            return PrintUtil.print((Triple)object);
        }
        if (object instanceof TriplePattern) {
            return PrintUtil.print((TriplePattern)object);
        }
        if (object instanceof Node) {
            return PrintUtil.print((Node)object);
        }
        if (object instanceof RDFNode) {
            return PrintUtil.print((RDFNode)object);
        }
        if (object instanceof Statement) {
            return PrintUtil.print((Statement)object);
        }
        return object.toString();
    }

    public static String expandQname(String string) {
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = (String)prefixToNS.get(string2);
        if (string4 != null) {
            return string4 + string3;
        }
        return string;
    }

    public static void printIndent(PrintWriter printWriter, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        printWriter.print(stringBuffer.toString());
    }

    public static void printOut(Iterator iterator) {
        while (iterator.hasNext()) {
            System.out.println("   " + PrintUtil.print(iterator.next()));
        }
    }

    static {
        PrintUtil.init();
    }
}

