/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTestPrefixMapping
extends GraphTestBase {
    static final String crispURI = "http://crisp.nosuch.net/";
    static final String ropeURI = "scheme:rope/string#";
    static final String butterURI = "ftp://ftp.nowhere.at.all/cream#";
    static final String[] badNames = new String[]{"<hello>", "foo:bar", "with a space", "-argument"};
    static final String[] dontChange = new String[]{"", "http://www.somedomain.something/whatever#", "crispy:cabbage", "cris:isOnInfiniteEarths", "rop:tangled/web", "roped:abseiling"};
    static final String[][] expansions = new String[][]{{"crisp:pathPart", "http://crisp.nosuch.net/pathPart"}, {"rope:partPath", "scheme:rope/string#partPath"}, {"crisp:path:part", "http://crisp.nosuch.net/path:part"}};

    public AbstractTestPrefixMapping(String string) {
        super(string);
    }

    protected abstract PrefixMapping getMapping();

    public void testEmptyPrefix() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("", crispURI);
        AbstractTestPrefixMapping.assertEquals((String)crispURI, (String)prefixMapping.getNsPrefixURI(""));
    }

    public void testCheckNames() {
        PrefixMapping prefixMapping = this.getMapping();
        for (int i = 0; i < badNames.length; ++i) {
            String string = badNames[i];
            try {
                prefixMapping.setNsPrefix(string, crispURI);
                AbstractTestPrefixMapping.fail((String)("'" + string + "' is an illegal prefix and should be trapped"));
                continue;
            }
            catch (PrefixMapping.IllegalPrefixException illegalPrefixException) {
                AbstractTestPrefixMapping.pass();
            }
        }
    }

    public void testPrefixMappingMapping() {
        String string = "ftp://ftp.nowhere.not/";
        AbstractTestPrefixMapping.assertDiffer("crisp and toast must differ", crispURI, string);
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertEquals((String)"crisp should be unset", null, (String)prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals((String)"toast should be unset", null, (String)prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals((String)"butter should be unset", null, (String)prefixMapping.getNsPrefixURI("butter"));
        prefixMapping.setNsPrefix("crisp", crispURI);
        AbstractTestPrefixMapping.assertEquals((String)"crisp should be set", (String)crispURI, (String)prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals((String)"toast should still be unset", null, (String)prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals((String)"butter should still be unset", null, (String)prefixMapping.getNsPrefixURI("butter"));
        prefixMapping.setNsPrefix("toast", string);
        AbstractTestPrefixMapping.assertEquals((String)"crisp should be set", (String)crispURI, (String)prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals((String)"toast should be set", (String)string, (String)prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals((String)"butter should still be unset", null, (String)prefixMapping.getNsPrefixURI("butter"));
    }

    public void testReversePrefixMapping() {
        PrefixMapping prefixMapping = this.getMapping();
        String string = "http://jena.hpl.hp.com/A#";
        String string2 = "http://jena.hpl.hp.com/";
        String string3 = "http://jena.hpl.hp.com/Csharp/";
        String string4 = "aa";
        String string5 = "bb";
        prefixMapping.setNsPrefix(string4, string).setNsPrefix(string5, string2);
        AbstractTestPrefixMapping.assertEquals(null, (String)prefixMapping.getNsURIPrefix(string3));
        AbstractTestPrefixMapping.assertEquals((String)string4, (String)prefixMapping.getNsURIPrefix(string));
        AbstractTestPrefixMapping.assertEquals((String)string5, (String)prefixMapping.getNsURIPrefix(string2));
    }

    public void testPrefixMappingMap() {
        PrefixMapping prefixMapping = this.getCrispyRope();
        Map map = prefixMapping.getNsPrefixMap();
        AbstractTestPrefixMapping.assertEquals((String)"map should have two elements", (int)2, (int)map.size());
        AbstractTestPrefixMapping.assertEquals((Object)crispURI, map.get("crisp"));
        AbstractTestPrefixMapping.assertEquals((Object)ropeURI, map.get("rope"));
    }

    public void testPrefixMappingSecret() {
        PrefixMapping prefixMapping = this.getCrispyRope();
        Map map = prefixMapping.getNsPrefixMap();
        map.put("crisp", "with/onions");
        map.put("sandwich", "with/cheese");
        AbstractTestPrefixMapping.assertEquals((String)crispURI, (String)prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals((String)ropeURI, (String)prefixMapping.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals(null, (String)prefixMapping.getNsPrefixURI("sandwich"));
    }

    private PrefixMapping getCrispyRope() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("rope", ropeURI);
        return prefixMapping;
    }

    public void testExpandPrefix() {
        int n;
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("rope", ropeURI);
        for (n = 0; n < dontChange.length; ++n) {
            AbstractTestPrefixMapping.assertEquals((String)"should be unchanged", (String)dontChange[n], (String)prefixMapping.expandPrefix(dontChange[n]));
        }
        for (n = 0; n < expansions.length; ++n) {
            AbstractTestPrefixMapping.assertEquals((String)"should expand correctly", (String)expansions[n][1], (String)prefixMapping.expandPrefix(expansions[n][0]));
        }
    }

    public void testUseEasyPrefix() {
        AbstractTestPrefixMapping.testUseEasyPrefix("prefix mapping impl", this.getMapping());
    }

    public static void testUseEasyPrefix(String string, PrefixMapping prefixMapping) {
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals((String)string, (String)"", (String)prefixMapping.usePrefix(""));
        AbstractTestPrefixMapping.assertEquals((String)string, (String)ropeURI, (String)prefixMapping.usePrefix(ropeURI));
        AbstractTestPrefixMapping.assertEquals((String)string, (String)"crisp:tail", (String)prefixMapping.usePrefix("http://crisp.nosuch.net/tail"));
        AbstractTestPrefixMapping.assertEquals((String)string, (String)"butter:here:we:are", (String)prefixMapping.usePrefix("ftp://ftp.nowhere.at.all/cream#here:we:are"));
    }

    public void testAddOtherPrefixMapping() {
        PrefixMapping prefixMapping;
        PrefixMapping prefixMapping2 = this.getMapping();
        AbstractTestPrefixMapping.assertFalse((String)"must have two diffferent maps", (prefixMapping2 == (prefixMapping = this.getMapping()) ? (byte)1 : 0) != 0);
        prefixMapping2.setNsPrefix("crisp", crispURI);
        prefixMapping2.setNsPrefix("rope", ropeURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(null, (String)prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(null, (String)prefixMapping.getNsPrefixURI("rope"));
        prefixMapping.setNsPrefixes(prefixMapping2);
        this.checkContainsMapping(prefixMapping);
    }

    private void checkContainsMapping(PrefixMapping prefixMapping) {
        AbstractTestPrefixMapping.assertEquals((String)crispURI, (String)prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals((String)ropeURI, (String)prefixMapping.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals((String)butterURI, (String)prefixMapping.getNsPrefixURI("butter"));
    }

    public void testAddMap() {
        PrefixMapping prefixMapping = this.getMapping();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("crisp", crispURI);
        hashMap.put("rope", ropeURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        prefixMapping.setNsPrefixes(hashMap);
        this.checkContainsMapping(prefixMapping);
    }

    public void testSameURI() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("sharp", crispURI);
        AbstractTestPrefixMapping.assertEquals(null, (String)prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals((String)crispURI, (String)prefixMapping.getNsPrefixURI("sharp"));
    }

    public void testEmptyDoesNotWipeURI() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("frodo", ropeURI);
        prefixMapping.setNsPrefix("", ropeURI);
        AbstractTestPrefixMapping.assertEquals((String)ropeURI, (String)prefixMapping.getNsPrefixURI("frodo"));
    }

    public void testSameURIMaply() {
        PrefixMapping prefixMapping = this.getMapping();
        PrefixMapping prefixMapping2 = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping2.setNsPrefix("sharp", crispURI);
        prefixMapping.setNsPrefixes(prefixMapping2);
        AbstractTestPrefixMapping.assertEquals((String)crispURI, (String)prefixMapping.getNsPrefixURI("sharp"));
        AbstractTestPrefixMapping.assertEquals(null, (String)prefixMapping.getNsPrefixURI("crisp"));
    }

    public void testReturnsSelf() {
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertSame((Object)prefixMapping, (Object)prefixMapping.setNsPrefix("crisp", crispURI));
        AbstractTestPrefixMapping.assertSame((Object)prefixMapping, (Object)prefixMapping.setNsPrefixes(prefixMapping));
        AbstractTestPrefixMapping.assertSame((Object)prefixMapping, (Object)prefixMapping.setNsPrefixes(new HashMap()));
        AbstractTestPrefixMapping.assertSame((Object)prefixMapping, (Object)prefixMapping.removeNsPrefix("rhubarb"));
    }

    public void testRemovePrefix() {
        String string = "http://test.remove.prefixes/prefix#";
        String string2 = "http://other.test.remove.prefixes/prefix#";
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("hr", string);
        prefixMapping.setNsPrefix("br", string2);
        prefixMapping.removeNsPrefix("hr");
        AbstractTestPrefixMapping.assertEquals(null, (String)prefixMapping.getNsPrefixURI("hr"));
        AbstractTestPrefixMapping.assertEquals((String)string2, (String)prefixMapping.getNsPrefixURI("br"));
    }

    public void testLock() {
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertSame((Object)prefixMapping, (Object)prefixMapping.lock());
        try {
            prefixMapping.setNsPrefix("crisp", crispURI);
            AbstractTestPrefixMapping.fail((String)"mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            prefixMapping.setNsPrefixes(prefixMapping);
            AbstractTestPrefixMapping.fail((String)"mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            prefixMapping.setNsPrefixes(new HashMap());
            AbstractTestPrefixMapping.fail((String)"mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            prefixMapping.removeNsPrefix("toast");
            AbstractTestPrefixMapping.fail((String)"mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
    }
}

