/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestUtil {
    public static void assertIteratorValues(TestCase testCase, Iterator iterator, Object[] objectArray) {
        TestUtil.assertIteratorValues(testCase, iterator, objectArray, 0);
    }

    public static void assertIteratorValues(TestCase testCase, Iterator iterator, Object[] objectArray, int n) {
        int n2;
        Log log = LogFactory.getLog(testCase.getClass());
        boolean[] blArray = new boolean[objectArray.length];
        int n4 = 0;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            blArray[n2] = false;
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl = false;
            if (n > 0 && TestUtil.isAnonValue(e)) {
                ++n4;
                continue;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (!e.equals(objectArray[i])) continue;
                bl = true;
                blArray[i] = true;
            }
            if (!bl) {
                log.debug((Object)(testCase.getName() + " found unexpected iterator value: " + e));
            }
            TestCase.assertTrue((String)(testCase.getName() + " found unexpected iterator value"), (boolean)bl);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (!blArray[n2]) {
                log.debug((Object)(testCase.getName() + " failed to find expected iterator value: " + objectArray[n2]));
            }
            TestCase.assertTrue((String)(testCase.getName() + " failed to find expected iterator value"), (boolean)blArray[n2]);
        }
        TestCase.assertEquals((String)(testCase.getName() + " iterator test did not find the right number of anon. nodes"), (int)n, (int)n4);
    }

    public static String normalizeWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (bl) continue;
                stringBuffer.append(" ");
                bl = true;
                continue;
            }
            bl = false;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void assertIteratorLength(Iterator iterator, int n) {
        int n2 = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n2;
        }
        TestCase.assertEquals((int)n, (int)n2);
    }

    protected static boolean isAnonValue(Object object) {
        return object instanceof Resource && ((Resource)object).isAnon() || object instanceof Statement && ((Statement)object).getSubject().isAnon() || object instanceof Statement && TestUtil.isAnonValue(((Statement)object).getObject());
    }
}

