/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTransitiveGraphCache
extends TestCase {
    TransitiveGraphCache cache;
    String NS = "urn:x-hp-test:ex/";
    Node directP = Node.createURI(this.NS + "directSubProperty");
    Node closedP = Node.createURI(this.NS + "subProperty");
    Node a = Node.createURI(this.NS + "a");
    Node b = Node.createURI(this.NS + "b");
    Node c = Node.createURI(this.NS + "c");
    Node d = Node.createURI(this.NS + "d");
    Node e = Node.createURI(this.NS + "e");
    Node f = Node.createURI(this.NS + "f");
    Node g = Node.createURI(this.NS + "g");
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$TestTransitiveGraphCache;

    public TestTransitiveGraphCache(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$reasoner$test$TestTransitiveGraphCache == null ? (class$com$hp$hpl$jena$reasoner$test$TestTransitiveGraphCache = TestTransitiveGraphCache.class$("com.hp.hpl.jena.reasoner.test.TestTransitiveGraphCache")) : class$com$hp$hpl$jena$reasoner$test$TestTransitiveGraphCache);
    }

    public void testBasicCache() {
        this.initCache();
        this.cache.setCaching(false);
        this.doBasicTest(this.cache);
    }

    public void testCachingCache() {
        this.initCache();
        this.cache.setCaching(true);
        this.doBasicTest(this.cache);
    }

    public void testCloning() {
        this.initCache();
        TransitiveGraphCache transitiveGraphCache = this.cache.deepCopy();
        this.cache.addRelation(this.a, this.d);
        this.cache.addRelation(this.g, this.a);
        this.doBasicTest(transitiveGraphCache);
    }

    private void initCache() {
        this.cache = new TransitiveGraphCache(this.directP, this.closedP);
        this.cache.addRelation(this.a, this.b);
        this.cache.addRelation(this.b, this.e);
        this.cache.addRelation(this.b, this.c);
        this.cache.addRelation(this.e, this.f);
        this.cache.addRelation(this.c, this.f);
        this.cache.addRelation(this.f, this.g);
        this.cache.addRelation(this.d, this.c);
        this.cache.addRelation(this.d, this.e);
        this.cache.addRelation(this.d, this.g);
        this.cache.addRelation(this.a, this.e);
        this.cache.addRelation(this.d, this.b);
        this.cache.addRelation(this.a, this.a);
        this.cache.addRelation(this.b, this.b);
        this.cache.addRelation(this.c, this.c);
        this.cache.addRelation(this.d, this.d);
        this.cache.addRelation(this.e, this.e);
        this.cache.addRelation(this.f, this.f);
        this.cache.addRelation(this.g, this.g);
    }

    public void doBasicTest(TransitiveGraphCache transitiveGraphCache) {
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.e), new Triple(this.a, this.closedP, this.f), new Triple(this.a, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, this.g)), new Object[]{new Triple(this.a, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, this.f)), new Object[]{new Triple(this.e, this.closedP, this.f), new Triple(this.f, this.closedP, this.f), new Triple(this.c, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.closedP, this.f)), new Object[]{new Triple(this.f, this.closedP, this.f), new Triple(this.e, this.closedP, this.f), new Triple(this.b, this.closedP, this.f), new Triple(this.c, this.closedP, this.f), new Triple(this.a, this.closedP, this.f), new Triple(this.d, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.d, this.closedP, this.d), new Triple(this.d, this.closedP, this.b), new Triple(this.b, this.closedP, this.b), new Triple(this.b, this.closedP, this.e), new Triple(this.b, this.closedP, this.c), new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f), new Triple(this.c, this.closedP, this.c), new Triple(this.c, this.closedP, this.f), new Triple(this.f, this.closedP, this.f), new Triple(this.f, this.closedP, this.g), new Triple(this.g, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.e), new Triple(this.a, this.closedP, this.f), new Triple(this.a, this.closedP, this.g), new Triple(this.d, this.closedP, this.d), new Triple(this.d, this.closedP, this.b), new Triple(this.d, this.closedP, this.e), new Triple(this.d, this.closedP, this.c), new Triple(this.d, this.closedP, this.f), new Triple(this.d, this.closedP, this.g), new Triple(this.b, this.closedP, this.b), new Triple(this.b, this.closedP, this.e), new Triple(this.b, this.closedP, this.c), new Triple(this.b, this.closedP, this.f), new Triple(this.b, this.closedP, this.g), new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f), new Triple(this.e, this.closedP, this.g), new Triple(this.c, this.closedP, this.c), new Triple(this.c, this.closedP, this.f), new Triple(this.c, this.closedP, this.g), new Triple(this.f, this.closedP, this.f), new Triple(this.f, this.closedP, this.g), new Triple(this.g, this.closedP, this.g)});
        transitiveGraphCache.addRelation(this.g, this.e);
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.e, this.directP, null)), new Object[]{new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.f, this.directP, null)), new Object[]{new Triple(this.f, this.closedP, this.f), new Triple(this.f, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.g, this.directP, null)), new Object[]{new Triple(this.g, this.closedP, this.g), new Triple(this.g, this.closedP, this.e)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.g, this.closedP, null)), new Object[]{new Triple(this.g, this.closedP, this.g), new Triple(this.g, this.closedP, this.e), new Triple(this.g, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.e, this.closedP, null)), new Object[]{new Triple(this.e, this.closedP, this.g), new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.f, this.closedP, null)), new Object[]{new Triple(this.f, this.closedP, this.g), new Triple(this.f, this.closedP, this.e), new Triple(this.f, this.closedP, this.f)});
    }

    public void testRemove() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(this.a, this.b);
        transitiveGraphCache.addRelation(this.a, this.c);
        transitiveGraphCache.addRelation(this.b, this.d);
        transitiveGraphCache.addRelation(this.c, this.d);
        transitiveGraphCache.addRelation(this.d, this.e);
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.d), new Triple(this.a, this.closedP, this.e)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.b, this.closedP, null)), new Object[]{new Triple(this.b, this.closedP, this.b), new Triple(this.b, this.closedP, this.d), new Triple(this.b, this.closedP, this.e)});
        transitiveGraphCache.removeRelation(this.b, this.d);
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.d), new Triple(this.a, this.closedP, this.e)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.b, this.closedP, null)), new Object[]{new Triple(this.b, this.closedP, this.b)});
        transitiveGraphCache.removeRelation(this.a, this.c);
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.b, this.closedP, null)), new Object[]{new Triple(this.b, this.closedP, this.b)});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

