/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalResults;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalState;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.RuleInstance;

public class RuleState {
    protected RuleInstance ruleInstance;
    protected RuleState prev;
    protected BindingVector env;
    protected GoalState goalState;
    protected boolean isScheduled = false;
    int clauseIndex;
    int subjectBind;
    int predicateBind;
    int objectBind;
    protected Functor functorMatch = null;

    public RuleState(RuleState ruleState, TriplePattern triplePattern, int n, BindingVector bindingVector) {
        this.prev = ruleState;
        this.ruleInstance = ruleState.ruleInstance;
        this.clauseIndex = n;
        this.env = bindingVector;
        TriplePattern triplePattern2 = bindingVector.partInstantiate(triplePattern);
        this.goalState = this.ruleInstance.engine.findGoal(triplePattern2);
        this.initMapping(triplePattern2);
        this.ruleInstance.generator.incRefCount();
    }

    private RuleState(RuleInstance ruleInstance, BindingVector bindingVector, GoalState goalState, int n) {
        this.prev = null;
        this.ruleInstance = ruleInstance;
        this.env = bindingVector;
        this.goalState = goalState;
        this.clauseIndex = n;
        ruleInstance.generator.incRefCount();
    }

    Object next() {
        if (this.goalState == null) {
            return StateFlag.SATISFIED;
        }
        return this.goalState.next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BindingVector newEnvironment(Triple triple) {
        Node[] nodeArray;
        BindingVector bindingVector = new BindingVector(this.env);
        if (this.subjectBind != -1) {
            bindingVector.bind(this.subjectBind, triple.getSubject());
        }
        if (this.predicateBind != -1) {
            bindingVector.bind(this.predicateBind, triple.getPredicate());
        }
        if (this.objectBind != -1) {
            bindingVector.bind(this.objectBind, triple.getObject());
        }
        if (this.functorMatch == null) return bindingVector;
        Node node = triple.getObject();
        if (!Functor.isFunctor(node)) return null;
        Functor functor = (Functor)node.getLiteral().getValue();
        if (!functor.getName().equals(this.functorMatch.getName())) return null;
        Node[] nodeArray2 = this.functorMatch.getArgs();
        if (nodeArray2.length != (nodeArray = functor.getArgs()).length) {
            return null;
        }
        for (int i = 0; i < nodeArray2.length; ++i) {
            Node node2 = nodeArray2[i];
            if (!(node2 instanceof Node_RuleVariable)) continue;
            Node node3 = nodeArray[i];
            if (Functor.isFunctor(node3)) {
                return null;
            }
            if (bindingVector.bind(node2, node3)) continue;
            return null;
        }
        return bindingVector;
    }

    public Triple getResult(BindingVector bindingVector) {
        return bindingVector.instantiate(this.ruleInstance.head);
    }

    public boolean couldProcess() {
        if (this.goalState == null) {
            return true;
        }
        return this.goalState.couldProcess();
    }

    private void initMapping(TriplePattern triplePattern) {
        Node node = triplePattern.getSubject();
        this.subjectBind = node instanceof Node_RuleVariable ? ((Node_RuleVariable)node).getIndex() : -1;
        node = triplePattern.getPredicate();
        this.predicateBind = node instanceof Node_RuleVariable ? ((Node_RuleVariable)node).getIndex() : -1;
        node = triplePattern.getObject();
        int n = this.objectBind = node instanceof Node_RuleVariable ? ((Node_RuleVariable)node).getIndex() : -1;
        if (Functor.isFunctor(node)) {
            this.functorMatch = (Functor)node.getLiteral().getValue();
        }
    }

    protected int nextClauseIndex() {
        if (this.ruleInstance.clausesReordered) {
            if (this.clauseIndex == this.ruleInstance.secondClause + 1) {
                return this.ruleInstance.secondClause - 1;
            }
            if (this.clauseIndex == this.ruleInstance.secondClause) {
                return this.clauseIndex + 1;
            }
        }
        return this.clauseIndex;
    }

    public void close() {
        if (this.goalState != null) {
            this.goalState.close();
        }
        this.ruleInstance.generator.decRefCount();
    }

    public static RuleState createInitialState(Rule rule, GoalResults goalResults) {
        TriplePattern triplePattern = goalResults.goal;
        TriplePattern triplePattern2 = (TriplePattern)rule.getHeadElement(0);
        BindingVector bindingVector = BindingVector.unify(triplePattern, triplePattern2, rule.getNumVars());
        if (bindingVector == null) {
            return null;
        }
        RuleInstance ruleInstance = new RuleInstance(goalResults, rule, triplePattern2);
        int n = rule.bodyLength();
        int n2 = 0;
        while (n2 < n) {
            ClauseEntry clauseEntry;
            if ((clauseEntry = rule.getBodyElement(n2++)) instanceof TriplePattern) {
                TriplePattern triplePattern3;
                ClauseEntry clauseEntry2 = null;
                boolean bl = false;
                if (n2 < n && (clauseEntry2 = rule.getBodyElement(n2)) instanceof TriplePattern) {
                    bl = true;
                }
                if (bl) {
                    int n4 = RuleState.scoreClauseBoundness((TriplePattern)clauseEntry, triplePattern2, bindingVector);
                    int n5 = RuleState.scoreClauseBoundness((TriplePattern)clauseEntry2, triplePattern2, bindingVector);
                    if (n5 > n4) {
                        ruleInstance.clausesReordered = true;
                        ruleInstance.secondClause = n2++;
                        clauseEntry = clauseEntry2;
                    }
                }
                if (!(triplePattern3 = bindingVector.partInstantiate((TriplePattern)clauseEntry)).isLegal()) {
                    return null;
                }
                GoalState goalState = goalResults.getEngine().findGoal(triplePattern3);
                RuleState ruleState = new RuleState(ruleInstance, bindingVector, goalState, n2);
                ruleState.initMapping(triplePattern3);
                return ruleState;
            }
            if (goalResults.getEngine().processBuiltin(clauseEntry, rule, bindingVector)) continue;
            return null;
        }
        return new RuleState(ruleInstance, bindingVector, null, 0);
    }

    private static int scoreClauseBoundness(TriplePattern triplePattern, TriplePattern triplePattern2, BindingVector bindingVector) {
        return RuleState.scoreNodeBoundness(triplePattern.getSubject(), triplePattern2, bindingVector) + RuleState.scoreNodeBoundness(triplePattern.getPredicate(), triplePattern2, bindingVector) + RuleState.scoreNodeBoundness(triplePattern.getObject(), triplePattern2, bindingVector);
    }

    private static int scoreNodeBoundness(Node node, TriplePattern triplePattern, BindingVector bindingVector) {
        if (node.isVariable()) {
            if (node == triplePattern.getSubject() || node == triplePattern.getPredicate() || node == triplePattern.getObject()) {
                Node node2 = bindingVector.getBinding(node);
                if (node == null || node.isVariable()) {
                    return -5;
                }
                return 5;
            }
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "RuleState " + this.ruleInstance.rule.toShortString() + "(" + (this.clauseIndex - 1) + ")" + ", gs=" + this.goalState;
    }
}

