/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.FBLPRuleInfGraph;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.List;

public class FBLPRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List rules;
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    protected boolean traceOn = false;
    protected static final boolean cachePreload = true;
    protected InfGraph preload;

    public FBLPRuleReasoner(List list) {
        this.rules = list;
    }

    public FBLPRuleReasoner(ReasonerFactory reasonerFactory) {
        this(null, reasonerFactory);
    }

    public FBLPRuleReasoner(List list, ReasonerFactory reasonerFactory) {
        this(list);
        this.factory = reasonerFactory;
    }

    protected FBLPRuleReasoner(List list, Graph graph, ReasonerFactory reasonerFactory) {
        this(list, reasonerFactory);
        this.schemaGraph = graph;
    }

    public Model getCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public void addDescription(Model model, Resource resource) {
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model model = this.factory.getCapabilities();
        Resource resource = model.getResource(this.factory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBLPRuleInfGraph fBLPRuleInfGraph = new FBLPRuleInfGraph(this, this.rules, this.getPreload(), graph);
        fBLPRuleInfGraph.prepare();
        FBLPRuleReasoner fBLPRuleReasoner = new FBLPRuleReasoner(this.rules, fBLPRuleInfGraph, this.factory);
        fBLPRuleReasoner.setDerivationLogging(this.recordDerivations);
        fBLPRuleReasoner.setTraceOn(this.traceOn);
        return fBLPRuleReasoner;
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return this.bindSchema(model.getGraph());
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        InfGraph infGraph = this.schemaGraph == null ? this.getPreload() : (FBLPRuleInfGraph)this.schemaGraph;
        FBLPRuleInfGraph fBLPRuleInfGraph = new FBLPRuleInfGraph(this, this.rules, infGraph);
        fBLPRuleInfGraph.setDerivationLogging(this.recordDerivations);
        fBLPRuleInfGraph.setTraceOn(this.traceOn);
        fBLPRuleInfGraph.rebind(graph);
        return fBLPRuleInfGraph;
    }

    public void setRules(List list) {
        this.rules = list;
        this.preload = null;
    }

    public List getRules() {
        return this.rules;
    }

    public synchronized void tablePredicate(Node node) {
        Rule rule = new Rule("", new ClauseEntry[]{new Functor("table", new Node[]{node})}, new ClauseEntry[0]);
        this.rules.add(rule);
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null) {
            this.preload = new FBLPRuleInfGraph(this, this.rules, null);
            this.preload.prepare();
        }
        return this.preload;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public void setParameter(Property property, Object object) {
        if (property.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(property, object);
        } else if (property.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(property, object);
        } else {
            throw new IllegalParameterException("Don't recognize configuration parameter " + property + " for rule-based reasoner");
        }
    }
}

