/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Functor
implements ClauseEntry {
    protected String name;
    protected Node[] args;
    protected Builtin implementor;
    public static final Filter acceptFilter = new Filter(){

        public boolean accept(Object object) {
            if (((Triple)object).getSubject().isLiteral()) {
                return true;
            }
            Node node = ((Triple)object).getObject();
            return node.isLiteral() && node.getLiteral().getDatatype() == FunctorDatatype.theFunctorDatatype;
        }
    };
    protected static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$reasoner$rulesys$Functor == null ? (class$com$hp$hpl$jena$reasoner$rulesys$Functor = Functor.class$("com.hp.hpl.jena.reasoner.rulesys.Functor")) : class$com$hp$hpl$jena$reasoner$rulesys$Functor));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$Functor;

    public Functor(String string, List list) {
        this.name = string;
        this.args = list.toArray(new Node[0]);
    }

    public Functor(String string, Node[] nodeArray) {
        this.name = string;
        this.args = nodeArray;
    }

    public Functor(String string, List list, BuiltinRegistry builtinRegistry) {
        this.name = string;
        this.args = list.toArray(new Node[0]);
        this.implementor = builtinRegistry.getImplementation(string);
    }

    public String getName() {
        return this.name;
    }

    public Node[] getArgs() {
        return this.args;
    }

    public int getArgLength() {
        return this.args.length;
    }

    public boolean isGround() {
        for (int i = 0; i < this.args.length; ++i) {
            Node node = this.args[i];
            if (!(node instanceof Node_RuleVariable) && !(node instanceof Node_ANY)) continue;
            return false;
        }
        return true;
    }

    public boolean isGround(BindingEnvironment bindingEnvironment) {
        for (int i = 0; i < this.args.length; ++i) {
            Node node = this.args[i];
            if (!bindingEnvironment.getGroundVersion(this.args[i]).isVariable()) continue;
            return false;
        }
        return true;
    }

    public boolean evalAsBodyClause(RuleContext ruleContext) {
        if (this.getImplementor() == null) {
            logger.warn((Object)("Invoking undefined functor " + this.getName() + " in " + ruleContext.getRule().toShortString()));
            return false;
        }
        return this.implementor.bodyCall(this.getBoundArgs(ruleContext.getEnv()), this.args.length, ruleContext);
    }

    public boolean safeEvalAsBodyClause(RuleContext ruleContext) {
        if (this.getImplementor() == null) {
            logger.warn((Object)("Invoking undefined functor " + this.getName() + " in " + ruleContext.getRule().toShortString()));
            return false;
        }
        if (this.implementor.isSafe()) {
            return this.implementor.bodyCall(this.getBoundArgs(ruleContext.getEnv()), this.args.length, ruleContext);
        }
        return false;
    }

    public Node[] getBoundArgs(BindingEnvironment bindingEnvironment) {
        Node[] nodeArray = new Node[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            nodeArray[i] = bindingEnvironment.getGroundVersion(this.args[i]);
        }
        return nodeArray;
    }

    public Builtin getImplementor() {
        if (this.implementor == null) {
            this.implementor = BuiltinRegistry.theRegistry.getImplementation(this.name);
        }
        return this.implementor;
    }

    public void setImplementor(Builtin builtin) {
        this.implementor = builtin;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < this.args.length; ++i) {
            stringBuffer.append(PrintUtil.print(this.args[i]));
            if (i == this.args.length - 1) {
                stringBuffer.append(")");
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static boolean isFunctor(Node node) {
        if (node == null) {
            return false;
        }
        return node.isLiteral() && node.getLiteral().getDatatype() == FunctorDatatype.theFunctorDatatype;
    }

    public boolean equals(Object object) {
        if (object instanceof Functor) {
            Functor functor = (Functor)object;
            if (this.name.equals(functor.name) && this.args.length == functor.args.length) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].sameValueAs(functor.args[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.args.length << 2;
    }

    public boolean sameAs(Object object) {
        if (object instanceof Functor) {
            Functor functor = (Functor)object;
            if (this.name.equals(functor.name) && this.args.length == functor.args.length) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (Node_RuleVariable.sameNodeAs(this.args[i], functor.args[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static Node makeFunctorNode(String string, Node[] nodeArray) {
        Functor functor = new Functor(string, nodeArray);
        LiteralLabel literalLabel = new LiteralLabel(functor, null, FunctorDatatype.theFunctorDatatype);
        return new Node_Literal(literalLabel);
    }

    public static Node makeFunctorNode(Functor functor) {
        LiteralLabel literalLabel = new LiteralLabel(functor, null, FunctorDatatype.theFunctorDatatype);
        return new Node_Literal(literalLabel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FunctorDatatype
    extends BaseDatatype {
        public static final RDFDatatype theFunctorDatatype = new FunctorDatatype();

        public FunctorDatatype() {
            super("urn:x-hp-jena:Functor");
        }
    }
}

