/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryIsEquivalentTranslator
extends DIGQueryTranslator {
    public DIGQueryIsEquivalentTranslator(String string) {
        super(null, string, null);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        Element element = dIGAdapter.addElement(document.getDocumentElement(), "equivalents");
        dIGAdapter.addClassDescription(element, triplePattern.getSubject());
        return document;
    }

    public ExtendedIterator translateResponse(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        ExtendedIterator extendedIterator = new SimpleXMLPath(true).appendElementPath("conceptSet").appendElementPath("synonyms").appendElementPath("catom").appendAttrPath("name").getAll(document);
        String string = dIGAdapter.getNodeID(triplePattern.getObject());
        boolean bl = false;
        while (!bl && extendedIterator.hasNext()) {
            bl = string.equals(extendedIterator.next());
        }
        return bl ? new SingletonIterator(new Triple(triplePattern.getSubject(), triplePattern.getPredicate(), triplePattern.getObject())) : NullIterator.instance;
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter) {
        return node.isConcrete();
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter) {
        return node.isConcrete();
    }
}

