/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class FinderUtil {
    public static Finder cascade(Finder finder, Finder finder2) {
        if (finder == null || finder instanceof FGraph && ((FGraph)finder).getGraph() == null) {
            return finder2;
        }
        if (finder2 == null || finder2 instanceof FGraph && ((FGraph)finder2).getGraph() == null) {
            return finder;
        }
        return new Cascade(finder, finder2);
    }

    public static Finder cascade(Finder finder, Finder finder2, Finder finder3) {
        return new Cascade(finder, FinderUtil.cascade(finder2, finder3));
    }

    public static Finder cascade(Finder finder, Finder finder2, Finder finder3, Finder finder4) {
        return new Cascade(finder, FinderUtil.cascade(finder2, FinderUtil.cascade(finder3, finder4)));
    }

    private static class Cascade
    implements Finder {
        Finder first;
        Finder second;

        Cascade(Finder finder, Finder finder2) {
            this.first = finder;
            this.second = finder2;
        }

        public ExtendedIterator find(TriplePattern triplePattern) {
            if (this.second == null) {
                return this.first.find(triplePattern);
            }
            if (this.first == null) {
                return this.second.find(triplePattern);
            }
            return this.first.findWithContinuation(triplePattern, this.second);
        }

        public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
            return FinderUtil.cascade(this.first, this.second, finder).find(triplePattern);
        }

        public boolean contains(TriplePattern triplePattern) {
            ExtendedIterator extendedIterator = this.find(triplePattern);
            boolean bl = extendedIterator.hasNext();
            extendedIterator.close();
            return bl;
        }
    }
}

