/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestSimpleListStatements
extends ModelTestBase {
    Model model = null;
    static boolean booleanValue = true;
    static char charValue = (char)99;
    static long longValue = 456L;
    static float floatValue = 5.67f;
    static double doubleValue = 6.78;
    static String stringValue = "stringValue";
    static String langValue = "en";
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements;

    public TestSimpleListStatements(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements == null ? (class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements = TestSimpleListStatements.class$("com.hp.hpl.jena.rdf.model.test.TestSimpleListStatements")) : class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements);
    }

    protected void setUp() throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.createResource("http://example.org/boolean").addProperty(RDF.value, booleanValue);
        this.model.createResource("http://example.org/char").addProperty(RDF.value, charValue);
        this.model.createResource("http://example.org/long").addProperty(RDF.value, longValue);
        this.model.createResource("http://example.org/float").addProperty(RDF.value, floatValue);
        this.model.createResource("http://example.org/double").addProperty(RDF.value, doubleValue);
        this.model.createResource("http://example.org/string").addProperty(RDF.value, stringValue);
        this.model.createResource("http://example.org/langString").addProperty(RDF.value, stringValue, langValue);
    }

    protected void tearDown() throws Exception {
        this.model.close();
        this.model = null;
    }

    public void testBoolean() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, booleanValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            TestSimpleListStatements.assertEquals((String)stmtIterator.nextStatement().getSubject().getURI(), (String)"http://example.org/boolean");
        }
        TestSimpleListStatements.assertEquals((int)1, (int)n);
    }

    public void testChar() {
        StmtIterator stmtIterator = this.model.listStatements((Resource)null, (Property)null, charValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            TestSimpleListStatements.assertEquals((String)stmtIterator.nextStatement().getSubject().getURI(), (String)"http://example.org/char");
        }
        TestSimpleListStatements.assertEquals((int)1, (int)n);
    }

    public void testLong() {
        StmtIterator stmtIterator = this.model.listStatements((Resource)null, (Property)null, longValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            TestSimpleListStatements.assertEquals((String)stmtIterator.nextStatement().getSubject().getURI(), (String)"http://example.org/long");
        }
        TestSimpleListStatements.assertEquals((int)1, (int)n);
    }

    public void testFloat() {
        StmtIterator stmtIterator = this.model.listStatements((Resource)null, (Property)null, floatValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            TestSimpleListStatements.assertEquals((String)stmtIterator.nextStatement().getSubject().getURI(), (String)"http://example.org/float");
        }
        TestSimpleListStatements.assertEquals((int)1, (int)n);
    }

    public void testDouble() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, doubleValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            TestSimpleListStatements.assertEquals((String)stmtIterator.nextStatement().getSubject().getURI(), (String)"http://example.org/double");
        }
        TestSimpleListStatements.assertEquals((int)1, (int)n);
    }

    public void testString() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, stringValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            TestSimpleListStatements.assertEquals((String)stmtIterator.nextStatement().getSubject().getURI(), (String)"http://example.org/string");
        }
        TestSimpleListStatements.assertEquals((int)1, (int)n);
    }

    public void testLangString() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, stringValue, langValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            TestSimpleListStatements.assertEquals((String)stmtIterator.nextStatement().getSubject().getURI(), (String)"http://example.org/langString");
        }
        TestSimpleListStatements.assertEquals((int)1, (int)n);
    }

    public void testAll() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, (RDFNode)null);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        TestSimpleListStatements.assertEquals((int)7, (int)n);
    }

    public Model modelWithStatements(StmtIterator stmtIterator) {
        Model model = ModelFactory.createDefaultModel();
        while (stmtIterator.hasNext()) {
            model.add(stmtIterator.nextStatement());
        }
        return model;
    }

    public void checkReturns(String string, StmtIterator stmtIterator) {
        Model model;
        Model model2 = TestSimpleListStatements.modelWithStatements(string);
        if (!model2.isIsomorphicWith(model = this.modelWithStatements(stmtIterator))) {
            TestSimpleListStatements.fail((String)("wanted " + model2 + " got " + model));
        }
    }

    public void testListStatementsSPO() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = TestSimpleListStatements.resource(model, "A");
        Resource resource2 = TestSimpleListStatements.resource(model, "X");
        Property property = TestSimpleListStatements.property(model, "P");
        Property property2 = TestSimpleListStatements.property(model, "P1");
        Resource resource3 = TestSimpleListStatements.resource(model, "O");
        Resource resource4 = TestSimpleListStatements.resource(model, "Y");
        String string = "S P O; S1 P O; S2 P O";
        String string2 = "A P1 B; A P1 B; A P1 C";
        String string3 = "X P1 Y; X P2 Y; X P3 Y";
        TestSimpleListStatements.modelAdd(model, string);
        TestSimpleListStatements.modelAdd(model, string2);
        TestSimpleListStatements.modelAdd(model, string3);
        this.checkReturns(string, model.listStatements(null, property, resource3));
        this.checkReturns(string2, model.listStatements(resource, property2, (RDFNode)null));
        this.checkReturns(string3, model.listStatements(resource2, null, resource4));
        model.close();
    }

    public void testListStatementsClever() {
        Model model = ModelFactory.createDefaultModel();
        TestSimpleListStatements.modelAdd(model, "S P O; S P O2; S P2 O; S2 P O");
        SimpleSelector simpleSelector = new SimpleSelector(null, null, (RDFNode)null){

            public boolean test(Statement statement) {
                return ((Object)statement.getSubject()).toString().length() + statement.getPredicate().toString().length() + ((Object)statement.getObject()).toString().length() == 12;
            }

            public boolean isSimple() {
                return false;
            }
        };
        this.checkReturns("S P O", model.listStatements(simpleSelector));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

