/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ModelTestBase
extends GraphTestBase {
    private static Model aModel = ModelTestBase.standardModel();
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Resource;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public ModelTestBase(String string) {
        super(string);
    }

    private static Model standardModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefixes(PrefixMapping.Standard);
        return model;
    }

    public static Statement statement(Model model, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Resource resource = ModelTestBase.resource(model, stringTokenizer.nextToken());
        Property property = ModelTestBase.property(model, stringTokenizer.nextToken());
        RDFNode rDFNode = ModelTestBase.rdfNode(model, stringTokenizer.nextToken());
        return model.createStatement(resource, property, rDFNode);
    }

    public static RDFNode rdfNode(Model model, String string) {
        Node node = Node.create(model, string);
        Class clazz = node.isLiteral() ? (class$com$hp$hpl$jena$rdf$model$Literal == null ? (class$com$hp$hpl$jena$rdf$model$Literal = ModelTestBase.class$("com.hp.hpl.jena.rdf.model.Literal")) : class$com$hp$hpl$jena$rdf$model$Literal) : (class$com$hp$hpl$jena$rdf$model$Resource == null ? (class$com$hp$hpl$jena$rdf$model$Resource = ModelTestBase.class$("com.hp.hpl.jena.rdf.model.Resource")) : class$com$hp$hpl$jena$rdf$model$Resource);
        return (RDFNode)((Object)((ModelCom)model).getNodeAs(node, clazz));
    }

    public static Resource resource(String string) {
        return ModelTestBase.resource(aModel, string);
    }

    public static Resource resource(Model model, String string) {
        return (Resource)ModelTestBase.rdfNode(model, string);
    }

    public static Property property(String string) {
        return ModelTestBase.property(aModel, string);
    }

    public static Property property(Model model, String string) {
        return (Property)ModelTestBase.rdfNode(model, string, class$com$hp$hpl$jena$rdf$model$Property == null ? (class$com$hp$hpl$jena$rdf$model$Property = ModelTestBase.class$("com.hp.hpl.jena.rdf.model.Property")) : class$com$hp$hpl$jena$rdf$model$Property);
    }

    public static Literal literal(Model model, String string) {
        return (Literal)ModelTestBase.rdfNode(model, string, class$com$hp$hpl$jena$rdf$model$Literal == null ? (class$com$hp$hpl$jena$rdf$model$Literal = ModelTestBase.class$("com.hp.hpl.jena.rdf.model.Literal")) : class$com$hp$hpl$jena$rdf$model$Literal);
    }

    public static RDFNode rdfNode(Model model, String string, Class clazz) {
        Node node = Node.create(model, string);
        return (RDFNode)((Object)((ModelCom)model).getNodeAs(node, clazz));
    }

    public static Statement[] statements(Model model, String string) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(ModelTestBase.statement(model, stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    public static Resource[] resources(Model model, String string) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(ModelTestBase.resource(model, stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Resource[arrayList.size()]);
    }

    public static Model modelAdd(Model model, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            model.add(ModelTestBase.statement(model, stringTokenizer.nextToken()));
        }
        return model;
    }

    public static Model modelWithStatements(String string) {
        return ModelTestBase.modelWithStatements(ReificationStyle.Standard, string);
    }

    public static Model modelWithStatements(ReificationStyle reificationStyle, String string) {
        return ModelTestBase.modelAdd(ModelFactory.createDefaultModel(reificationStyle), string);
    }

    public static Model createMemModel() {
        return ModelFactory.createDefaultModel();
    }

    public void assertIsoModels(String string, Model model, Model model2) {
        if (!model.isIsomorphicWith(model2)) {
            ModelTestBase.fail((String)(string + ": expected " + model + " but had " + model2));
        }
    }

    public void assertIsoModels(Model model, Model model2) {
        this.assertIsoModels("models must be isomorphic", model, model2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

