/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.HasNoModelException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.JenaException;

public class StatementImpl
implements Statement {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;
    private final Model model;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Bag;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Alt;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Seq;

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode) {
        this.model = null;
        this.subject = resource;
        this.predicate = property;
        this.object = rDFNode;
    }

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode, Model model) {
        this.model = model;
        this.subject = (Resource)resource.inModel(model);
        this.predicate = (Property)property.inModel(model);
        this.object = rDFNode.inModel(model);
    }

    public static Statement toStatement(Triple triple, EnhGraph enhGraph) {
        ResourceImpl resourceImpl = new ResourceImpl(triple.getSubject(), enhGraph);
        PropertyImpl propertyImpl = new PropertyImpl(triple.getPredicate(), enhGraph);
        RDFNode rDFNode = StatementImpl.createObject(triple.getObject(), enhGraph);
        return new StatementImpl(resourceImpl, propertyImpl, rDFNode, (Model)((Object)enhGraph));
    }

    public Resource getSubject() {
        return this.subject;
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public Statement getStatementProperty(Property property) {
        return this.asResource().getRequiredProperty(property);
    }

    private Resource mustBeResource(RDFNode rDFNode) {
        if (rDFNode instanceof Resource) {
            return (Resource)rDFNode;
        }
        throw new ResourceRequiredException(rDFNode);
    }

    public Resource getResource() {
        return this.mustBeResource(this.object);
    }

    public Resource getResource(ResourceF resourceF) {
        return resourceF.createResource(this.getResource());
    }

    public Statement getProperty(Property property) {
        return this.getResource().getRequiredProperty(property);
    }

    public Literal getLiteral() {
        if (this.object instanceof Literal) {
            return (Literal)this.object;
        }
        throw new LiteralRequiredException(this.object);
    }

    public boolean getBoolean() {
        return this.getLiteral().getBoolean();
    }

    public byte getByte() {
        return this.getLiteral().getByte();
    }

    public short getShort() {
        return this.getLiteral().getShort();
    }

    public int getInt() {
        return this.getLiteral().getInt();
    }

    public long getLong() {
        return this.getLiteral().getLong();
    }

    public char getChar() {
        return this.getLiteral().getChar();
    }

    public float getFloat() {
        return this.getLiteral().getFloat();
    }

    public double getDouble() {
        return this.getLiteral().getDouble();
    }

    public String getString() {
        return this.getLiteral().getLexicalForm();
    }

    public Object getObject(ObjectF objectF) {
        try {
            return objectF.createObject(((Literal)this.object).toString());
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    private EnhNode get(Class clazz) {
        return (EnhNode)((Object)this.object.as(clazz));
    }

    public Bag getBag() {
        return (Bag)((Object)this.get(class$com$hp$hpl$jena$rdf$model$Bag == null ? (class$com$hp$hpl$jena$rdf$model$Bag = StatementImpl.class$("com.hp.hpl.jena.rdf.model.Bag")) : class$com$hp$hpl$jena$rdf$model$Bag));
    }

    public Alt getAlt() {
        return (Alt)((Object)this.get(class$com$hp$hpl$jena$rdf$model$Alt == null ? (class$com$hp$hpl$jena$rdf$model$Alt = StatementImpl.class$("com.hp.hpl.jena.rdf.model.Alt")) : class$com$hp$hpl$jena$rdf$model$Alt));
    }

    public Seq getSeq() {
        return (Seq)((Object)this.get(class$com$hp$hpl$jena$rdf$model$Seq == null ? (class$com$hp$hpl$jena$rdf$model$Seq = StatementImpl.class$("com.hp.hpl.jena.rdf.model.Seq")) : class$com$hp$hpl$jena$rdf$model$Seq));
    }

    public String getLanguage() {
        return this.getLiteral().getLanguage();
    }

    public boolean getWellFormed() {
        return this.getLiteral().getWellFormed();
    }

    public Statement changeObject(boolean bl) {
        return this.stringReplace(String.valueOf(bl));
    }

    public Statement changeObject(long l) {
        return this.stringReplace(String.valueOf(l));
    }

    public Statement changeObject(char c) {
        return this.stringReplace(String.valueOf(c));
    }

    public Statement changeObject(float f) {
        return this.stringReplace(String.valueOf(f));
    }

    public Statement changeObject(double d) {
        return this.stringReplace(String.valueOf(d));
    }

    public Statement changeObject(String string) {
        return this.stringReplace(String.valueOf(string));
    }

    public Statement changeObject(String string, boolean bl) {
        return this.stringReplace(String.valueOf(string), "", bl);
    }

    public Statement changeObject(String string, String string2) {
        return this.stringReplace(String.valueOf(string), string2, false);
    }

    public Statement changeObject(String string, String string2, boolean bl) {
        return this.stringReplace(String.valueOf(string), string2, bl);
    }

    public Statement changeObject(RDFNode rDFNode) {
        return this.replace(rDFNode);
    }

    public Statement changeObject(Object object) {
        return object instanceof RDFNode ? this.replace((RDFNode)object) : this.stringReplace(object.toString());
    }

    protected Model mustHaveModel() {
        if (this.model == null) {
            throw new HasNoModelException(this);
        }
        return this.model;
    }

    protected StatementImpl stringReplace(String string) {
        return this.stringReplace(string, "", false);
    }

    protected StatementImpl stringReplace(String string, String string2, boolean bl) {
        return this.replace(new LiteralImpl(Node.createLiteral(string, string2, bl), this.model));
    }

    protected StatementImpl replace(RDFNode rDFNode) {
        this.mustHaveModel().remove(this).add(this.subject, this.predicate, rDFNode);
        return new StatementImpl(this.subject, this.predicate, rDFNode, this.model);
    }

    public String toString() {
        return "[" + ((Object)this.subject).toString() + ", " + this.predicate.toString() + ", " + this.objectString() + "]";
    }

    private String objectString() {
        return this.object.asNode().toString(null, true);
    }

    public boolean equals(Object object) {
        return object instanceof Statement && this.sameAs((Statement)object);
    }

    private final boolean sameAs(Statement statement) {
        return ((Object)this.subject).equals(statement.getSubject()) && this.predicate.equals(statement.getPredicate()) && this.object.equals(statement.getObject());
    }

    public int hashCode() {
        return this.asTriple().hashCode();
    }

    public Statement remove() {
        this.mustHaveModel().remove(this);
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    public Resource asResource() {
        return this.mustHaveModel().getAnyReifiedStatement(this);
    }

    public void removeReification() {
        this.mustHaveModel().removeAllReifications(this);
    }

    public Triple asTriple() {
        return new Triple(this.subject.asNode(), this.predicate.asNode(), this.object.asNode());
    }

    public static Triple[] asTriples(Statement[] statementArray) {
        Triple[] tripleArray = new Triple[statementArray.length];
        for (int i = 0; i < statementArray.length; ++i) {
            tripleArray[i] = statementArray[i].asTriple();
        }
        return tripleArray;
    }

    public boolean isReified() {
        return this.mustHaveModel().isReified(this);
    }

    public ReifiedStatement createReifiedStatement() {
        return ReifiedStatementImpl.create(this);
    }

    public ReifiedStatement createReifiedStatement(String string) {
        return ReifiedStatementImpl.create(this.getModel(), string, (Statement)this);
    }

    public RSIterator listReifiedStatements() {
        return this.mustHaveModel().listReifiedStatements(this);
    }

    public static RDFNode createObject(Node node, EnhGraph enhGraph) {
        return node.isLiteral() ? new LiteralImpl(node, enhGraph) : new ResourceImpl(node, enhGraph);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

