/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.HasNoModelException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.Util;

public class ResourceImpl
extends EnhNode
implements Resource {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return !node.isLiteral();
        }

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (node.isLiteral()) {
                throw new ResourceRequiredException(node);
            }
            return new ResourceImpl(node, enhGraph);
        }
    };
    public static final Implementation rdfNodeFactory = new Implementation(){

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return true;
        }

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (node.isURI() || node.isBlank()) {
                return new ResourceImpl(node, enhGraph);
            }
            if (node.isLiteral()) {
                return new LiteralImpl(node, enhGraph);
            }
            return null;
        }
    };
    private int splitHere = 0;

    private ResourceImpl(Node node, int n, Model model) {
        super(node, (ModelCom)model);
        this.splitHere = n;
    }

    public ResourceImpl() {
        this((Model)null);
    }

    public ResourceImpl(Model model) {
        this(ResourceImpl.fresh(null), 0, model);
    }

    public ResourceImpl(Node node, Model model) {
        this(node, node.isURI() ? ResourceImpl.whereToSplit(node.toString()) : 0, model);
    }

    public ResourceImpl(Node node, EnhGraph enhGraph) {
        this(node, (Model)((Object)enhGraph));
    }

    public ResourceImpl(String string) {
        this(ResourceImpl.fresh(string), ResourceImpl.whereToSplit(string), null);
    }

    public ResourceImpl(String string, String string2) {
        this(Node.createURI(string + string2), string.length(), null);
    }

    public ResourceImpl(AnonId anonId) {
        this(anonId, null);
    }

    public ResourceImpl(AnonId anonId, Model model) {
        this(Node.createAnon(anonId), 0, model);
    }

    public ResourceImpl(String string, Model model) {
        this(ResourceImpl.fresh(string), ResourceImpl.whereToSplit(string), model);
    }

    public ResourceImpl(Resource resource, Model model) {
        this(resource.getNode(), model);
    }

    public ResourceImpl(String string, String string2, Model model) {
        this(Node.createURI(string + string2), string.length(), model);
    }

    public Object visitWith(RDFVisitor rDFVisitor) {
        return this.isAnon() ? rDFVisitor.visitBlank(this, this.getId()) : rDFVisitor.visitURI(this, this.getURI());
    }

    public RDFNode inModel(Model model) {
        return this.getModel() == model ? this : (this.isAnon() ? model.createResource(this.getId()) : model.createResource(this.getURI()));
    }

    private static int whereToSplit(String string) {
        if (string == null) {
            return 0;
        }
        int n = Util.splitNamespace(string);
        return n == 0 ? string.length() : n;
    }

    private static Node fresh(String string) {
        return string == null ? Node.createAnon(new AnonId()) : Node.createURI(string);
    }

    public Node getNode() {
        return this.asNode();
    }

    public AnonId getId() {
        return this.asNode().getBlankNodeId();
    }

    public String getURI() {
        return this.isAnon() ? null : this.node.getURI();
    }

    public String getNameSpace() {
        return this.isAnon() ? null : this.getURI().substring(0, this.splitHere);
    }

    public String getLocalName() {
        return this.isAnon() ? null : this.getURI().substring(this.splitHere);
    }

    public String toString() {
        return this.asNode().toString();
    }

    public boolean isAnon() {
        return this.asNode().isBlank();
    }

    protected ModelCom mustHaveModel() {
        ModelCom modelCom = (ModelCom)this.getGraph();
        if (modelCom == null) {
            throw new HasNoModelException(this);
        }
        return modelCom;
    }

    public Statement getRequiredProperty(Property property) {
        return this.mustHaveModel().getRequiredProperty(this, property);
    }

    public Statement getProperty(Property property) {
        return this.mustHaveModel().getProperty(this, property);
    }

    public StmtIterator listProperties(Property property) {
        return this.mustHaveModel().listStatements((Resource)this, property, (RDFNode)null);
    }

    public StmtIterator listProperties() {
        return this.mustHaveModel().listStatements((Resource)this, null, (RDFNode)null);
    }

    public Resource addProperty(Property property, boolean bl) {
        this.mustHaveModel().add((Resource)this, property, bl);
        return this;
    }

    public Resource addProperty(Property property, long l) {
        this.mustHaveModel().add((Resource)this, property, l);
        return this;
    }

    public Resource addProperty(Property property, char c) {
        this.mustHaveModel().add((Resource)this, property, c);
        return this;
    }

    public Resource addProperty(Property property, float f) {
        this.mustHaveModel().add((Resource)this, property, f);
        return this;
    }

    public Resource addProperty(Property property, double d) {
        this.mustHaveModel().add((Resource)this, property, d);
        return this;
    }

    public Resource addProperty(Property property, String string) {
        this.mustHaveModel().add((Resource)this, property, string);
        return this;
    }

    public Resource addProperty(Property property, String string, String string2) {
        this.mustHaveModel().add((Resource)this, property, string, string2);
        return this;
    }

    public Resource addProperty(Property property, Object object) {
        this.mustHaveModel().add((Resource)this, property, object);
        return this;
    }

    public Resource addProperty(Property property, RDFNode rDFNode) {
        this.mustHaveModel().add((Resource)this, property, rDFNode);
        return this;
    }

    public boolean hasProperty(Property property) {
        return this.mustHaveModel().contains(this, property);
    }

    public boolean hasProperty(Property property, boolean bl) {
        return this.mustHaveModel().contains((Resource)this, property, bl);
    }

    public boolean hasProperty(Property property, long l) {
        return this.mustHaveModel().contains((Resource)this, property, l);
    }

    public boolean hasProperty(Property property, char c) {
        return this.mustHaveModel().contains((Resource)this, property, c);
    }

    public boolean hasProperty(Property property, float f) {
        return this.mustHaveModel().contains((Resource)this, property, f);
    }

    public boolean hasProperty(Property property, double d) {
        return this.mustHaveModel().contains((Resource)this, property, d);
    }

    public boolean hasProperty(Property property, String string) {
        return this.mustHaveModel().contains((Resource)this, property, string);
    }

    public boolean hasProperty(Property property, String string, String string2) {
        return this.mustHaveModel().contains(this, property, string, string2);
    }

    public boolean hasProperty(Property property, Object object) {
        return this.mustHaveModel().contains((Resource)this, property, object);
    }

    public boolean hasProperty(Property property, RDFNode rDFNode) {
        return this.mustHaveModel().contains((Resource)this, property, rDFNode);
    }

    public Resource removeProperties() {
        this.mustHaveModel().remove(this.listProperties());
        return this;
    }

    public Resource removeAll(Property property) {
        this.mustHaveModel().remove(this.listProperties(property));
        return this;
    }

    public Resource begin() {
        this.mustHaveModel().begin();
        return this;
    }

    public Resource abort() {
        this.mustHaveModel().abort();
        return this;
    }

    public Resource commit() {
        this.mustHaveModel().commit();
        return this;
    }

    public Model getModel() {
        return (ModelCom)this.getGraph();
    }
}

