/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.tidy.CheckerResults;
import com.hp.hpl.jena.ontology.tidy.Redirect;
import com.hp.hpl.jena.ontology.tidy.impl.CheckerImpl;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.ExtendedHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.SAXException;

public class StreamingChecker
extends CheckerImpl
implements CheckerResults {
    private Redirect r = new Redirect();
    private static String OWLIMPORTS = OWL.imports.getURI();
    private Set imported;
    static int cnt = 0;
    private StatementHandler sh = new StatementHandler(){

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            StreamingChecker.this.tripleCnt++;
            StreamingChecker.this.add(StreamingChecker.convert(aResource, aResource2, aResource3));
            if (aResource2.getURI().equals(OWLIMPORTS)) {
                StreamingChecker.this.loadx(aResource3.getURI(), false);
            }
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            StreamingChecker.this.tripleCnt++;
            StreamingChecker.this.add(StreamingChecker.convert(aResource, aResource2, aLiteral));
        }
    };
    private ExtendedHandler eh = new ExtendedHandler(){

        public void endBNodeScope(AResource aResource) {
            StreamingChecker.this.endBNode((Node)aResource.getUserData());
        }

        public boolean discardNodesWithNodeID() {
            return false;
        }

        public void startRDF() {
        }

        public void endRDF() {
        }
    };
    private int tripleCnt = 0;

    public String[] getLoaded() {
        String[] stringArray = new String[this.imported.size()];
        int n = 0;
        Iterator iterator = this.imported.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = this.r.redirect((String)iterator.next());
            ++n;
        }
        return stringArray;
    }

    public int getTripleCount() {
        int n = cnt;
        return this.tripleCnt;
    }

    public Redirect getRedirect() {
        return this.r;
    }

    public StreamingChecker(boolean bl) {
        super(bl);
        this.setOptimizeMemory(true);
    }

    public synchronized void load(String string) {
        this.loadx(string, true);
    }

    private void loadx(String string, boolean bl) {
        try {
            this.load(string, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Exception: " + exception.getMessage());
            System.err.println("Exception handling not yet implemented");
        }
    }

    static Node convert(ALiteral aLiteral) {
        String string = aLiteral.getDatatypeURI();
        if (string == null) {
            return Node.createLiteral(((Object)aLiteral).toString(), aLiteral.getLang(), false);
        }
        if (aLiteral.isWellFormedXML()) {
            return Node.createLiteral(((Object)aLiteral).toString(), null, true);
        }
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string);
        return Node.createLiteral(((Object)aLiteral).toString(), null, rDFDatatype);
    }

    static Node convert(AResource aResource) {
        if (aResource.isAnonymous()) {
            String string = aResource.getAnonymousID();
            Node node = (Node)aResource.getUserData();
            if (node == null) {
                node = Node.createAnon(new AnonId("" + cnt++));
                aResource.setUserData(node);
            }
            return node;
        }
        return Node.createURI(aResource.getURI());
    }

    static Triple convert(AResource aResource, AResource aResource2, AResource aResource3) {
        return new Triple(StreamingChecker.convert(aResource), StreamingChecker.convert(aResource2), StreamingChecker.convert(aResource3));
    }

    static Triple convert(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        return new Triple(StreamingChecker.convert(aResource), StreamingChecker.convert(aResource2), StreamingChecker.convert(aLiteral));
    }

    private void load(String string, boolean bl) throws SAXException, IOException {
        if (bl) {
            this.imported = new HashSet();
        }
        if (this.imported.contains(string)) {
            return;
        }
        this.imported.add(string);
        String string2 = this.r.redirect(string);
        InputStream inputStream = new URL(string2).openStream();
        this.load(inputStream, string);
    }

    public void load(InputStream inputStream, String string) {
        try {
            ARP aRP = new ARP();
            aRP.setStatementHandler(this.sh);
            aRP.setExtendedHandler(this.eh);
            aRP.load(inputStream, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Exception: " + exception.getMessage());
            System.err.println("Exception handling not yet implemented");
        }
    }

    public void load(Reader reader, String string) {
        try {
            ARP aRP = new ARP();
            aRP.setStatementHandler(this.sh);
            aRP.setExtendedHandler(this.eh);
            aRP.load(reader, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Exception: " + exception.getMessage());
            System.err.println("Exception handling not yet implemented");
        }
    }
}

