/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.VariableValues;

public abstract class BaseExampleExpression
extends Expression.Base
implements Expression {
    public Expression and(Expression expression) {
        return BaseExampleExpression.and(this, expression);
    }

    public Object eval(VariableValues variableValues) {
        return this.evalBool(variableValues) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static BaseExampleExpression and(final Expression expression, final Expression expression2) {
        return new BaseExampleExpression(){

            public String getFun() {
                return "http://jena.hpl.hp.com/query/functions#AND";
            }

            public boolean isApply() {
                return true;
            }

            public Expression getArg(int n) {
                return n == 0 ? expression : expression2;
            }

            public int argCount() {
                return 2;
            }

            public Valuator prepare(VariableIndexes variableIndexes) {
                return BaseExampleValuator.and(expression.prepare(variableIndexes), expression2.prepare(variableIndexes));
            }

            public boolean evalBool(VariableValues variableValues) {
                return expression.evalBool(variableValues) && expression2.evalBool(variableValues);
            }
        };
    }

    public static abstract class BaseExampleValuator
    implements Valuator {
        public abstract boolean evalBool(IndexValues var1);

        public static Valuator and(Valuator valuator, Valuator valuator2) {
            return new Valuator(valuator, valuator2){
                private final /* synthetic */ Valuator val$L;
                private final /* synthetic */ Valuator val$R;
                {
                    this.val$L = valuator;
                    this.val$R = valuator2;
                }

                public boolean evalBool(IndexValues indexValues) {
                    return this.val$L.evalBool(indexValues) && this.val$R.evalBool(indexValues);
                }
            };
        }

        public Object eval(IndexValues indexValues) {
            return this.evalBool(indexValues) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

