/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.FragmentMap;
import com.hp.hpl.jena.graph.impl.Fragments;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;

public class SimpleReifier
implements Reifier {
    private GraphBase parent;
    private boolean intercepting = false;
    private boolean concealing = false;
    private ReificationStyle style;
    private FragmentMap nodeMap;
    private Graph reificationTriples;
    private Filter completeFragment = new Filter(){

        public boolean accept(Object object) {
            return SimpleReifier.this.isComplete((Node)object);
        }
    };

    public SimpleReifier(GraphBase graphBase, ReificationStyle reificationStyle) {
        this.parent = graphBase;
        this.nodeMap = new FragmentMap();
        this.intercepting = reificationStyle.intercepts();
        this.concealing = reificationStyle.conceals();
        this.style = reificationStyle;
    }

    public ReificationStyle getStyle() {
        return this.style;
    }

    public Graph getParentGraph() {
        return this.parent;
    }

    public Triple getTriple(Node node) {
        Object v = this.nodeMap.get(node);
        return v == null ? null : (v instanceof Triple ? (Triple)v : this.getTriple(node, (Fragments)v));
    }

    private Triple getTriple(Node node, Fragments fragments) {
        return fragments.isComplete() ? this.nodeMap.putTriple(node, fragments.asTriple()) : null;
    }

    public boolean hasTriple(Node node) {
        return this.getTriple(node) != null;
    }

    public ExtendedIterator allNodes() {
        return WrappedIterator.create(this.nodeMap.keySet().iterator()).filterKeep(this.completeFragment);
    }

    public ExtendedIterator allNodes(Triple triple) {
        return this.allNodes().filterKeep(this.matching(triple));
    }

    public Filter matching(final Triple triple) {
        return new Filter(){

            public boolean accept(Object object) {
                return triple.equals(SimpleReifier.this.getTriple((Node)object));
            }
        };
    }

    protected boolean isComplete(Node node) {
        Object v = this.nodeMap.get(node);
        return v instanceof Triple || ((Fragments)v).isComplete();
    }

    public Node reifyAs(Node node, Triple triple) {
        Object v = this.nodeMap.get(node);
        if (v instanceof Triple) {
            if (!triple.equals(v)) {
                throw new AlreadyReifiedException(node);
            }
        } else if (v == null) {
            this.nodeMap.putTriple(node, triple);
        } else {
            FragmentMap.graphAddQuad(this.parent, node, triple);
            Triple triple2 = this.getTriple(node);
            if (triple2 == null) {
                throw new CannotReifyException(node);
            }
        }
        if (!this.concealing) {
            FragmentMap.graphAddQuad(this.parent, node, triple);
        }
        return node;
    }

    public void remove(Node node, Triple triple) {
        Object v = this.nodeMap.get(node);
        if (triple.equals(this.nodeMap.get(node))) {
            this.nodeMap.remove(node);
            if (!this.concealing) {
                this.parentRemoveQuad(node, triple);
            }
        }
    }

    public boolean hasTriple(Triple triple) {
        return this.allNodes(triple).hasNext();
    }

    public boolean handledAdd(Triple triple) {
        if (this.intercepting) {
            int n = Fragments.getFragmentSelector(triple);
            if (n < 0) {
                return false;
            }
            Fragments fragments = this.getFragment(triple);
            fragments.add(n, triple.getObject());
            if (fragments.isComplete()) {
                this.nodeMap.putTriple(triple.getSubject(), fragments.asTriple());
            }
            return this.concealing;
        }
        return false;
    }

    public boolean handledRemove(Triple triple) {
        if (this.intercepting) {
            int n = Fragments.getFragmentSelector(triple);
            if (n < 0) {
                return false;
            }
            Fragments fragments = this.getFragment(triple);
            fragments.remove(n, triple.getObject());
            if (fragments.isComplete()) {
                this.nodeMap.putTriple(triple.getSubject(), fragments.asTriple());
            }
            return this.concealing;
        }
        return false;
    }

    private Fragments getFragment(Triple triple) {
        Node node = triple.getSubject();
        Object v = this.nodeMap.get(node);
        return v instanceof Triple ? this.explode(node, (Triple)v) : (v == null ? this.nodeMap.putFragments(node, new Fragments(node)) : (Fragments)v);
    }

    private Fragments explode(Node node, Triple triple) {
        return this.nodeMap.putFragments(node, new Fragments(node, triple));
    }

    public void remove(Triple triple) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        ExtendedIterator extendedIterator = this.allNodes();
        while (extendedIterator.hasNext()) {
            object = (Node)extendedIterator.next();
            if (!triple.equals(this.getTriple((Node)object))) continue;
            hashSet.add(object);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.remove((Node)object.next(), triple);
        }
    }

    public Graph getHiddenTriples() {
        return this.style == ReificationStyle.Standard ? Graph.emptyGraph : this.getReificationTriples();
    }

    public Graph getReificationTriples() {
        if (this.reificationTriples == null) {
            this.reificationTriples = this.nodeMap.asGraph();
        }
        return this.reificationTriples;
    }

    private void parentRemoveQuad(Node node, Triple triple) {
        this.parent.delete(new Triple(node, RDF.Nodes.type, RDF.Nodes.Statement));
        this.parent.delete(new Triple(node, RDF.Nodes.subject, triple.getSubject()));
        this.parent.delete(new Triple(node, RDF.Nodes.predicate, triple.getPredicate()));
        this.parent.delete(new Triple(node, RDF.Nodes.object, triple.getObject()));
    }

    public String toString() {
        return "<R " + this.nodeMap + ">";
    }
}

