/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.JMS;
import java.util.HashMap;
import java.util.Map;

public class SimpleGraphMaker
extends BaseGraphMaker {
    private Map graphs = new HashMap();

    public SimpleGraphMaker(ReificationStyle reificationStyle) {
        super(reificationStyle);
    }

    public SimpleGraphMaker() {
        this(ReificationStyle.Minimal);
    }

    public Node getMakerClass() {
        return JMS.MemMakerSpec.asNode();
    }

    protected void augmentDescription(Graph graph, Node node) {
    }

    public Graph create() {
        return new GraphMem();
    }

    public Graph createGraph(String string, boolean bl) {
        GraphMem graphMem = (GraphMem)this.graphs.get(string);
        if (graphMem == null) {
            GraphMem graphMem2 = new GraphMem(this.style);
            this.graphs.put(string, graphMem2);
            return graphMem2;
        }
        if (bl) {
            throw new AlreadyExistsException(string);
        }
        return graphMem.openAgain();
    }

    public Graph openGraph(String string, boolean bl) {
        GraphMem graphMem = (GraphMem)this.graphs.get(string);
        if (graphMem == null) {
            if (bl) {
                throw new DoesNotExistException(string);
            }
            return this.createGraph(string, true);
        }
        return graphMem.openAgain();
    }

    public void removeGraph(String string) {
        if (!this.graphs.containsKey(string)) {
            throw new DoesNotExistException(string);
        }
        this.graphs.remove(string);
    }

    public boolean hasGraph(String string) {
        return this.graphs.containsKey(string);
    }

    public void close() {
    }

    public ExtendedIterator listGraphs() {
        return WrappedIterator.create(this.graphs.keySet().iterator());
    }
}

