/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileGraph
extends GraphMem {
    protected File name;
    protected Model model;
    protected String lang;

    public FileGraph(File file, boolean bl, boolean bl2) {
        this(file, bl, bl2, ReificationStyle.Minimal);
    }

    public FileGraph(File file, boolean bl, boolean bl2, ReificationStyle reificationStyle) {
        super(reificationStyle);
        this.name = file;
        this.model = new ModelCom(this);
        this.lang = FileGraph.guessLang(this.name.toString());
        if (bl) {
            if (file.exists() && bl2) {
                throw new AlreadyExistsException(file.toString());
            }
        } else {
            this.readModel(this.model, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readModel(Model model, boolean bl) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(this.name);
        this.model.read(fileInputStream, "", this.lang);
        Object var6_4 = null;
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (FileNotFoundException fileNotFoundException) {
                if (bl) {
                    throw new DoesNotExistException(this.name.toString());
                }
                Object var6_5 = null;
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public FileGraph(String string, boolean bl) {
        this(new File(string), bl, true);
    }

    public static FileGraph create() {
        return new FileGraph(FileUtils.tempFileName("xxx", ".rdf"), true, true);
    }

    public static String guessLang(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (string2.equals("n3")) {
            return "N3";
        }
        if (string2.equals("nt")) {
            return "N-TRIPLE";
        }
        return "RDF/XML";
    }

    public static boolean isPlausibleGraphName(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
        return string2.equals("n3") || string2.equals("nt") || string2.equals("rdf");
    }

    public void close() {
        try {
            File file = new File(this.name.getPath() + ".new");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.model.write(fileOutputStream, this.lang);
            fileOutputStream.close();
            this.updateFrom(file);
            super.close();
        }
        catch (IOException iOException) {
            throw new JenaException(iOException);
        }
    }

    private void updateFrom(File file) {
        if (!file.renameTo(this.name)) {
            if (this.name.exists()) {
                this.mustDelete(this.name);
            }
            this.mustRename(file, this.name);
        }
    }

    private void mustDelete(File file) {
        if (!file.delete()) {
            throw new JenaException("could not delete " + file);
        }
    }

    private void mustRename(File file, File file2) {
        if (!file.renameTo(file2)) {
            throw new JenaException("could not rename " + file + " to " + file2);
        }
    }
}

