/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public abstract class AbstractTestQuery1
extends GraphTestBase {
    protected String[] statementList = new String[]{"Pname\tPcard\tO1", "Psex\tPcard\tO1", "Pdept\tPcardmax\tO5", "Pmgr\tPcardmax\tO1", "Ptitle\tPcardmax\tO5", "Pname\tPrange\tOliteral", "Psex\tPrange\tOliteral", "Pdept\tPrange\tOliteral", "Pmgr\tPrange\tOresource", "Ptitle\tPrange\tOliteral", "S1\t\tPname\tOmm", "S1\t\tPsex\tOmale", "S1\t\tPdept\tOjena", "S1\t\tPdept\tOapp", "S1\t\tPmgr\tUS4", "S1\t\tPtitle\tOboss", "S2\t\tPname\tObb", "S2\t\tPsex\tOmale", "S2\t\tPdept\tOgenesis", "S2\t\tPdept\tOapp", "S2\t\tPmgr\tUS4", "S2\t\tPtitle\tOboss", "S3\t\tPname\tOjb", "S3\t\tPsex\tOfemale", "S3\t\tPdept\tOapp", "S3\t\tPmgr\tUS1", "S3\t\tPtitle\tOboss", "S4\t\tPname\tOdick", "S4\t\tPsex\tOmale", "S4\t\tPmgr\tOshane", "S4\t\tPtitle\tObigboss", "S5\t\tPname\tOkers", "S5\t\tPsex\tOmale", "S5\t\tPdept\tOjena", "S5\t\tPdept\tOrdql", "S5\t\tPmgr\tUS1", "S5\t\tPtitle\tOgrunt", "S6\t\tPname\tOjjc", "S6\t\tPsex\tOmale", "S6\t\tPdept\tOjena", "S6\t\tPdept\tOrdf", "S6\t\tPdept\tOowl", "S6\t\tPmgr\tUS1", "S6\t\tPtitle\tOgrunt", "S7\t\tPname\tOder", "S7\t\tPsex\tOmale", "S7\t\tPdept\tOjena", "S7\t\tPdept\tOrdf", "S7\t\tPdept\tOowl", "S7\t\tPmgr\tUS1", "S7\t\tPtitle\tOgrunt", "S7\t\tPtitle\tOboss", "S8\t\tPname\tObmk", "S8\t\tPsex\tOmale", "S8\t\tPdept\tOjena", "S8\t\tPdept\tOrdf", "S8\t\tPmgr\tUS1", "S8\t\tPtitle\tOgrunt", "S8\t\tPtitle\tOboss", "S9\t\tPname\tOas", "S9\t\tPsex\tOmale", "S9\t\tPdept\tOjena", "S9\t\tPdept\tOrdf", "S9\t\tPdept\tOrdql", "S9\t\tPmgr\tUS1", "S9\t\tPtitle\tOgrunt", "S10\t\tPname\tOian", "S10\t\tPsex\tOmale", "S10\t\tPdept\tOjena", "S10\t\tPdept\tOowl", "S10\t\tPmgr\tUS1", "S10\t\tPtitle\tOgrunt", "S11\t\tPname\tOsteveb", "S11\t\tPsex\tOmale", "S11\t\tPdept\tOapp", "S11\t\tPmgr\tUS3", "S11\t\tPtitle\tOgrunt", "S12\t\tPname\tOstevec", "S12\t\tPsex\tOmale", "S12\t\tPdept\tOapp", "S12\t\tPmgr\tUS3", "S12\t\tPtitle\tOgrunt", "S13\t\tPname\tOcs", "S13\t\tPsex\tOmale", "S13\t\tPdept\tOjena", "S13\t\tPdept\tOgenesis", "S13\t\tPmgr\tUS2", "S13\t\tPtitle\tOgrunt", "S14\t\tPname\tOhk", "S14\t\tPsex\tOfemale", "S14\t\tPdept\tOapp", "S14\t\tPdept\tOgenesis", "S14\t\tPmgr\tUS2", "S14\t\tPtitle\tOgrunt", "S15\t\tPname\tOks", "S15\t\tPsex\tOmale", "S15\t\tPdept\tOapp", "S15\t\tPdept\tOgenesis", "S15\t\tPmgr\tUS2", "S16\t\tPname\tOwkw", "S16\t\tPsex\tOmale", "S16\t\tPdept\tOjena", "S16\t\tPdept\tOapp", "S16\t\tPmgr\tUS2", "S16\t\tPtitle\tOgrunt", "N1\t\tS1\t\tPname\tOmm", "N2\t\tS1\t\tPsex\tOmale", "N3\t\tS1\t\tPdept\tOjena", "N4\t\tS1\t\tPdept\tOapp", "N5\t\tS1\t\tPmgr\tUS4", "N6\t\tS1\t\tPtitle\tOboss", "N7\t\tS2\t\tPname\tObb", "N8\t\tS2\t\tPsex\tOmale", "N9\t\tS2\t\tPdept\tOgenesis", "N10\tS2\t\tPdept\tOapp", "N11\tS2\t\tPmgr\tUS4", "N12\tS2\t\tPtitle\tOboss", "N13\tS3\t\tPname\tOjb", "N14\tS3\t\tPsex\tOfemale", "N15\tS3\t\tPdept\tOapp", "N16\tS3\t\tPmgr\tUS1", "N17\tS3\t\tPtitle\tOboss", "N18\tS4\t\tPname\tOdick", "N19\tS4\t\tPsex\tOmale", "N20\tS4\t\tPmgr\tOshane", "N21\tS4\t\tPtitle\tObigboss", "N22\tS5\t\tPname\tOkers", "N23\tS5\t\tPsex\tOmale", "N24\tS5\t\tPdept\tOjena", "N25\tS5\t\tPdept\tOrdql", "N26\tS5\t\tPmgr\tUS1", "N27\tS5\t\tPtitle\tOgrunt"};
    protected final String longPrefix = this.makeLongPrefix();
    static int stmtCnt = 0;
    final Node V1 = AbstractTestQuery1.node("?v1");
    final Node V2 = AbstractTestQuery1.node("?v2");
    final Node V3 = AbstractTestQuery1.node("?v3");
    final Node V4 = AbstractTestQuery1.node("?v4");
    final Node V5 = AbstractTestQuery1.node("?v5");
    final Node Ptitle = this.makeResource("Ptitle");
    final Node Psex = this.makeResource("Psex");
    final Node Pname = this.makeResource("Pname");
    final Node Pmgr = this.makeResource("Pmgr");
    final Node Pcard = this.makeResource("Pcard");
    final Node Pcardmax = this.makeResource("Pcardmax");
    final Node Prange = this.makeResource("Prange");
    final Node Pdept = this.makeResource("Pdept");
    final Node S1 = this.makeResource("S1");
    final Node Ogrunt = this.makeObject("Ogrunt");
    final Node Ofemale = this.makeObject("Ofemale");
    final Node Omale = this.makeObject("Omale");
    final Node Obigboss = this.makeObject("Obigboss");
    final Node Oboss = this.makeObject("Oboss");
    final Node Oshane = this.makeObject("Oshane");
    final Node Oliteral = this.makeObject("Oliteral");
    final Node Oresource = this.makeObject("Oresource");
    final Node Oapp = this.makeObject("Oapp");
    final Node Ogenesis = this.makeObject("Ogenesis");
    final Node O1 = this.makeObject("O1");
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$AbstractTestQuery1;

    public AbstractTestQuery1(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$AbstractTestQuery1 == null ? (class$com$hp$hpl$jena$db$test$AbstractTestQuery1 = AbstractTestQuery1.class$("com.hp.hpl.jena.db.test.AbstractTestQuery1")) : class$com$hp$hpl$jena$db$test$AbstractTestQuery1);
    }

    public abstract Graph getGraph();

    public abstract Graph getGraph(ReificationStyle var1);

    public void setUp() throws Exception {
        super.setUp();
    }

    protected Graph standard() {
        return this.fetchGraph(ReificationStyle.Standard);
    }

    protected Graph convenient() {
        return this.fetchGraph(ReificationStyle.Convenient);
    }

    protected Graph fetchGraph(ReificationStyle reificationStyle) {
        Graph graph = this.getGraph(reificationStyle);
        this.loadGraph(graph);
        return graph;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private String makeLongPrefix() {
        StringBuffer stringBuffer = new StringBuffer(256);
        for (int i = 0; i < 256; ++i) {
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    protected Node makeResource(String string) {
        return Node.createURI(this.expandLong(string));
    }

    protected Node makeObject(String string) {
        boolean bl = string.charAt(0) == 'U';
        return bl ? this.makeResource(string.substring(1)) : Node.createLiteral(new LiteralLabel(this.expandLong(string)));
    }

    protected String expandLong(String string) {
        return string.charAt(0) == 'L' ? this.longPrefix + string.substring(1) : string;
    }

    protected void loadGraph(Graph graph) {
        Reifier reifier = graph.getReifier();
        for (int i = 0; i < this.statementList.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.statementList[i]);
            String string = stringTokenizer.nextToken();
            if (string.charAt(0) == 'N') {
                reifier.reifyAs(this.makeResource(string), this.nextTriple(stringTokenizer.nextToken(), stringTokenizer));
            } else {
                graph.add(this.nextTriple(string, stringTokenizer));
            }
            ++stmtCnt;
        }
    }

    protected Triple nextTriple(String string, StringTokenizer stringTokenizer) {
        Node node = this.makeResource(string);
        Node node2 = this.makeResource(stringTokenizer.nextToken());
        Node node3 = this.makeObject(stringTokenizer.nextToken());
        return Triple.create(node, node2, node3);
    }

    public void test0() {
        Query query = new Query();
        query.addMatch(this.V1, this.Ptitle, this.Ogrunt);
        query.addMatch(this.V1, this.Psex, this.Ofemale);
        query.addMatch(this.V1, this.Pname, this.V3);
        this.checkCount(1, this.standard(), query, new Node[]{this.V1, this.V3});
    }

    public void test1() {
        Query query = new Query();
        query.addMatch(this.V1, this.Ptitle, this.Ogrunt);
        query.addMatch(this.V1, this.Psex, this.Ofemale);
        query.addMatch(this.V1, this.Pmgr, this.V2);
        query.addMatch(this.V2, this.Pname, this.V3);
        this.checkCount(1, this.standard(), query, new Node[]{this.V1, this.V3});
    }

    public void test2() {
        Query query = new Query();
        query.addMatch(this.V1, this.Ptitle, this.Ogrunt);
        query.addMatch(this.V1, this.Psex, this.Ofemale);
        query.addMatch(this.V1, this.Pmgr, this.V2);
        query.addMatch(this.V2, this.Psex, this.Ofemale);
        query.addMatch(this.V1, this.Pname, this.V3);
        this.checkCount(0, this.standard(), query, new Node[]{this.V1, this.V3});
    }

    public void test3a() {
        Query query = new Query();
        query.addMatch(this.V1, this.Ptitle, this.Obigboss);
        query.addMatch(this.V1, this.Pmgr, this.Oshane);
        query.addMatch(this.V1, this.V2, this.V3);
        this.checkCount(4, this.standard(), query, new Node[]{this.V1, this.V2, this.V3});
    }

    public void test3b() {
        Query query = new Query();
        query.addMatch(this.V1, this.Ptitle, this.Ogrunt);
        query.addMatch(this.V1, this.Psex, this.Ofemale);
        query.addMatch(this.V1, this.Pmgr, this.V2);
        query.addMatch(this.V2, this.Psex, this.Omale);
        query.addMatch(this.V1, this.V3, this.V4);
        this.checkCount(6, this.standard(), query, new Node[]{this.V1, this.V3, this.V4});
    }

    public void test4() {
        Query query = new Query();
        query.addMatch(this.V1, this.Ptitle, this.Obigboss);
        query.addMatch(this.V1, this.Pmgr, this.Oshane);
        query.addMatch(this.V2, this.Pcard, this.O1);
        query.addMatch(this.V2, this.Prange, this.Oliteral);
        query.addMatch(this.V1, this.V2, this.V3);
        this.checkCount(2, this.standard(), query, new Node[]{this.V2, this.V3});
    }

    public void test5() {
        Query query = new Query();
        query.addMatch(this.V1, this.Pcardmax, this.O1);
        query.addMatch(this.V1, this.Prange, this.Oresource);
        query.addMatch(this.S1, this.V1, this.V2);
        query.addMatch(this.V2, this.Pname, this.V3);
        query.addMatch(this.V2, this.Psex, this.V4);
        this.checkCount(1, this.standard(), query, new Node[]{this.V2, this.V3, this.V4});
    }

    public void test6() {
        Query query = new Query();
        query.addMatch(this.V1, RDF.Nodes.subject, this.V2);
        query.addMatch(this.V1, RDF.Nodes.predicate, this.V3);
        query.addMatch(this.V1, RDF.Nodes.object, this.V4);
        this.checkCount(27, this.standard(), query, new Node[]{this.V2, this.V3, this.V4});
        this.checkCount(0, this.convenient(), query, new Node[]{this.V2, this.V3, this.V4});
    }

    public void test7() {
        Query query = new Query();
        query.addMatch(this.V1, RDF.Nodes.subject, this.V2);
        query.addMatch(this.V1, RDF.Nodes.predicate, this.Ptitle);
        query.addMatch(this.V1, RDF.Nodes.object, this.Obigboss);
        query.addMatch(this.V3, RDF.Nodes.subject, this.V2);
        query.addMatch(this.V3, RDF.Nodes.predicate, this.V4);
        this.checkCount(4, this.standard(), query, new Node[]{this.V2, this.V3});
    }

    public void test8() {
        Query query = new Query();
        query.addMatch(this.V1, RDF.Nodes.subject, this.V2);
        query.addMatch(this.V1, RDF.Nodes.predicate, this.Ptitle);
        query.addMatch(this.V1, RDF.Nodes.object, this.Obigboss);
        query.addMatch(this.V3, RDF.Nodes.subject, this.V2);
        query.addMatch(this.V3, this.V4, this.V5);
        this.checkCount(16, this.standard(), query, new Node[]{this.V3});
    }

    private void checkCount(int n, Graph graph, Query query, Node[] nodeArray) {
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query, nodeArray);
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals((String)"number of reified statements", (int)n, (int)this.queryResultCount(extendedIterator));
        extendedIterator.close();
    }

    protected int queryResultCount(ExtendedIterator extendedIterator) {
        int n = 0;
        while (extendedIterator.hasNext()) {
            ++n;
            ((List)extendedIterator.next()).size();
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

