/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.shared.JenaException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLCache {
    protected Properties m_sql;
    protected HashMap m_preparedStatements = new HashMap();
    protected IDBConnection m_connection;
    protected static final int MAX_PS_CACHE = 4;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$db$impl$SQLCache == null ? (class$com$hp$hpl$jena$db$impl$SQLCache = SQLCache.class$("com.hp.hpl.jena.db.impl.SQLCache")) : class$com$hp$hpl$jena$db$impl$SQLCache));
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$SQLCache;

    public SQLCache(String string, Properties properties, IDBConnection iDBConnection, String string2) throws IOException {
        this.m_sql = SQLCache.loadSQLFile(string, properties, string2);
        this.m_connection = iDBConnection;
    }

    public void setCachePreparedStatements(boolean bl) {
        this.CACHE_PREPARED_STATEMENTS = bl;
    }

    public boolean getCachePreparedStatements() {
        return this.CACHE_PREPARED_STATEMENTS;
    }

    public void flushPreparedStatementCache() throws RDFRDBException {
        try {
            Iterator iterator = this.m_preparedStatements.values().iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    ((PreparedStatement)iterator2.next()).close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Problem flushing PS cache", sQLException);
        }
        finally {
            this.m_preparedStatements = new HashMap();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection.getConnection();
    }

    public void setConnection(IDBConnection iDBConnection) {
        this.m_connection = iDBConnection;
    }

    public String getSQLStatement(String string) throws SQLException {
        return this.getSQLStatement(string, (String[])null);
    }

    public String getSQLStatement(String string, String[] stringArray) throws SQLException {
        int n;
        String string2 = this.m_sql.getProperty(string);
        if (string2 == null) {
            if (string.startsWith("*")) {
                string2 = this.genSQLStatement(string);
                this.m_sql.setProperty(string, string2);
            } else {
                logger.error((Object)("Unable to find SQL for operation: " + string));
                throw new SQLException("Unable to find SQL for operation: " + string);
            }
        }
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n > 0) {
            string2 = SQLCache.substitute(string2, "${a}", stringArray[0]);
        }
        if (n > 1) {
            string2 = SQLCache.substitute(string2, "${b}", stringArray[1]);
        }
        if (n > 2) {
            string2 = SQLCache.substitute(string2, "${c}", stringArray[2]);
        }
        if (n > 3) {
            throw new JenaException("Too many arguments");
        }
        return string2;
    }

    public String getSQLStatement(String string, String string2) throws SQLException {
        String[] stringArray = new String[]{string2};
        return this.getSQLStatement(string, stringArray);
    }

    public String getSQLStatement(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{string2, string3};
        return this.getSQLStatement(string, stringArray);
    }

    public Collection getSQLStatementGroup(String string) throws SQLException {
        String string2 = this.m_sql.getProperty(string);
        if (string2 == null) {
            throw new SQLException("Unable to find SQL for operation: " + string);
        }
        int n = 0;
        int n2 = 0;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (n2 != -1) {
            n2 = string2.indexOf(";;\n", n);
            String string3 = null;
            if (n2 == -1) {
                string3 = string2.substring(n);
            } else {
                string3 = string2.substring(n, n2);
                n = n2 + 2;
            }
            if (string3.trim().equals("")) continue;
            linkedList.add(string3);
        }
        return linkedList;
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String string, String[] stringArray) throws SQLException {
        if (this.m_connection == null || string == null) {
            return null;
        }
        int n = stringArray == null ? 0 : stringArray.length;
        String string2 = string;
        if (n > 0) {
            string2 = SQLCache.concatOpName(string2, stringArray[0]);
        }
        if (n > 1) {
            string2 = SQLCache.concatOpName(string2, stringArray[1]);
        }
        if (n > 2) {
            string2 = SQLCache.concatOpName(string2, stringArray[2]);
        }
        if (n > 3) {
            throw new JenaException("Too many arguments");
        }
        List list = (List)this.m_preparedStatements.get(string2);
        if (list == null || list.isEmpty()) {
            String string3 = this.getSQLStatement(string, stringArray);
            if (string3 == null) {
                throw new SQLException("No SQL defined for operation: " + string);
            }
            if (list == null && this.CACHE_PREPARED_STATEMENTS) {
                this.m_preparedStatements.put(string2, new LinkedList());
            }
            return this.doPrepareSQLStatement(string3);
        }
        return (PreparedStatement)list.remove(0);
    }

    private synchronized PreparedStatement doPrepareSQLStatement(String string) throws SQLException {
        if (this.m_connection == null) {
            return null;
        }
        return this.getConnection().prepareStatement(string);
    }

    public synchronized PreparedStatement prepareSQLStatement(String string) throws SQLException {
        if (this.m_connection == null) {
            return null;
        }
        return this.doPrepareSQLStatement(string);
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String string) throws SQLException {
        return this.getPreparedSQLStatement(string, (String[])null);
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String string, String string2) throws SQLException {
        String[] stringArray = new String[]{string2};
        return this.getPreparedSQLStatement(string, stringArray);
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{string2, string3};
        return this.getPreparedSQLStatement(string, stringArray);
    }

    public synchronized void returnPreparedSQLStatement(PreparedStatement preparedStatement, String string) {
        if (!this.CACHE_PREPARED_STATEMENTS) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                logger.warn((Object)"Problem discarded prepared statement", (Throwable)sQLException);
            }
            return;
        }
        LinkedList<PreparedStatement> linkedList = (LinkedList<PreparedStatement>)this.m_preparedStatements.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<PreparedStatement>();
            this.m_preparedStatements.put(string, linkedList);
        }
        if (linkedList.size() >= 4) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                logger.warn((Object)"Problem discarded prepared statement", (Throwable)sQLException);
            }
        } else {
            linkedList.add(preparedStatement);
        }
    }

    public ResultSetIterator runSQLQuery(String string, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
        }
        return this.executeSQL(preparedStatement, string, new ResultSetIterator());
    }

    public ResultSetIterator runSQLQuery(String string, String string2, Object[] objectArray) throws SQLException {
        String string3 = SQLCache.concatOpName(string, string2);
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string3);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
        }
        return this.executeSQL(preparedStatement, string3, new ResultSetIterator());
    }

    public ResultSetIterator runSQLQuery(String string, String string2, String string3, Object[] objectArray) throws SQLException {
        String string4 = SQLCache.concatOpName(string, string2, string3);
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string4);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
        }
        return this.executeSQL(preparedStatement, string4, new ResultSetIterator());
    }

    public int runSQLUpdate(String string, Object[] objectArray) throws SQLException {
        int n;
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string);
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                preparedStatement.setObject(n + 1, objectArray[n]);
            }
        }
        n = preparedStatement.executeUpdate();
        this.returnPreparedSQLStatement(preparedStatement, string);
        return n;
    }

    public int runSQLUpdate(String string, String string2, Object[] objectArray) throws SQLException {
        int n;
        String string3 = SQLCache.concatOpName(string, string2);
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string3);
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                preparedStatement.setObject(n + 1, objectArray[n]);
            }
        }
        n = preparedStatement.executeUpdate();
        this.returnPreparedSQLStatement(preparedStatement, string3);
        return n;
    }

    public int runSQLUpdate(String string, String string2, String string3, Object[] objectArray) throws SQLException {
        int n;
        String string4 = SQLCache.concatOpName(string, string2, string3);
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string4);
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                preparedStatement.setObject(n + 1, objectArray[n]);
            }
        }
        n = preparedStatement.executeUpdate();
        this.returnPreparedSQLStatement(preparedStatement, string4);
        return n;
    }

    public ResultSetIterator runSQLQuery(String string, Object[] objectArray, ResultSetIterator resultSetIterator) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
        }
        return this.executeSQL(preparedStatement, string, resultSetIterator);
    }

    public ResultSetIterator runSQLQuery(String string, String string2, Object[] objectArray, ResultSetIterator resultSetIterator) throws SQLException {
        String string3 = SQLCache.concatOpName(string, string2);
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string3);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
        }
        return this.executeSQL(preparedStatement, string3, resultSetIterator);
    }

    public ResultSetIterator runSQLQuery(String string, String string2, String string3, Object[] objectArray, ResultSetIterator resultSetIterator) throws SQLException {
        String string4 = SQLCache.concatOpName(string, string2, string3);
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string4);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
        }
        return this.executeSQL(preparedStatement, string4, resultSetIterator);
    }

    public void runSQLGroup(String string, String[] stringArray) throws SQLException {
        int n;
        String string2 = null;
        SQLException sQLException = null;
        String string3 = null;
        Statement statement = this.getConnection().createStatement();
        Iterator iterator = this.getSQLStatementGroup(string).iterator();
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n > 6) {
            throw new RDFRDBException("Too many parameters");
        }
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (n > 0) {
                string2 = SQLCache.substitute(string2, "${a}", stringArray[0]);
            }
            if (n > 1) {
                string2 = SQLCache.substitute(string2, "${b}", stringArray[1]);
            }
            if (n > 2) {
                string2 = SQLCache.substitute(string2, "${c}", stringArray[2]);
            }
            if (n > 3) {
                string2 = SQLCache.substitute(string2, "${d}", stringArray[3]);
            }
            if (n > 4) {
                string2 = SQLCache.substitute(string2, "${e}", stringArray[4]);
            }
            if (n > 5) {
                string2 = SQLCache.substitute(string2, "${f}", stringArray[5]);
            }
            try {
                statement.execute(string2);
            }
            catch (SQLException sQLException2) {
                string3 = string2;
                sQLException = sQLException2;
            }
        }
        statement.close();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public void runSQLGroup(String string) throws SQLException {
        this.runSQLGroup(string, (String[])null);
    }

    public void runSQLGroup(String string, String string2) throws SQLException {
        String[] stringArray = new String[]{string2};
        this.runSQLGroup(string, stringArray);
    }

    public void runSQLGroup(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{string2, string3};
        this.runSQLGroup(string, stringArray);
    }

    public void close() throws SQLException {
        Iterator iterator = this.m_preparedStatements.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                PreparedStatement preparedStatement = (PreparedStatement)iterator2.next();
                preparedStatement.close();
            }
            iterator.remove();
        }
    }

    public static Properties loadSQLFile(String string, Properties properties, String string2) throws IOException {
        Properties properties2 = new Properties(properties);
        BufferedReader bufferedReader = SQLCache.openResourceFile(string);
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.startsWith("#")) continue;
            String string4 = string3.trim();
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                if ((string3 = bufferedReader.readLine()) == null || string3.trim().equals("")) break;
                if (string3.startsWith("#")) continue;
                stringBuffer.append(SQLCache.substitute(string3.trim(), "${id}", string2));
                stringBuffer.append("\n");
            }
            properties2.setProperty(string4, stringBuffer.toString());
            if (string3 != null) continue;
            break;
        }
        return properties2;
    }

    public static String concatOpName(String string, String string2) {
        return string + string2;
    }

    public static String concatOpName(String string, String string2, String string3) {
        return string + string2 + string3;
    }

    public static String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(0, n) + string3 + SQLCache.substitute(string.substring(n + string2.length()), string2, string3);
        }
        return string;
    }

    protected Properties getSQLTable() {
        return this.m_sql;
    }

    public static BufferedReader openResourceFile(String string) throws IOException {
        InputStream inputStream = (class$com$hp$hpl$jena$db$impl$SQLCache == null ? (class$com$hp$hpl$jena$db$impl$SQLCache = SQLCache.class$("com.hp.hpl.jena.db.impl.SQLCache")) : class$com$hp$hpl$jena$db$impl$SQLCache).getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Can't open resource " + string);
        }
        return new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
    }

    protected ResultSetIterator executeSQL(PreparedStatement preparedStatement, String string, ResultSetIterator resultSetIterator) throws SQLException {
        if (preparedStatement.execute()) {
            ResultSet resultSet = preparedStatement.getResultSet();
            resultSetIterator.reset(resultSet, preparedStatement, this, string);
            return resultSetIterator;
        }
        this.returnPreparedSQLStatement(preparedStatement, string);
        return null;
    }

    protected String genSQLStatement(String string) throws SQLException {
        String string2 = "";
        boolean bl = false;
        if (string.startsWith("*")) {
            int n = string.indexOf(32);
            String string3 = string.substring(1, n);
            String string4 = string.substring(n + 1);
            if (string3.equals("findReif")) {
                string2 = this.genSQLStmtFindReif(string3, string4);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            logger.error((Object)("Unable to generate SQL for operation: " + string));
            throw new JenaException("Unable to generate SQL for operation: " + string);
        }
        return string2;
    }

    protected String genSQLStmtFindReif(String string, String string2) throws SQLException {
        String string3 = this.getSQLStatement("selectReified");
        String string4 = "";
        IRDBDriver iRDBDriver = this.m_connection.getDriver();
        if (!string2.equals("")) {
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            char c = ' ';
            int n2 = string2.length();
            if (string2.charAt(n) == 'N') {
                bl = true;
                ++n;
            }
            boolean bl5 = bl2 = n < n2 && string2.charAt(n) == 'P';
            if (bl2 && n < n2) {
                int n4 = ++n;
                ++n;
                c = string2.charAt(n4);
            }
            boolean bl6 = bl3 = n < n2 && string2.charAt(n) == 'O';
            if (bl3) {
                boolean bl7 = bl4 = ++n < n2 && string2.charAt(n) == 'C';
            }
            if (!bl2) {
                if (bl) {
                    string4 = string4 + iRDBDriver.genSQLReifQualStmt();
                    if (bl3) {
                        string4 = string4 + " AND " + iRDBDriver.genSQLReifQualAnyObj(bl4);
                    }
                } else {
                    string4 = string4 + iRDBDriver.genSQLReifQualAnyObj(bl4);
                }
            } else {
                if (bl) {
                    string4 = string4 + iRDBDriver.genSQLReifQualStmt() + " AND ";
                }
                string4 = string4 + iRDBDriver.genSQLReifQualObj(c, bl3);
            }
            string3 = string3 + " AND " + string4;
        }
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

