/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.impl.DBReifierGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.List;

public class DBReifier
implements Reifier {
    protected GraphRDB m_parent = null;
    protected Graph m_hiddenTriples = null;
    protected List m_reifiers = null;
    protected List m_hidden_reifiers = null;
    protected SpecializedGraphReifier m_reifier = null;
    protected ReificationStyle m_style;

    public DBReifier(GraphRDB graphRDB, ReificationStyle reificationStyle, List list, List list2) {
        this.m_parent = graphRDB;
        this.m_reifiers = list;
        this.m_hidden_reifiers = list2;
        this.m_style = reificationStyle;
        if (this.m_reifiers.size() != 1) {
            throw new BrokenException("Internal error - DBReifier requires exactly one SpecializedGraphReifier");
        }
        this.m_reifier = (SpecializedGraphReifier)this.m_reifiers.get(0);
    }

    public Graph getParentGraph() {
        return this.m_parent;
    }

    public ReificationStyle getStyle() {
        return this.m_style;
    }

    public Graph getReificationTriples() {
        if (this.m_hiddenTriples == null) {
            this.m_hiddenTriples = new DBReifierGraph(this.m_parent, this.m_hidden_reifiers);
        }
        return this.m_hiddenTriples;
    }

    public Graph getHiddenTriples() {
        return this.m_style == ReificationStyle.Standard ? Graph.emptyGraph : this.getReificationTriples();
    }

    protected static SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    public Node reifyAs(Node node, Triple triple) {
        this.m_reifier.add(node, triple, DBReifier.newComplete());
        return node;
    }

    public boolean hasTriple(Node node) {
        return this.m_reifier.findReifiedTriple(node, DBReifier.newComplete()) != null;
    }

    public boolean hasTriple(Triple triple) {
        return this.m_reifier.findReifiedNodes(triple, DBReifier.newComplete()).hasNext();
    }

    public ExtendedIterator allNodes() {
        return this.m_reifier.findReifiedNodes(null, DBReifier.newComplete());
    }

    public ExtendedIterator allNodes(Triple triple) {
        return this.m_reifier.findReifiedNodes(triple, DBReifier.newComplete());
    }

    public void remove(Node node, Triple triple) {
        this.m_reifier.delete(node, triple, DBReifier.newComplete());
    }

    public void remove(Triple triple) {
        this.m_reifier.delete(null, triple, DBReifier.newComplete());
    }

    public boolean handledAdd(Triple triple) {
        SpecializedGraph.CompletionFlag completionFlag = DBReifier.newComplete();
        this.m_reifier.add(triple, completionFlag);
        return completionFlag.isDone();
    }

    public boolean handledRemove(Triple triple) {
        SpecializedGraph.CompletionFlag completionFlag = DBReifier.newComplete();
        this.m_reifier.delete(triple, completionFlag);
        return completionFlag.isDone();
    }

    public Triple getTriple(Node node) {
        return this.m_reifier.findReifiedTriple(node, DBReifier.newComplete());
    }
}

