/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.shared.impl.JenaParameters;

public class XSDDouble
extends XSDDatatype {
    public XSDDouble(String string) {
        super(string);
    }

    public XSDDouble(String string, Class clazz) {
        super(string, clazz);
    }

    public boolean isValidLiteral(LiteralLabel literalLabel) {
        return this.equals(literalLabel.getDatatype());
    }

    public boolean isValidValue(Object object) {
        return object instanceof Float;
    }

    public Object parse(String string) throws DatatypeFormatException {
        this.checkWhitespace(string);
        return super.parse(string);
    }

    public Object parseValidated(String string) {
        if (string.equals("INF")) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (string.equals("-INF")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (string.equals("NaN")) {
            return new Double(Double.NaN);
        }
        return Double.valueOf(string);
    }

    protected void checkWhitespace(String string) {
        if (JenaParameters.enableWhitespaceCheckingOfTypedLiterals && !string.trim().equals(string)) {
            throw new DatatypeFormatException(string, this, "whitespace violation");
        }
    }

    public boolean isEqual(LiteralLabel literalLabel, LiteralLabel literalLabel2) {
        return literalLabel.getDatatype() == literalLabel2.getDatatype() && literalLabel.getValue().equals(literalLabel2.getValue());
    }
}

