/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.basic.BasicExpressionFactory;
import org.apache.slide.search.basic.ComparableResourcesPool;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.store.impl.rdbms.AbstractRDBMSStore;
import org.apache.slide.store.impl.rdbms.RDBMSComparableResourcesPool;
import org.apache.slide.store.impl.rdbms.expression.RDBMSCompareExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSIsCollectionExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSIsDefinedExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSIsPrincipalExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSMergeExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSNOPExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSNotIsCollectionExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSNotIsDefinedExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSNotIsPrincipalExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSNotPropContainsExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSPropContainsExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSQueryContext;
import org.apache.slide.store.impl.rdbms.expression.RDBMSResultSet;
import org.jdom.Element;

public class RDBMSExpressionFactory
extends BasicExpressionFactory {
    private final AbstractRDBMSStore _store;
    private final RDBMSQueryContext _context;

    public RDBMSExpressionFactory(AbstractRDBMSStore store) {
        this._store = store;
        this._context = new RDBMSQueryContext(new RDBMSResultSet(this));
    }

    public void init(IBasicQuery query, PropertyProvider propertyProvider) throws BadQueryException {
        super.init(query, propertyProvider);
    }

    public IBasicExpression createMergeExpression(String name, String namespace, Collection members) throws BadQueryException {
        RDBMSExpression result = null;
        if (name == null) {
            result = new RDBMSNOPExpression(this._context);
        } else {
            ArrayList<IBasicExpression> otherExpressions = null;
            ArrayList<IBasicExpression> rdbmsExpressions = null;
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                IBasicExpression expression = (IBasicExpression)iter.next();
                if (expression instanceof RDBMSExpression) {
                    if (rdbmsExpressions == null) {
                        rdbmsExpressions = new ArrayList<IBasicExpression>(members.size());
                    }
                    rdbmsExpressions.add(expression);
                    continue;
                }
                if (otherExpressions == null) {
                    otherExpressions = new ArrayList<IBasicExpression>(members.size());
                }
                otherExpressions.add(expression);
            }
            result = new RDBMSMergeExpression(name, namespace, this._context, rdbmsExpressions, otherExpressions);
        }
        result.setFactory((IBasicExpressionFactory)this);
        return result;
    }

    IBasicExpression createStandardMergeExpression(String name, String namespace, Collection members) throws BadQueryException {
        return super.createMergeExpression(name, namespace, members);
    }

    public IBasicExpression createExpression(Element element) throws BadQueryException {
        RDBMSNOPExpression result = null;
        if (element == null) {
            result = new RDBMSNOPExpression(this._context);
        } else {
            String namespace = element.getNamespace().getURI();
            String name = element.getName();
            if (namespace.equals("DAV:")) {
                result = this.createDAVExpression(element);
            } else if (namespace.equals("http://jakarta.apache.org/slide/")) {
                result = this.createSlideExpression(element);
            } else {
                throw new InvalidQueryException("operator <" + namespace + ":" + name + "> is an unprocessable entity");
            }
        }
        result.setFactory((IBasicExpressionFactory)this);
        return result;
    }

    protected IBasicExpression createDAVExpression(Element element) throws BadQueryException {
        if (this.isSQLCompilableProperty(element)) {
            if (RDBMSCompareExpression.COMPARE_OPERATORS.containsKey(element.getName())) {
                return new RDBMSCompareExpression(element, this._context);
            }
            if (element.getName().equals("is-defined")) {
                return new RDBMSIsDefinedExpression(element, this._context);
            }
            if (element.getName().equals("not-is-defined")) {
                return new RDBMSNotIsDefinedExpression(element, this._context);
            }
        } else {
            if (element.getName().equals("is-collection")) {
                return new RDBMSIsCollectionExpression(element, this._context);
            }
            if (element.getName().equals("not-is-collection")) {
                return new RDBMSNotIsCollectionExpression(element, this._context);
            }
        }
        return super.createExpression(element);
    }

    protected IBasicExpression createSlideExpression(Element element) throws BadQueryException {
        if (this.isSQLCompilableProperty(element)) {
            if (element.getName().equals("propcontains")) {
                return new RDBMSPropContainsExpression(element, this._context);
            }
            if (element.getName().equals("not-propcontains")) {
                return new RDBMSNotPropContainsExpression(element, this._context);
            }
        }
        if (element.getName().equals("is-principal")) {
            return new RDBMSIsPrincipalExpression(element, this._context);
        }
        if (element.getName().equals("not-is-principal")) {
            return new RDBMSNotIsPrincipalExpression(element, this._context);
        }
        return super.createExpression(element);
    }

    protected ComparableResourcesPool getRequestedResourcePool() {
        if (this.requestedResourcePool == null) {
            this.requestedResourcePool = new RDBMSComparableResourcesPool(this._store, this._context, this.getQuery());
        }
        return this.requestedResourcePool;
    }

    public boolean isSQLCompilableProperty(Element element) {
        Element davProp = element.getChild("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        if (davProp != null) {
            Element property = (Element)davProp.getChildren().get(0);
            return this.isSQLCompilableProperty(property.getNamespaceURI(), property.getName());
        }
        return false;
    }

    public boolean isSQLCompilableProperty(String namespace, String name) {
        if (this.getPropertyProvider() == null) {
            return false;
        }
        try {
            String uri = this.getQuery().getSearchToken().getSlideContext().getSlidePath(this.getQuery().getScope().getHref());
            return !this.getPropertyProvider().isSupportedProperty(uri, name, namespace);
        }
        catch (SlideException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String propertyToAlias(String propertyName) {
        StringBuffer buffer = new StringBuffer(propertyName.length() + 5);
        buffer.append("prop_");
        int l = propertyName.length();
        for (int i = 0; i < l; ++i) {
            char c = propertyName.charAt(i);
            if (c == '-') {
                c = '_';
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

