/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.RequestedPropertyImpl;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideRuntimeException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.basic.ComparableResourceImpl;
import org.apache.slide.search.basic.ComparableResourcesPool;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.store.impl.rdbms.AbstractRDBMSStore;
import org.apache.slide.store.impl.rdbms.expression.RDBMSExpressionFactory;
import org.apache.slide.store.impl.rdbms.expression.RDBMSQueryContext;
import org.apache.slide.structure.ObjectNode;

public class RDBMSComparableResourcesPool
implements ComparableResourcesPool {
    private final AbstractRDBMSStore _store;
    private final RDBMSQueryContext _context;
    private final IBasicQuery _query;
    private final SearchToken _token;
    private final QueryScope _scope;
    private final Map _selectProperties;
    private final PropertyProvider _provider;
    private Set _pool;
    static /* synthetic */ Class class$java$lang$String;

    public RDBMSComparableResourcesPool(AbstractRDBMSStore store, RDBMSQueryContext context, IBasicQuery query) {
        RequestedProperties props;
        this._store = store;
        this._context = context;
        this._query = query;
        this._token = this._query.getSearchToken();
        this._scope = this._query.getScope();
        this._selectProperties = new HashMap();
        this._provider = new RDBMSPropertyProvider(this._query.getPropertyProvider(), this._selectProperties);
        if (this._query instanceof SearchQuery && !(props = ((SearchQuery)this._query).requestedProperties()).isAllProp()) {
            Iterator iter = props.getRequestedProperties();
            while (iter.hasNext()) {
                RequestedProperty property = (RequestedProperty)iter.next();
                String selectKey = property.getNamespace() + property.getName();
                if (!this._context.selects().containsKey(selectKey)) continue;
                this._selectProperties.put(property, new HashMap());
            }
        }
    }

    public Iterator resourceIterator() {
        try {
            return this.getPool().iterator();
        }
        catch (BadQueryException e) {
            throw new SlideRuntimeException(e.toString());
        }
    }

    public Set getPool() throws BadQueryException {
        if (this._pool == null) {
            try {
                ObjectNode[] objects = this.retrieveObjects();
                this._pool = new HashSet(objects.length);
                for (int i = 0; i < objects.length; ++i) {
                    try {
                        this._pool.add(new ComparableResourceImpl(objects[i], this._token, this._scope, this._provider));
                        continue;
                    }
                    catch (AccessDeniedException accessDeniedException) {
                        // empty catch block
                    }
                }
            }
            catch (ServiceAccessException e) {
                throw new BadQueryException((Throwable)e);
            }
            catch (SlideException e) {
                throw new BadQueryException((Throwable)e);
            }
        }
        return this._pool;
    }

    public boolean partialResult() {
        return false;
    }

    public QueryScope getScope() {
        return this._scope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectNode[] retrieveObjects() throws ServiceAccessException, BadQueryException {
        ObjectNode[] objectNodeArray;
        if (this._store.getCurrentlyActiveTransactionalResource() != null) return this.retrieveObjects(this._store.getCurrentConnection());
        Connection connection = null;
        try {
            try {
                connection = this._store.getNewConnection();
                objectNodeArray = this.retrieveObjects(connection);
                Object var4_4 = null;
                if (connection == null) return objectNodeArray;
            }
            catch (SQLException e) {
                throw new ServiceAccessException((Service)this._store, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                this._store.getLogger().log((Object)e2, AbstractRDBMSStore.LOG_CHANNEL, 4);
            }
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            this._store.getLogger().log((Object)e2, AbstractRDBMSStore.LOG_CHANNEL, 4);
            return objectNodeArray;
        }
        connection.close();
        return objectNodeArray;
    }

    /*
     * Loose catch block
     */
    private ObjectNode[] retrieveObjects(Connection connection) throws ServiceAccessException, BadQueryException {
        ArrayList<String> uris;
        ArrayList<String> classNames;
        block20: {
            SQLException e22;
            ResultSet result;
            Statement statement;
            block19: {
                statement = null;
                result = null;
                classNames = new ArrayList<String>();
                uris = new ArrayList<String>();
                String sql = this.compileSQL();
                if (this._store.getLogger().isEnabled(6)) {
                    this._store.getLogger().log((Object)("executing: " + sql), AbstractRDBMSStore.LOG_CHANNEL, 6);
                }
                statement = connection.prepareStatement(sql);
                result = statement.executeQuery();
                while (result.next()) {
                    String uri = result.getString(1);
                    String className = result.getString(2);
                    uris.add(uri);
                    classNames.add(className);
                    Iterator iter = this._selectProperties.keySet().iterator();
                    while (iter.hasNext()) {
                        RequestedProperty requested = (RequestedProperty)iter.next();
                        String name = requested.getName();
                        String namespace = requested.getNamespace();
                        String alias = RDBMSExpressionFactory.propertyToAlias(requested.getName());
                        String value = result.getString(alias);
                        NodeProperty property = new NodeProperty(name, (Object)value, namespace);
                        Map properties = (Map)this._selectProperties.get(requested);
                        properties.put(uri, property);
                    }
                }
                Object var18_21 = null;
                if (result == null) break block19;
                try {
                    result.close();
                }
                catch (SQLException e22) {
                    this._store.getLogger().log((Object)e22, AbstractRDBMSStore.LOG_CHANNEL, 4);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e22) {
                    this._store.getLogger().log((Object)e22, AbstractRDBMSStore.LOG_CHANNEL, 4);
                }
            }
            break block20;
            {
                catch (SQLException e3) {
                    throw new ServiceAccessException((Service)this._store, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var18_22 = null;
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException e22) {
                        this._store.getLogger().log((Object)e22, AbstractRDBMSStore.LOG_CHANNEL, 4);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e22) {
                        this._store.getLogger().log((Object)e22, AbstractRDBMSStore.LOG_CHANNEL, 4);
                    }
                }
                throw throwable;
            }
        }
        int size = uris.size();
        ObjectNode[] objects = new ObjectNode[size];
        for (int i = 0; i < size; ++i) {
            try {
                Class<?> objclass = Class.forName((String)classNames.get(i));
                Class[] argClasses = new Class[]{class$java$lang$String == null ? RDBMSComparableResourcesPool.class$("java.lang.String") : class$java$lang$String};
                Object[] arguments = new Object[]{uris.get(i)};
                Constructor<?> constructor = objclass.getConstructor(argClasses);
                objects[i] = (ObjectNode)constructor.newInstance(arguments);
                objects[i].setUri(objects[i].getUuri());
                continue;
            }
            catch (Exception e) {
                throw new ServiceAccessException((Service)this._store, (Throwable)e);
            }
        }
        return objects;
    }

    private String compileSQL() throws BadQueryException {
        String uri = this._token.getSlideContext().getSlidePath(this._scope.getHref());
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        String query = "select " + this.compileSelect() + " from " + this.compileJoins() + " where " + this.compileScope(uri);
        String criteria = this.compileCriteria();
        query = criteria != null && criteria.length() > 0 ? query + " AND " + criteria : query;
        return query;
    }

    private String compileSelect() {
        String select = "u.URI_STRING, o.CLASS_NAME";
        Iterator iter = this._selectProperties.keySet().iterator();
        while (iter.hasNext()) {
            RequestedProperty property = (RequestedProperty)iter.next();
            String selectKey = property.getNamespace() + property.getName();
            String propSelect = (String)this._context.selects().get(selectKey);
            if (propSelect == null) continue;
            select = select + ", " + propSelect;
        }
        return select;
    }

    private String compileScope(String uri) {
        switch (this._scope.getDepth()) {
            case 0: {
                return " u.URI_STRING = '" + uri + "'";
            }
            case 1: {
                return " (u.URI_STRING = '" + uri + "'" + " OR (u.URI_STRING LIKE '" + uri + "/%'" + " AND u.URI_STRING NOT LIKE '" + uri + "/%/%'))";
            }
        }
        return " (u.URI_STRING = '" + uri + "'" + " OR u.URI_STRING LIKE '" + uri + "/%')";
    }

    private String compileCriteria() {
        String result = null;
        if (this._context.criteria().size() > 0) {
            result = "";
            Iterator iter = this._context.criteria().iterator();
            while (iter.hasNext()) {
                result = result + iter.next();
            }
        }
        return result;
    }

    private String compileJoins() {
        String joins = "((OBJECT o inner join URI u on u.URI_ID = o.URI_ID) inner join VERSION_HISTORY vh on vh.URI_ID = u.URI_ID) ";
        Iterator iter = this._context.joins().iterator();
        while (iter.hasNext()) {
            joins = "(" + joins + " " + iter.next() + ") ";
        }
        return joins;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RDBMSPropertyProvider
    implements PropertyProvider {
        private final PropertyProvider _propertyProvider;
        private final Map _selectProperties;

        private RDBMSPropertyProvider(PropertyProvider propertyProvider, Map selectProperties) {
            this._propertyProvider = propertyProvider;
            this._selectProperties = selectProperties;
        }

        public boolean isSupportedProperty(String resourceUri, String propertyName, String propertyNamespace) throws SlideException {
            if (this._selectProperties.containsKey(new RequestedPropertyImpl(propertyName, propertyNamespace))) {
                return true;
            }
            if (this._propertyProvider != null) {
                return this._propertyProvider.isSupportedProperty(resourceUri, propertyName, propertyNamespace);
            }
            return false;
        }

        public Iterator getSupportedPropertiesNames(String resourceUri) throws SlideException {
            Iterator selected = this._selectProperties.keySet().iterator();
            Iterator provided = null;
            if (this._propertyProvider != null) {
                provided = this._propertyProvider.getSupportedPropertiesNames(resourceUri);
            }
            return new PropertyNamesIterator(selected, provided);
        }

        public NodeProperty getProperty(String resourceUri, String propertyName, String propertyNamespace) throws SlideException {
            Map properties = (Map)this._selectProperties.get(new RequestedPropertyImpl(propertyName, propertyNamespace));
            if (properties != null) {
                return (NodeProperty)properties.get(resourceUri);
            }
            if (this._propertyProvider != null) {
                return this._propertyProvider.getProperty(resourceUri, propertyName, propertyNamespace);
            }
            return null;
        }

        public Iterator getSupportedProperties(String resourceUri) throws SlideException {
            Iterator selected = this._selectProperties.values().iterator();
            Iterator provided = null;
            if (this._propertyProvider != null) {
                provided = this._propertyProvider.getSupportedProperties(resourceUri);
            }
            return new NodePropertiesIterator(resourceUri, selected, provided);
        }

        private static class NodePropertiesIterator
        implements Iterator {
            private String _resourceUri;
            private Iterator _selectedProperties;
            private Iterator _providedProperties;

            private NodePropertiesIterator(String resourceUri, Iterator selectedProperties, Iterator providedProperties) {
                this._resourceUri = resourceUri;
                this._selectedProperties = selectedProperties;
                this._providedProperties = providedProperties != null ? providedProperties : Collections.EMPTY_LIST.iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this._selectedProperties.hasNext() || this._providedProperties.hasNext();
            }

            public Object next() {
                if (this._selectedProperties.hasNext()) {
                    Map properties = (Map)this._selectedProperties.next();
                    return (NodeProperty)properties.get(this._resourceUri);
                }
                return this._providedProperties.next();
            }
        }

        private static class PropertyNamesIterator
        implements Iterator {
            private final Iterator _selectedProperties;
            private final Iterator _providedProperties;

            private PropertyNamesIterator(Iterator selectedProperties, Iterator providedProperties) {
                this._selectedProperties = selectedProperties;
                this._providedProperties = providedProperties != null ? providedProperties : Collections.EMPTY_LIST.iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this._selectedProperties.hasNext() || this._providedProperties.hasNext();
            }

            public Object next() {
                if (this._selectedProperties.hasNext()) {
                    RequestedProperty property = (RequestedProperty)this._selectedProperties.next();
                    return new PropertyName(property.getName(), property.getNamespace());
                }
                return this._providedProperties.next();
            }
        }
    }
}

