/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.Logger;

public interface RDBMSAdapter {
    public void setParameters(Hashtable var1) throws ServiceParameterErrorException, ServiceParameterMissingException;

    public Logger getLogger();

    public ObjectNode retrieveObject(Connection var1, Uri var2) throws ServiceAccessException, ObjectNotFoundException;

    public void storeObject(Connection var1, Uri var2, ObjectNode var3) throws ServiceAccessException, ObjectNotFoundException;

    public void createObject(Connection var1, Uri var2, ObjectNode var3) throws ServiceAccessException, ObjectAlreadyExistsException;

    public void removeObject(Connection var1, Uri var2, ObjectNode var3) throws ServiceAccessException, ObjectNotFoundException;

    public void grantPermission(Connection var1, Uri var2, NodePermission var3) throws ServiceAccessException;

    public void revokePermission(Connection var1, Uri var2, NodePermission var3) throws ServiceAccessException;

    public void revokePermissions(Connection var1, Uri var2) throws ServiceAccessException;

    public Enumeration enumeratePermissions(Connection var1, Uri var2) throws ServiceAccessException;

    public void putLock(Connection var1, Uri var2, NodeLock var3) throws ServiceAccessException;

    public void renewLock(Connection var1, Uri var2, NodeLock var3) throws ServiceAccessException, LockTokenNotFoundException;

    public void removeLock(Connection var1, Uri var2, NodeLock var3) throws ServiceAccessException, LockTokenNotFoundException;

    public void killLock(Connection var1, Uri var2, NodeLock var3) throws ServiceAccessException, LockTokenNotFoundException;

    public Enumeration enumerateLocks(Connection var1, Uri var2) throws ServiceAccessException;

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Connection var1, Uri var2) throws ServiceAccessException, RevisionDescriptorNotFoundException;

    public void createRevisionDescriptors(Connection var1, Uri var2, NodeRevisionDescriptors var3) throws ServiceAccessException;

    public void storeRevisionDescriptors(Connection var1, Uri var2, NodeRevisionDescriptors var3) throws ServiceAccessException, RevisionDescriptorNotFoundException;

    public void removeRevisionDescriptors(Connection var1, Uri var2) throws ServiceAccessException;

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Connection var1, Uri var2, NodeRevisionNumber var3) throws ServiceAccessException, RevisionDescriptorNotFoundException;

    public void createRevisionDescriptor(Connection var1, Uri var2, NodeRevisionDescriptor var3) throws ServiceAccessException;

    public void storeRevisionDescriptor(Connection var1, Uri var2, NodeRevisionDescriptor var3) throws ServiceAccessException, RevisionDescriptorNotFoundException;

    public void removeRevisionDescriptor(Connection var1, Uri var2, NodeRevisionNumber var3) throws ServiceAccessException;

    public NodeRevisionContent retrieveRevisionContent(Connection var1, Uri var2, NodeRevisionDescriptor var3, boolean var4) throws ServiceAccessException, RevisionNotFoundException;

    public void createRevisionContent(Connection var1, Uri var2, NodeRevisionDescriptor var3, NodeRevisionContent var4) throws ServiceAccessException, RevisionAlreadyExistException;

    public void storeRevisionContent(Connection var1, Uri var2, NodeRevisionDescriptor var3, NodeRevisionContent var4) throws ServiceAccessException, RevisionNotFoundException;

    public void removeRevisionContent(Connection var1, Uri var2, NodeRevisionDescriptor var3) throws ServiceAccessException;
}

