/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.index;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.index.TextContentIndexer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLContentIndexer
extends TextContentIndexer {
    private SAXParser m_parser;

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        super.initialize(token);
        try {
            this.m_parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            this.getLogger().log((Object)"Error creating parser for indexer", this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
        catch (SAXException e) {
            this.getLogger().log((Object)"Error creating parser for indexer", this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
    }

    protected synchronized Reader readContent(NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException {
        if (revisionDescriptor.getContentType().equals("text/xml")) {
            try {
                XMLContentIndexerHandler handler = new XMLContentIndexerHandler();
                this.m_parser.parse((InputStream)new ByteArrayInputStream(revisionContent.getContentBytes()), (DefaultHandler)handler);
                return new StringReader(handler.getText());
            }
            catch (SAXException e) {
                this.getLogger().log((Object)"Error parsing xml content for indexer", this.LOG_CHANNEL, 2);
            }
        }
        return super.readContent(revisionDescriptor, revisionContent);
    }

    private static final class XMLContentIndexerHandler
    extends DefaultHandler {
        private final StringBuffer m_text = new StringBuffer();

        private XMLContentIndexerHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.m_text.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            this.m_text.append(' ');
        }

        public String getText() {
            return this.m_text.toString();
        }
    }
}

