/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.index;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.common.XAServiceBase;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.extractor.ContentExtractor;
import org.apache.slide.extractor.ExtractorException;
import org.apache.slide.extractor.ExtractorManager;
import org.apache.slide.index.TextContainsExpressionFactory;
import org.apache.slide.search.IndexException;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.store.IndexStore;

public class TextContentIndexer
extends XAServiceBase
implements IndexStore {
    private static final String INDEX_PATH = "indexpath";
    private static final String INCLUDES = "includes";
    private static final String ANALYZER = "analyzer";
    public static final String URI_FIELD = "uri";
    public static final String CONTENT_TEXT = "content";
    private String indexpath = "";
    private Collection includes;
    private String analyzerClassName;
    private Analyzer analyzer;
    private boolean started = false;

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        this.initAnalyzer();
        IndexWriter indexWriter = null;
        try {
            indexWriter = new IndexWriter(this.indexpath, this.analyzer, false);
        }
        catch (IOException e) {
            try {
                indexWriter = new IndexWriter(this.indexpath, this.analyzer, true);
            }
            catch (IOException ex) {
                this.getLogger().log((Object)("Error while initializing the Lucene index " + e.getMessage()), this.LOG_CHANNEL, 2);
                throw new ServiceInitializationFailedException((Service)this, (Exception)ex);
            }
        }
        try {
            indexWriter.close();
        }
        catch (IOException e) {
            this.getLogger().log((Object)("Error while initializing the Lucene index " + e.getMessage()), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
        this.getLogger().log((Object)"Lucene is correctly initialized", this.LOG_CHANNEL, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void createIndex(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IndexException {
        block17: {
            if (!this.isIncluded(uri.toString())) {
                return;
            }
            IndexWriter indexWriter = null;
            indexWriter = new IndexWriter(this.indexpath, this.analyzer, false);
            Document doc = new Document();
            doc.add(Field.Keyword((String)URI_FIELD, (String)uri.toString()));
            doc.add(Field.Text((String)CONTENT_TEXT, (Reader)this.readContent(revisionDescriptor, revisionContent)));
            if (revisionContent != null && revisionDescriptor != null) {
                ContentExtractor[] extractor = ExtractorManager.getInstance().getContentExtractors(uri.getNamespace().getName(), null, revisionDescriptor);
                for (int i = 0; i < extractor.length; ++i) {
                    Reader reader = extractor[i].extract((InputStream)new ByteArrayInputStream(revisionContent.getContentBytes()));
                    doc.add(Field.Text((String)CONTENT_TEXT, (Reader)reader));
                }
            }
            indexWriter.addDocument(doc);
            indexWriter.optimize();
            this.getLogger().log((Object)("Added '" + uri.toString() + " - " + revisionDescriptor.getRevisionNumber().toString() + "' to index"), this.LOG_CHANNEL, 6);
            Object var10_11 = null;
            try {
                if (indexWriter != null) {
                    indexWriter.close();
                }
                break block17;
            }
            catch (IOException ioe) {}
            break block17;
            {
                catch (IOException e) {
                    this.getLogger().log((Object)("Error creating an index with " + uri.toString() + " - " + revisionDescriptor.getRevisionNumber()), this.LOG_CHANNEL, 2);
                    Object var10_12 = null;
                    try {
                        if (indexWriter != null) {
                            indexWriter.close();
                        }
                        break block17;
                    }
                    catch (IOException ioe) {}
                    break block17;
                }
                catch (ExtractorException e) {
                    this.getLogger().log((Object)("Error extracting content from " + uri.toString() + " - " + revisionDescriptor.getRevisionNumber()), this.LOG_CHANNEL, 2);
                    Object var10_13 = null;
                    try {
                        if (indexWriter != null) {
                            indexWriter.close();
                        }
                        break block17;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (indexWriter != null) {
                        indexWriter.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void updateIndex(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IndexException {
        block18: {
            IndexWriter indexWriter;
            block17: {
                if (!this.isIncluded(uri.toString())) {
                    return;
                }
                indexWriter = null;
                IndexReader indexReader = IndexReader.open((String)this.indexpath);
                Term term = new Term(URI_FIELD, uri.toString());
                indexReader.delete(term);
                indexReader.close();
                indexWriter = new IndexWriter(this.indexpath, this.analyzer, false);
                Document doc = new Document();
                doc.add(Field.Keyword((String)URI_FIELD, (String)uri.toString()));
                doc.add(Field.Text((String)CONTENT_TEXT, (Reader)this.readContent(revisionDescriptor, revisionContent)));
                if (revisionContent != null && revisionDescriptor != null) {
                    ContentExtractor[] extractor = ExtractorManager.getInstance().getContentExtractors(uri.getNamespace().getName(), null, revisionDescriptor);
                    for (int i = 0; i < extractor.length; ++i) {
                        Reader reader = extractor[i].extract((InputStream)new ByteArrayInputStream(revisionContent.getContentBytes()));
                        doc.add(Field.Text((String)CONTENT_TEXT, (Reader)reader));
                    }
                }
                indexWriter.addDocument(doc);
                indexWriter.optimize();
                if (!this.getLogger().isEnabled(7)) break block17;
                this.getLogger().log((Object)("Updated '" + uri + " - " + revisionDescriptor.getRevisionNumber() + "' to index"), this.LOG_CHANNEL, 7);
            }
            Object var12_13 = null;
            try {
                if (indexWriter != null) {
                    indexWriter.close();
                }
                break block18;
            }
            catch (IOException ioe) {}
            break block18;
            {
                catch (IOException e) {
                    this.getLogger().log((Object)("Error updating the index with " + uri + " - " + revisionDescriptor.getRevisionNumber()), this.LOG_CHANNEL, 2);
                    Object var12_14 = null;
                    try {
                        if (indexWriter != null) {
                            indexWriter.close();
                        }
                        break block18;
                    }
                    catch (IOException ioe) {}
                    break block18;
                }
                catch (ExtractorException e) {
                    this.getLogger().log((Object)("Error extracting content from " + uri + " - " + revisionDescriptor.getRevisionNumber()), this.LOG_CHANNEL, 2);
                    Object var12_15 = null;
                    try {
                        if (indexWriter != null) {
                            indexWriter.close();
                        }
                        break block18;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    if (indexWriter != null) {
                        indexWriter.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void dropIndex(Uri uri, NodeRevisionNumber number) throws IndexException {
        block14: {
            IndexWriter indexWriter;
            block13: {
                if (!this.isIncluded(uri.toString())) {
                    return;
                }
                if (number == NodeRevisionNumber.HIDDEN_0_0) {
                    return;
                }
                indexWriter = null;
                IndexReader indexReader = IndexReader.open((String)this.indexpath);
                Term term = new Term(URI_FIELD, uri.toString());
                indexReader.delete(term);
                indexReader.close();
                indexWriter = new IndexWriter(this.indexpath, this.analyzer, false);
                indexWriter.optimize();
                if (!this.getLogger().isEnabled(7)) break block13;
                this.getLogger().log((Object)("Deleted '" + uri + "' from the index"), this.LOG_CHANNEL, 7);
            }
            Object var7_7 = null;
            try {
                if (indexWriter != null) {
                    indexWriter.close();
                }
                break block14;
            }
            catch (IOException ioe) {}
            break block14;
            {
                catch (IOException e) {
                    this.getLogger().log((Object)("Impossible to delete " + uri + " - " + number + " from the Lucene index"));
                    Object var7_8 = null;
                    try {
                        if (indexWriter != null) {
                            indexWriter.close();
                        }
                        break block14;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (indexWriter != null) {
                        indexWriter.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public IBasicExpressionFactory getBasicExpressionFactory() {
        return new TextContainsExpressionFactory(this.indexpath, this.analyzer);
    }

    public void connect() throws ServiceConnectionFailedException {
        this.getLogger().log((Object)"TextContentIndexer:  connect", this.LOG_CHANNEL, 6);
        this.started = true;
    }

    public boolean isConnected() throws ServiceAccessException {
        return this.started;
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.indexpath = (String)parameters.get(INDEX_PATH);
        if (this.indexpath == null || this.indexpath.length() == 0) {
            throw new ServiceParameterMissingException((Service)this, INDEX_PATH);
        }
        String includes = (String)parameters.get(INCLUDES);
        if (includes != null && includes.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(includes, ",");
            this.includes = new ArrayList(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.includes.add(tokenizer.nextToken());
            }
        }
        this.analyzerClassName = (String)parameters.get(ANALYZER);
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        this.getLogger().log((Object)"TextContentIndexer:  disconnect", this.LOG_CHANNEL, 6);
        this.started = false;
    }

    public void reset() throws ServiceResetFailedException {
        this.getLogger().log((Object)"TextContentIndexer:  reset", this.LOG_CHANNEL, 6);
    }

    protected Reader readContent(NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException {
        return new CharArrayReader(revisionContent.getContent());
    }

    protected boolean isIncluded(String uri) {
        if (this.includes == null) {
            return true;
        }
        Iterator iter = this.includes.iterator();
        while (iter.hasNext()) {
            if (!uri.startsWith((String)iter.next())) continue;
            return true;
        }
        return false;
    }

    protected void initAnalyzer() throws ServiceInitializationFailedException {
        if (this.analyzerClassName == null || this.analyzerClassName.length() == 0) {
            this.getLogger().log((Object)"using Lucene StandardAnalyzer", this.LOG_CHANNEL, 6);
            this.analyzer = new StandardAnalyzer();
        } else {
            this.getLogger().log((Object)("loading Lucene analyzer: " + this.analyzerClassName), this.LOG_CHANNEL, 6);
            try {
                Class<?> analyzerClazz = Class.forName(this.analyzerClassName);
                this.analyzer = (Analyzer)analyzerClazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.getLogger().log((Object)("Error while instantiating analyzer " + this.analyzerClassName + cnfe.getMessage()), this.LOG_CHANNEL, 2);
                throw new ServiceInitializationFailedException((Service)this, (Exception)cnfe);
            }
            catch (InstantiationException ie) {
                this.getLogger().log((Object)("Error while instantiating analyzer " + this.analyzerClassName + ie.getMessage()), this.LOG_CHANNEL, 2);
                throw new ServiceInitializationFailedException((Service)this, (Exception)ie);
            }
            catch (IllegalAccessException iae) {
                this.getLogger().log((Object)("Error while instantiating analyzer " + this.analyzerClassName + iae.getMessage()), this.LOG_CHANNEL, 2);
                throw new ServiceInitializationFailedException((Service)this, (Exception)iae);
            }
        }
    }
}

