/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.index;

import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.slide.common.SlideException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.BasicResultSetImpl;
import org.apache.slide.search.basic.ComparableResourceImpl;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.IBasicResultSet;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.SubjectNode;

public class BasicExpressionTxtContainsSample
implements IBasicExpression {
    String searchedText;
    String indexPath;
    IBasicExpressionFactory factory;

    BasicExpressionTxtContainsSample(String searchedText, String rootPath) {
        this.searchedText = searchedText;
        this.indexPath = rootPath;
    }

    BasicExpressionTxtContainsSample(String mergeOperator, Collection children, IBasicExpressionFactory factory) throws BadQueryException {
    }

    public IBasicResultSet execute() throws SearchException {
        BasicResultSetImpl result = new BasicResultSetImpl(false);
        try {
            IndexSearcher searcher = new IndexSearcher(this.indexPath);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            Query query = QueryParser.parse((String)this.searchedText, (String)"contents", (Analyzer)analyzer);
            Hits hits = searcher.search(query);
            int noOfHits = hits.length();
            for (int i = 0; i < noOfHits; ++i) {
                Document doc = hits.doc(i);
                String uri = doc.get("documentId");
                System.out.println(uri);
                RequestedResource resource = this.createResource(uri);
                result.add((Object)resource);
            }
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
        return result;
    }

    private RequestedResource createResource(String uri) throws SearchException {
        SubjectNode node = new SubjectNode(uri);
        ComparableResourceImpl resource = null;
        IBasicQuery query = this.factory.getQuery();
        try {
            resource = new ComparableResourceImpl((ObjectNode)node, query.getSearchToken(), query.getScope(), this.factory.getPropertyProvider());
        }
        catch (SlideException e) {
            throw new SearchException((Throwable)e);
        }
        return resource;
    }

    public void setFactory(IBasicExpressionFactory factory) {
        this.factory = factory;
    }

    public IBasicExpressionFactory getFactory() {
        return this.factory;
    }
}

