/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.AssertionFailedError;
import org.easymock.ArgumentsMatcher;
import org.easymock.internal.Arguments;
import org.easymock.internal.MatchableArguments;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.ResultList;

public class ResultListMap {
    private Map resultListMap = new TreeMap();
    private ArgumentsMatcher matcher;
    private Method method;

    public ResultListMap(Method method, ArgumentsMatcher matcher) {
        this.method = method;
        this.matcher = matcher;
    }

    public void addExpected(Arguments expected, Result result, Range count) {
        MatchableArguments matchable = new MatchableArguments(expected, this.matcher);
        if (!this.resultListMap.containsKey(matchable)) {
            this.resultListMap.put(matchable, new ResultList());
        }
        ResultList list = (ResultList)this.resultListMap.get(matchable);
        list.add(result, count);
    }

    public Result addActual(Arguments actual) {
        boolean matched = false;
        MatchableArguments arguments = new MatchableArguments(actual, this.matcher);
        ResultList list = (ResultList)this.resultListMap.get(arguments);
        if (list != null) {
            matched = true;
            Result result = list.next();
            if (result != null) {
                return result;
            }
        }
        throw new AssertionFailedError(this.createFailureMessage(arguments, matched));
    }

    private String createFailureMessage(MatchableArguments actual, boolean matched) {
        StringBuffer result = new StringBuffer();
        if (!matched) {
            result.append("\n    ");
            result.append(new MethodCall(this.method, actual.getArguments()).toString(this.matcher));
            result.append(": ");
            result.append(new Range(7).expectedAndActual(1).replace('7', '0'));
        }
        Iterator it = this.resultListMap.keySet().iterator();
        while (it.hasNext()) {
            MatchableArguments expected = (MatchableArguments)it.next();
            ResultList list = (ResultList)this.resultListMap.get(expected);
            if (list.hasValidCallCount() && !expected.equals(actual)) continue;
            int count = list.getCallCount() + (expected.equals(actual) ? 1 : 0);
            result.append("\n    ");
            result.append(new MethodCall(this.method, expected.getArguments()).toString(this.matcher));
            result.append(": ");
            result.append(list.getMessage(count));
        }
        return result.toString();
    }

    public void verify() {
        String failureMessage = "";
        boolean verifyFailed = false;
        Iterator it = this.resultListMap.keySet().iterator();
        while (it.hasNext()) {
            MatchableArguments expected = (MatchableArguments)it.next();
            ResultList list = (ResultList)this.resultListMap.get(expected);
            if (list.hasValidCallCount()) continue;
            verifyFailed = true;
            failureMessage = failureMessage + "\n    " + new MethodCall(this.method, expected.getArguments()).toString(this.matcher) + ": " + list.getMessage();
        }
        if (verifyFailed) {
            throw new AssertionFailedError(failureMessage);
        }
    }
}

