/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.util.AntBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.groovy.ant.AntProjectPropertiesDelegate;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.tools.ErrorReporter;

public class Groovy
extends Task {
    private Vector filesets = new Vector();
    private File srcFile = null;
    private String command = "";
    private boolean print = false;
    private File output = null;
    private boolean append = false;
    private static Hashtable loaderMap = new Hashtable(3);
    private Path classpath;
    private String userId = null;
    private String version = null;
    private CompilerConfiguration configuration = new CompilerConfiguration();

    public void setStacktrace(boolean stacktrace) {
        this.configuration.setDebug(stacktrace);
    }

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public void addText(String txt) {
        this.log("addText('" + txt + "')", 3);
        this.command = this.command + txt;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    protected static Hashtable getLoaderMap() {
        return loaderMap;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserid(String userId) {
        this.userId = userId;
    }

    public String getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block14: {
            this.log("execute()", 3);
            this.command = this.command.trim();
            if (this.srcFile == null && this.command.length() == 0 && this.filesets.isEmpty()) {
                throw new BuildException("Source file does not exist!", this.getLocation());
            }
            if (this.srcFile != null && !this.srcFile.exists()) {
                throw new BuildException("Source file does not exist!", this.getLocation());
            }
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File srcDir = fs.getDir(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
            }
            try {
                PrintStream out = System.out;
                try {
                    if (this.output != null) {
                        this.log("Opening PrintStream to output file " + this.output, 3);
                        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                    }
                    if (this.command == null || this.command.trim().length() == 0) {
                        this.command = Groovy.getText(new BufferedReader(new FileReader(this.srcFile)));
                    }
                    if (this.command != null) {
                        this.execGroovy(this.command, out);
                        break block14;
                    }
                    throw new BuildException("Source file does not exist!", this.getLocation());
                }
                finally {
                    if (out != null && out != System.out) {
                        out.close();
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
        }
        this.log("statements executed successfully");
    }

    private static String getText(BufferedReader reader) throws IOException {
        StringBuffer answer = new StringBuffer();
        char[] charBuffer = new char[4096];
        int nbCharRead = 0;
        while ((nbCharRead = reader.read(charBuffer)) != -1) {
            answer.append(charBuffer, 0, nbCharRead);
        }
        reader.close();
        return answer.toString();
    }

    protected void runStatements(Reader reader, PrintStream out) throws IOException {
        this.log("runStatements()", 3);
        StringBuffer txt = new StringBuffer();
        String line = "";
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            line = this.getProject().replaceProperties(line);
            if (line.indexOf("--") < 0) continue;
            txt.append("\n");
        }
        if (!txt.equals("")) {
            this.execGroovy(txt.toString(), out);
        }
    }

    protected void execGroovy(String txt, PrintStream out) {
        this.log("execGroovy()", 3);
        if ("".equals(txt.trim())) {
            return;
        }
        this.log("Groovy: " + txt, 3);
        GroovyShell groovy = null;
        Object mavenPom = null;
        Project project = this.getProject();
        if ("org.apache.commons.grant.GrantProject".equals(project.getClass().getName())) {
            try {
                Object propsHandler = project.getClass().getMethod("getPropsHandler", new Class[0]).invoke((Object)project, new Object[0]);
                Field contextField = propsHandler.getClass().getDeclaredField("context");
                contextField.setAccessible(true);
                Object context = contextField.get(propsHandler);
                mavenPom = InvokerHelper.invokeMethod(context, "getProject", new Object[0]);
            }
            catch (Exception e) {
                throw new BuildException("Impossible to retrieve Maven's Ant project: " + e.getMessage(), this.getLocation());
            }
            Thread.currentThread().setContextClassLoader(GroovyShell.class.getClassLoader());
            groovy = new GroovyShell(mavenPom.getClass().getClassLoader(), new Binding(), this.configuration);
        } else {
            groovy = new GroovyShell(GroovyShell.class.getClassLoader(), new Binding(), this.configuration);
        }
        try {
            Script script = groovy.parse(txt);
            script.setProperty("ant", new AntBuilder(project));
            script.setProperty("project", project);
            script.setProperty("properties", new AntProjectPropertiesDelegate(project));
            script.setProperty("target", this.getOwningTarget());
            script.setProperty("task", (Object)this);
            if (mavenPom != null) {
                script.setProperty("pom", mavenPom);
            }
            script.run();
        }
        catch (CompilationFailedException e) {
            StringWriter writer = new StringWriter();
            new ErrorReporter(e, false).write(new PrintWriter(writer));
            String message = writer.toString();
            throw new BuildException("Script Failed: " + message, this.getLocation());
        }
    }

    protected void printResults(PrintStream out) {
        this.log("printResults()", 3);
        StringBuffer line = new StringBuffer();
        out.println(line);
        line = new StringBuffer();
        out.println();
    }
}

