/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.tweak;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.tweak.StatementLocator;

public class ClasspathStatementLocator
implements StatementLocator {
    static /* synthetic */ Class class$org$skife$jdbi$tweak$ClasspathStatementLocator;

    public String load(String name) {
        ClassLoader loader = ClasspathStatementLocator.selectClassLoader();
        InputStream in_stream = loader.getResourceAsStream(name + ".sql");
        if (in_stream == null) {
            in_stream = loader.getResourceAsStream(name);
        }
        if (in_stream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in_stream));
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (ClasspathStatementLocator.isComment(line)) continue;
                buffer.append(line).append(" ");
            }
            reader.close();
        }
        catch (IOException e) {
            throw new DBIException(e.getMessage(), e);
        }
        String sql = buffer.toString();
        return sql;
    }

    public static ClassLoader selectClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (class$org$skife$jdbi$tweak$ClasspathStatementLocator == null ? (class$org$skife$jdbi$tweak$ClasspathStatementLocator = ClasspathStatementLocator.class$("org.skife.jdbi.tweak.ClasspathStatementLocator")) : class$org$skife$jdbi$tweak$ClasspathStatementLocator).getClassLoader();
        return loader;
    }

    public static boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("--") || line.startsWith("//");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

