/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.tweak;

import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.tweak.StatementLocator;

public class CachingStatementLocator
implements StatementLocator {
    private final Map cache;
    private StatementLocator locator;

    public CachingStatementLocator(StatementLocator locator) {
        this.locator = locator;
        this.cache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String load(String key) {
        if (this.cache.containsKey(key)) {
            return (String)this.cache.get(key);
        }
        String sql = this.locator.load(key);
        if (sql != null) {
            Map map = this.cache;
            synchronized (map) {
                this.cache.put(key, sql);
            }
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String key) {
        Map map = this.cache;
        synchronized (map) {
            return this.cache.remove(key) != null;
        }
    }
}

