/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.spring;

import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.skife.jdbi.HandleCallback;
import org.skife.jdbi.IDBI;
import org.skife.jdbi.spring.DBIUtils;
import org.skife.jdbi.spring.SQLExceptionTranslatingThrowsAdvice;
import org.skife.jdbi.spring.SpringTransactionHandler;
import org.skife.jdbi.tweak.StatementLocator;
import org.skife.jdbi.tweak.TransactionHandler;
import org.springframework.aop.framework.ProxyFactory;

class SpringDBIAdaptor
implements IDBI {
    private final IDBI real;
    private DataSource dataSource;
    static /* synthetic */ Class class$org$skife$jdbi$Handle;

    SpringDBIAdaptor(IDBI real, DataSource dataSource) {
        this.real = real;
        this.dataSource = dataSource;
        real.setTransactionHandler(new SpringTransactionHandler(this));
    }

    public Handle open() throws DBIException {
        ProxyFactory pf = new ProxyFactory();
        pf.setProxyTargetClass(false);
        pf.setInterfaces(new Class[]{class$org$skife$jdbi$Handle == null ? (class$org$skife$jdbi$Handle = SpringDBIAdaptor.class$("org.skife.jdbi.Handle")) : class$org$skife$jdbi$Handle});
        pf.setTarget((Object)this.real.open());
        pf.addAdvice((Advice)new SQLExceptionTranslatingThrowsAdvice(this.dataSource));
        return (Handle)pf.getProxy();
    }

    public void open(HandleCallback callback) throws DBIException {
        Handle bound = DBIUtils.getHandle(this);
        try {
            callback.withHandle(bound);
        }
        catch (Exception e) {
            throw new DBIException(e.getMessage(), e);
        }
        finally {
            DBIUtils.closeHandleIfNecessary(bound, this);
        }
    }

    public Map getNamedStatements() {
        return this.real.getNamedStatements();
    }

    public void name(String name, String statement) throws DBIException {
        this.real.name(name, statement);
    }

    public void load(String name) throws DBIException, IOException {
        this.real.load(name);
    }

    public void setTransactionHandler(TransactionHandler handler) {
        throw new UnsupportedOperationException("jDBI requires a special transaction handler in Spring in order to participate in Spring's transaction system, you are not allowed to override this. Sorry.");
    }

    public void setStatementLocator(StatementLocator locator) {
        this.real.setStatementLocator(locator);
    }

    public Map getGlobalParameters() {
        return this.real.getGlobalParameters();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

