/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.spring;

import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class SQLExceptionTranslatingThrowsAdvice
implements ThrowsAdvice {
    private SQLExceptionTranslator exceptionTranslator;

    public SQLExceptionTranslatingThrowsAdvice(DataSource dataSource) {
        this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(dataSource);
    }

    public void afterThrowing(Method method, Object[] args, Object target, DBIException ex) throws Throwable {
        Throwable t = ex.getCause();
        String sql = ((Handle)target).toString();
        if (t instanceof SQLException) {
            throw this.exceptionTranslator.translate("DBI", sql, (SQLException)t);
        }
        throw new DataRetrievalFailureException("DBI Exception:" + ex.getMessage(), t);
    }
}

