/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.spring;

import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.skife.jdbi.IDBI;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DBIUtils {
    public static Handle getHandle(IDBI dbi) throws DBIException {
        Handle handle = (Handle)TransactionSynchronizationManager.getResource((Object)dbi);
        if (handle == null) {
            handle = dbi.open();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.bindResource((Object)dbi, (Object)handle);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new HandleSynchronization(handle, dbi));
            }
        }
        return handle;
    }

    public static void closeHandleIfNecessary(Handle h, IDBI dbi) {
        Handle handle = (Handle)TransactionSynchronizationManager.getResource((Object)dbi);
        if (handle != h) {
            h.close();
        }
    }

    private static class HandleSynchronization
    extends TransactionSynchronizationAdapter {
        private final Handle handle;
        private IDBI dbi;

        private HandleSynchronization(Handle handle, IDBI dbi) {
            this.handle = handle;
            this.dbi = dbi;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.dbi);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.dbi, (Object)this.handle);
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.dbi);
            this.handle.clearStatementCache();
        }
    }
}

