/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.spring;

import java.sql.Connection;
import javax.sql.DataSource;
import org.skife.jdbi.ConnectionFactory;
import org.skife.jdbi.DBI;
import org.skife.jdbi.spring.SpringDBIAdaptor;
import org.skife.jdbi.unstable.decorator.HandleDecorator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DBIBean
implements FactoryBean,
InitializingBean {
    private DataSource dataSource;
    private HandleDecorator handleDecorator;
    static /* synthetic */ Class class$org$skife$jdbi$IDBI;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setHandleDecoratorBuilder(HandleDecorator builder) {
        this.handleDecorator = builder;
    }

    public Object getObject() throws Exception {
        DBI dbi = new DBI(new ConnectionFactory(){

            public Connection getConnection() {
                return DataSourceUtils.getConnection((DataSource)DBIBean.this.dataSource);
            }
        });
        if (this.handleDecorator != null) {
            dbi.setHandleDecorator(this.handleDecorator);
        }
        return new SpringDBIAdaptor(dbi, this.dataSource);
    }

    public Class getObjectType() {
        return class$org$skife$jdbi$IDBI == null ? (class$org$skife$jdbi$IDBI = DBIBean.class$("org.skife.jdbi.IDBI")) : class$org$skife$jdbi$IDBI;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalStateException("must set a dataSource property");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

