/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.Arguments;
import org.skife.jdbi.StatementEnvelope;
import org.skife.jdbi.StatementParser;

class StaticStatementEnvelope
implements StatementEnvelope {
    final PreparedStatement stmt;
    final StatementParser parser;

    StaticStatementEnvelope(Connection conn, StatementParser parser) throws SQLException {
        this.parser = parser;
        String real_sql = parser.getSubstitutedSql();
        this.stmt = real_sql.toUpperCase().trim().startsWith("CALL") ? conn.prepareCall(real_sql) : conn.prepareStatement(real_sql);
    }

    public PreparedStatement prepare(Arguments args) throws SQLException {
        Object[] params = args.objects();
        this.stmt.clearParameters();
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            this.stmt.setObject(i + 1, param);
        }
        return this.stmt;
    }

    public void close() throws SQLException {
        this.stmt.close();
    }

    public String[] getNamedParameters() {
        return this.parser.getNamedParams();
    }
}

