/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class StatementParser {
    private static final Pattern TOKEN_PATTERN = Pattern.compile(":(\\w+)");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("'.*'");
    private static final Pattern IN_PARAM_PATTERN = Pattern.compile("\\sin\\s*\\(\\?\\)");
    private static final String[] EMPTY = new String[0];
    private final String[] tokens;
    private final String replaced;

    public String[] getNamedParams() {
        return this.tokens;
    }

    public String getSubstitutedSql() {
        return this.replaced;
    }

    boolean isDynamic() {
        return IN_PARAM_PATTERN.matcher(this.replaced).find();
    }

    StatementParser(String sql) {
        if (sql.indexOf(":") == -1) {
            this.tokens = EMPTY;
            this.replaced = sql;
            return;
        }
        Matcher token_matcher = TOKEN_PATTERN.matcher(sql);
        Matcher quote_matcher = QUOTE_PATTERN.matcher(sql);
        boolean last_quote = quote_matcher.find();
        if (!last_quote) {
            this.replaced = token_matcher.replaceAll("?");
            token_matcher.reset();
            ArrayList<String> tokens = new ArrayList<String>();
            while (token_matcher.find()) {
                tokens.add(token_matcher.group().substring(token_matcher.group().indexOf(":") + 1));
            }
            this.tokens = tokens.toArray(new String[tokens.size()]);
        } else {
            boolean last_token = token_matcher.find();
            if (last_token) {
                ArrayList<String> tokens = new ArrayList<String>();
                StringBuffer replaced = new StringBuffer();
                int end = quote_matcher.start() > token_matcher.start() ? token_matcher.start() : quote_matcher.start();
                replaced.append(sql.substring(0, end));
                do {
                    if (last_token && last_quote) {
                        if (token_matcher.end() < quote_matcher.start()) {
                            replaced.append("?");
                            tokens.add(token_matcher.group().substring(1, token_matcher.group().length()));
                            replaced.append(sql.substring(token_matcher.end(), quote_matcher.start()));
                            last_token = token_matcher.find();
                            continue;
                        }
                        if (token_matcher.start() > quote_matcher.end()) {
                            replaced.append(sql.substring(quote_matcher.start(), token_matcher.start()));
                            last_quote = quote_matcher.find();
                            continue;
                        }
                        replaced.append(sql.substring(quote_matcher.start(), quote_matcher.end()));
                        while ((last_token = token_matcher.find()) && token_matcher.start() <= quote_matcher.end()) {
                        }
                        last_quote = quote_matcher.find();
                        continue;
                    }
                    if (last_token) {
                        replaced.append("?");
                        tokens.add(token_matcher.group().substring(1, token_matcher.group().length()));
                        int index = token_matcher.end();
                        last_token = token_matcher.find();
                        replaced.append(sql.substring(index, last_token ? token_matcher.start() : sql.length()));
                        continue;
                    }
                    if (!last_quote) continue;
                    replaced.append(sql.substring(quote_matcher.start(), sql.length()));
                    last_quote = false;
                } while (last_token || last_quote);
                this.replaced = replaced.toString();
                this.tokens = tokens.toArray(new String[tokens.size()]);
            } else {
                this.tokens = EMPTY;
                this.replaced = sql;
            }
        }
    }
}

