/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.skife.jdbi.AutoConfigurator;
import org.skife.jdbi.ConnectionFactory;
import org.skife.jdbi.ConnectionHandle;
import org.skife.jdbi.DBIError;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.skife.jdbi.HandleCallback;
import org.skife.jdbi.IDBI;
import org.skife.jdbi.NamedStatementRepository;
import org.skife.jdbi.NullHandleDecorator;
import org.skife.jdbi.tweak.ConnectionTransactionHandler;
import org.skife.jdbi.tweak.StatementLocator;
import org.skife.jdbi.tweak.TransactionHandler;
import org.skife.jdbi.unstable.decorator.HandleDecorator;

public class DBI
implements IDBI {
    private final NamedStatementRepository repository;
    private final ConnectionFactory factory;
    private HandleDecorator handleDecorator = new NullHandleDecorator();
    private TransactionHandler transactionHandler = new ConnectionTransactionHandler();
    private Map globals = new HashMap();

    public DBI() throws IOException {
        this.repository = new NamedStatementRepository();
        AutoConfigurator auto = new AutoConfigurator();
        this.factory = auto.getConnectionFactory();
        try {
            StatementLocator l;
            TransactionHandler h;
            HandleDecorator d = auto.getHandleDecoratorBuilder();
            if (d != null) {
                this.handleDecorator = d;
            }
            if ((h = auto.getTransactionHandler()) != null) {
                this.transactionHandler = h;
            }
            if ((l = auto.getStatementLocator()) != null) {
                this.repository.setLocator(l);
            }
        }
        catch (Exception e) {
            throw new DBIError("Unable to instantiate handle decorator builder :" + e.getMessage(), e);
        }
    }

    public DBI(final String wombat) {
        this.repository = new NamedStatementRepository();
        if (wombat.startsWith("jdbc:")) {
            this.factory = new ConnectionFactory(){

                public Connection getConnection() throws SQLException {
                    return DriverManager.getConnection(wombat);
                }
            };
        } else {
            try {
                InitialContext ctx = new InitialContext();
                final DataSource source = (DataSource)ctx.lookup(wombat);
                this.factory = new ConnectionFactory(){

                    public Connection getConnection() throws SQLException {
                        return source.getConnection();
                    }
                };
            }
            catch (Exception e) {
                throw new DBIError("connection string is not a jdbc connection string, not a valid jndi lookup wombat to a DataSource instance: [" + wombat + "]");
            }
        }
    }

    public DBI(final String wombat, final String name, final String pass) {
        this.repository = new NamedStatementRepository();
        if (wombat.startsWith("jdbc:")) {
            this.factory = new ConnectionFactory(){

                public Connection getConnection() throws SQLException {
                    return DriverManager.getConnection(wombat, name, pass);
                }
            };
        } else {
            try {
                InitialContext ctx = new InitialContext();
                final DataSource source = (DataSource)ctx.lookup(wombat);
                this.factory = new ConnectionFactory(){

                    public Connection getConnection() throws SQLException {
                        return source.getConnection(name, pass);
                    }
                };
            }
            catch (Exception e) {
                throw new DBIError("connection string is not a jdbc connection string, not a valid jndi lookup wombat to a DataSource instance: [" + wombat + "]");
            }
        }
    }

    public DBI(final DataSource source) {
        this(new ConnectionFactory(){

            public Connection getConnection() throws SQLException {
                return source.getConnection();
            }
        });
    }

    public DBI(final DataSource source, final String name, final String pass) {
        this(new ConnectionFactory(){

            public Connection getConnection() throws SQLException {
                return source.getConnection(name, pass);
            }
        });
    }

    public DBI(ConnectionFactory factory) {
        this.repository = new NamedStatementRepository();
        this.factory = factory;
    }

    public Map getGlobalParameters() {
        return this.globals;
    }

    public Handle open() throws DBIException {
        try {
            return this.handleDecorator.decorate(this, new ConnectionHandle(this.factory.getConnection(), this.repository, this.transactionHandler, this.globals));
        }
        catch (SQLException e) {
            throw new DBIException("Unable to obtain JDBC Connection: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(HandleCallback callback) throws DBIException {
        Handle handle = null;
        try {
            try {
                handle = this.open();
                callback.withHandle(handle);
            }
            catch (DBIException e) {
                if (handle == null) throw e;
                if (!handle.isInTransaction()) throw e;
                handle.rollback();
                throw e;
            }
            catch (Exception e) {
                if (handle == null) throw new DBIException("Exception thrown from callback, see nested exception", e);
                if (!handle.isInTransaction()) throw new DBIException("Exception thrown from callback, see nested exception", e);
                handle.rollback();
                throw new DBIException("Exception thrown from callback, see nested exception", e);
            }
            catch (Error e) {
                if (handle == null) throw new DBIError("Error thrown from callback, see wrapped error", e);
                if (!handle.isInTransaction()) throw new DBIError("Error thrown from callback, see wrapped error", e);
                handle.rollback();
                throw new DBIError("Error thrown from callback, see wrapped error", e);
            }
            Object var5_3 = null;
            if (handle == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (handle == null) throw throwable;
            if (!handle.isOpen()) throw throwable;
            if (handle.isInTransaction()) {
                handle.commit();
            }
            handle.close();
            throw throwable;
        }
        if (!handle.isOpen()) return;
        if (handle.isInTransaction()) {
            handle.commit();
        }
        handle.close();
    }

    public Map getNamedStatements() {
        return Collections.unmodifiableMap(new HashMap(this.repository.getStore()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void name(String name, String statement) throws DBIException {
        Handle handle = null;
        try {
            handle = this.open();
            handle.name(name, statement);
        }
        finally {
            if (handle != null) {
                handle.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name) throws DBIException, IOException {
        Handle handle = null;
        try {
            handle = this.open();
            handle.load(name);
        }
        finally {
            if (handle != null) {
                handle.close();
            }
        }
    }

    public void setTransactionHandler(TransactionHandler handler) {
        this.transactionHandler = handler;
    }

    public void setStatementLocator(StatementLocator locator) {
        this.repository.setLocator(locator);
    }

    public void setHandleDecorator(HandleDecorator builder) {
        this.handleDecorator = builder;
    }

    public static Handle open(String connString) throws DBIException {
        return new DBI(connString).open();
    }

    public static Handle open(String wombat, String name, String pass) throws DBIException {
        return new DBI(wombat, name, pass).open();
    }

    public static Handle open(DataSource source) throws DBIException {
        return new DBI(source).open();
    }

    public static Handle open(DataSource source, String name, String pass) throws DBIException {
        return new DBI(source, name, pass).open();
    }

    public static void open(String connString, HandleCallback callback) throws DBIException {
        new DBI(connString).open(callback);
    }

    public static void open(String wombat, String name, String pass, HandleCallback callback) throws DBIException {
        new DBI(wombat, name, pass).open(callback);
    }

    public static void open(DataSource source, HandleCallback callback) throws DBIException {
        new DBI(source).open(callback);
    }

    public static void open(DataSource source, String name, String pass, HandleCallback callback) throws DBIException {
        new DBI(source, name, pass).open(callback);
    }
}

