/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.Batch;
import org.skife.jdbi.CacheCloseException;
import org.skife.jdbi.DBIError;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.skife.jdbi.NamedStatementRepository;
import org.skife.jdbi.ParamTool;
import org.skife.jdbi.PreparedBatch;
import org.skife.jdbi.QueueingBatch;
import org.skife.jdbi.QueueingPreparedBatch;
import org.skife.jdbi.RowCallback;
import org.skife.jdbi.RowMap;
import org.skife.jdbi.Script;
import org.skife.jdbi.StatementCache;
import org.skife.jdbi.TransactionCallback;
import org.skife.jdbi.tweak.ConnectionTransactionHandler;
import org.skife.jdbi.tweak.TransactionHandler;

class ConnectionHandle
implements Handle {
    private final Connection conn;
    private final StatementCache cache;
    private final TransactionHandler transactionHandler;

    ConnectionHandle(Connection conn) {
        this(conn, new NamedStatementRepository());
    }

    ConnectionHandle(Connection conn, NamedStatementRepository repository) {
        this(conn, repository, new ConnectionTransactionHandler(), new HashMap());
    }

    ConnectionHandle(Connection conn, NamedStatementRepository repository, TransactionHandler transactionHandler, Map globals) {
        this.conn = conn;
        this.transactionHandler = transactionHandler;
        this.cache = new StatementCache(conn, repository, new HashMap(globals));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateInternal(PreparedStatement stmt) throws DBIException {
        int n;
        try {
            try {
                n = stmt.executeUpdate();
                Object var4_4 = null;
            }
            catch (SQLException e) {
                throw new DBIException("error while executing sql: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                stmt.clearParameters();
                throw throwable;
            }
            catch (SQLException e2) {
                throw new DBIException("exception while clearing paramters: " + e2.getMessage());
            }
        }
        try {}
        catch (SQLException e2) {
            throw new DBIException("exception while clearing paramters: " + e2.getMessage());
        }
        stmt.clearParameters();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeBareStatement(PreparedStatement stmt) throws DBIException {
        try {
            try {
                stmt.execute();
            }
            catch (SQLException e) {
                throw new DBIException("error while executing sql: " + e.getMessage(), e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                stmt.clearParameters();
                throw throwable;
            }
            catch (SQLException e) {
                throw new DBIException("exception while clearing paramters: " + e.getMessage());
            }
        }
        try {}
        catch (SQLException e) {
            throw new DBIException("exception while clearing paramters: " + e.getMessage());
        }
        stmt.clearParameters();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void begin() throws DBIException {
        this.transactionHandler.begin(this);
    }

    public void close() {
        ArrayList<SQLException> errors = new ArrayList<SQLException>();
        try {
            this.clearStatementCacheInternal();
        }
        catch (CacheCloseException e) {
            errors.addAll(e.getExceptions());
        }
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            DBIError top = new DBIError();
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                SQLException error = (SQLException)iterator.next();
                DBIError mine = new DBIError(error);
                top.initCause(mine);
                top = mine;
            }
            throw top;
        }
    }

    public void clearStatementCacheInternal() throws CacheCloseException {
        Collection exceptions = this.cache.close();
        if (exceptions.isEmpty()) {
            return;
        }
        CacheCloseException e = new CacheCloseException();
        e.getExceptions().addAll(exceptions);
        throw e;
    }

    public void clearStatementCache() {
        try {
            this.clearStatementCacheInternal();
        }
        catch (CacheCloseException cacheCloseException) {
            // empty catch block
        }
    }

    public void commit() throws DBIException {
        this.transactionHandler.commit(this);
    }

    public void rollback() throws DBIException {
        this.transactionHandler.rollback(this);
    }

    public void inTransaction(TransactionCallback callback) throws DBIException {
        this.begin();
        try {
            callback.inTransaction(this);
            this.commit();
        }
        catch (DBIException e) {
            this.rollback();
            throw e;
        }
        catch (Exception e) {
            this.rollback();
            throw new DBIException("exception thrown from callback: " + e.getMessage(), e);
        }
        catch (Error e) {
            this.rollback();
            throw new DBIError("error thrown from callback: " + e.getMessage(), e);
        }
    }

    public boolean isInTransaction() {
        return this.transactionHandler.isInTransaction(this);
    }

    public void execute(String sql) throws DBIException {
        this.execute(sql, ParamTool.EMPTY_OBJECT_ARRAY);
    }

    public void execute(String statement, Object[] args) throws DBIException {
        this.executeBareStatement(this.cache.find(statement, args));
    }

    public void execute(String statement, Collection args) throws DBIException {
        this.executeBareStatement(this.cache.find(statement, args));
    }

    public void execute(String statement, Map args) throws DBIException {
        this.executeBareStatement(this.cache.find(statement, args));
    }

    public void execute(String statement, Object bean) throws DBIException {
        this.executeBareStatement(this.cache.find(statement, bean));
    }

    public int update(String statement) throws DBIException {
        return this.updateInternal(this.cache.find(statement));
    }

    public int update(String statement, Object[] args) throws DBIException {
        return this.updateInternal(this.cache.find(statement, args));
    }

    public int update(String statement, Collection args) throws DBIException {
        return this.updateInternal(this.cache.find(statement, args));
    }

    public int update(String statement, Map args) throws DBIException {
        return this.updateInternal(this.cache.find(statement, args));
    }

    public int update(String statement, Object bean) throws DBIException {
        return this.updateInternal(this.cache.find(statement, bean));
    }

    public List query(String query) throws DBIException {
        return this.queryCollectingResults(this.cache.find(query, Collections.EMPTY_MAP));
    }

    public void query(String statement, RowCallback callback) throws DBIException {
        this.executeInternal(this.cache.find(statement), callback);
    }

    public void query(String statement, Object[] args, RowCallback callback) throws DBIException {
        this.executeInternal(this.cache.find(statement, args), callback);
    }

    public void query(String statement, Map args, RowCallback callback) throws DBIException {
        this.executeInternal(this.cache.find(statement, args), callback);
    }

    public List query(String statement, Map args) throws DBIException {
        return this.queryCollectingResults(this.cache.find(statement, args));
    }

    public List query(String statement, Object param) throws DBIException {
        return this.queryCollectingResults(this.cache.find(statement, param));
    }

    public List query(String statement, Object[] args) throws DBIException {
        return this.queryCollectingResults(this.cache.find(statement, args));
    }

    public List query(String statement, Collection args) throws DBIException {
        return this.queryCollectingResults(this.cache.find(statement, args));
    }

    public Map first(String statement) throws DBIException {
        return this.extractFirst(this.query(statement, Collections.EMPTY_MAP));
    }

    public Map first(String statement, Object bean) throws DBIException {
        return this.extractFirst(this.query(statement, bean));
    }

    public Map first(String statement, Map args) throws DBIException {
        return this.extractFirst(this.query(statement, args));
    }

    public Map first(String statement, Object[] params) throws DBIException {
        return this.extractFirst(this.query(statement, params));
    }

    public Map first(String statement, Collection params) throws DBIException {
        return this.extractFirst(this.query(statement, params));
    }

    private Map extractFirst(List results) {
        return results.size() > 0 ? results.get(0) : null;
    }

    private List queryCollectingResults(PreparedStatement stmt) throws DBIException {
        final ArrayList results = new ArrayList();
        this.executeInternal(stmt, new RowCallback(){

            public void eachRow(Handle handle, Map row) throws Exception {
                results.add(row);
            }
        });
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeInternal(PreparedStatement stmt, RowCallback callback) throws DBIException {
        String[] columns;
        ResultSet results;
        try {
            results = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new DBIException("error while executing statement: " + e.getMessage(), e);
        }
        try {
            try {
                ResultSetMetaData metadata = results.getMetaData();
                int count = metadata.getColumnCount();
                columns = new String[count];
                for (int i = 1; i != count + 1; ++i) {
                    String column_name = metadata.getColumnName(i);
                    String column_label = metadata.getColumnLabel(i);
                    columns[i - 1] = column_label != null ? column_label : column_name;
                }
            }
            catch (SQLException e) {
                throw new DBIException("exception while reading results: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            try {
                results.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new DBIException("exception while trying to close resultset: " + e.getMessage(), e);
            }
        }
        while (results.next()) {
            RowMap row = new RowMap();
            for (int i = 0; i != columns.length; ++i) {
                String column = columns[i];
                Object value = results.getObject(i + 1);
                row.put(column, value);
            }
            try {
                callback.eachRow(this, row);
            }
            catch (Exception e) {
                results.close();
                throw new DBIException("exception while handling results", e);
            }
            catch (Error e) {
                results.close();
                throw new DBIError("error while handling results", e);
            }
        }
        Object var12_17 = null;
        try {}
        catch (SQLException e) {
            throw new DBIException("exception while trying to close resultset: " + e.getMessage(), e);
        }
        results.close();
    }

    public boolean isOpen() throws DBIException {
        try {
            return !this.conn.isClosed();
        }
        catch (SQLException e) {
            throw new DBIException("exception while querying for open state: " + e.getMessage(), e);
        }
    }

    public void script(String name) throws DBIException, IOException {
        new Script(this, name).run();
    }

    public void name(String name, String sql) throws DBIException {
        this.cache.name(name, sql);
    }

    public void load(String name) throws IOException, DBIException {
        String sql = this.cache.load(name);
        this.cache.name(name, sql);
    }

    public Batch batch() {
        return new QueueingBatch(this.getConnection());
    }

    public PreparedBatch prepareBatch(String statement) {
        try {
            return new QueueingPreparedBatch(this.cache.find(statement), this.cache.parametersFor(statement), this.cache.getGlobals());
        }
        catch (DBIException e) {
            throw new DBIError(e.getMessage(), e);
        }
    }

    public Map getGlobalParameters() {
        return this.cache.getGlobals();
    }
}

